/*
 * JBoss, Home of Professional Open Source
 * Copyright 2008, Red Hat Middleware LLC, and individual contributors
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.test.managed.factory.support.defaults;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Properties;

import javax.management.ObjectName;

import org.jboss.managed.api.annotation.ConstraintsPopulatorFactory;
import org.jboss.managed.api.annotation.DefaultValueBuilderFactory;
import org.jboss.managed.api.annotation.ManagementObject;
import org.jboss.managed.api.annotation.ManagementProperty;
import org.jboss.managed.plugins.constraints.NumberConstraintsPopulatorFactory;
import org.jboss.managed.plugins.constraints.StringLegalValuesPopulatorFactory;
import org.jboss.metatype.api.annotations.MetaMapping;
import org.jboss.metatype.plugins.values.defaults.PropertiesCompositeObjectNameDefaultBuilder;
import org.jboss.metatype.plugins.values.defaults.PropertiesObjectNameDefaultValueBuilder;
import org.jboss.metatype.plugins.values.defaults.StringObjectNameDefaultBuilder;
import org.jboss.metatype.plugins.values.mappers.PropertiesMetaMapper;
import org.jboss.metatype.plugins.values.mappers.PropertiesObjectNameMetaMapper;
import org.jboss.metatype.plugins.values.mappers.StringObjectNameMetaMapper;

/**
 * Test bean for validating defaults on managed properties
 * @author Scott.Stark@jboss.org
 * @version $Revision: 81573 $
 */
@ManagementObject
public class DefaultsBean
{
   private float temperature;
   private Float pi;
   private double temperatureD;
   private Double piD;
   private Short dayOfYear;
   private int day;
   private Integer century;
   private String month;
   private Properties props;
   private Properties props2;
   private long propLongPrimitive;
   private Long propLong;
   private BigDecimal propBD;
   private BigInteger propBI;
   private char propCharPrimitive;
   private Character propChar;
   private short propShortPrimitive;
   private byte propBytePrimitive;
   private Byte propByte;
   private boolean propBooleanPrimitive;
   private Boolean propBoolean;
   private ObjectName nameAsString;
   private ObjectName nameAsProperties;
   private ObjectName nameAsDefault;

   @ManagementProperty(defaultValue="domain1:key1=value1,key2=value2")
   @MetaMapping(StringObjectNameMetaMapper.class)
   @DefaultValueBuilderFactory(StringObjectNameDefaultBuilder.class)
   public ObjectName getNameAsString()
   {
      return nameAsString;
   }
   public void setNameAsString(ObjectName nameAsString)
   {
      this.nameAsString = nameAsString;
   }
   @ManagementProperty(defaultValue="domain1:key1=value1,key2=value2")
   @MetaMapping(PropertiesObjectNameMetaMapper.class)
   @DefaultValueBuilderFactory(PropertiesObjectNameDefaultValueBuilder.class)
   public ObjectName getNameAsProperties()
   {
      return nameAsProperties;
   }
   public void setNameAsProperties(ObjectName nameAsProperties)
   {
      this.nameAsProperties = nameAsProperties;
   }

   @ManagementProperty(defaultValue="domain1:key1=value1,key2=value2")
   @DefaultValueBuilderFactory(PropertiesCompositeObjectNameDefaultBuilder.class)
   public ObjectName getNameAsDefault()
   {
      return nameAsDefault;
   }
   public void setNameAsDefault(ObjectName nameAsDefault)
   {
      this.nameAsDefault = nameAsDefault;
   }

   @ManagementProperty(defaultValue="60")
   @ConstraintsPopulatorFactory(value=NumberConstraintsPopulatorFactory.class,
         min="0",max="100")
   public float getTemperature()
   {
      return temperature;
   }
   public void setTemperature(float temperature)
   {
      this.temperature = temperature;
   }
   @ManagementProperty(defaultValue="3.14")
   @ConstraintsPopulatorFactory(value=NumberConstraintsPopulatorFactory.class,
         min="3",max="3.14159")
   public Float getPi()
   {
      return pi;
   }
   public void setPi(Float pi)
   {
      this.pi = pi;
   }
   @ManagementProperty(defaultValue="1")
   @ConstraintsPopulatorFactory(value=NumberConstraintsPopulatorFactory.class,
         min="1",max="365")
   public Short getDayOfYear()
   {
      return dayOfYear;
   }
   public void setDayOfYear(Short dayOfYear)
   {
      this.dayOfYear = dayOfYear;
   }
   @ManagementProperty(defaultValue="JAN")
   @ConstraintsPopulatorFactory(value=StringLegalValuesPopulatorFactory.class,
         legalValues={"JAN", "FEB", "MAR", "APR", "MAY", "JUN", "JUL", "AUG", "SEP", "OCT", "NOV", "DEC"})
   public String getMonth()
   {
      return month;
   }
   public void setMonth(String month)
   {
      this.month = month;
   }
   @ManagementProperty(defaultValue="1")
   @ConstraintsPopulatorFactory(value=NumberConstraintsPopulatorFactory.class,
         min="1",max="31")
   public int getDay()
   {
      return day;
   }
   public void setDay(int day)
   {
      this.day = day;
   }
   @ManagementProperty(defaultValue="2000")
   public Integer getCentury()
   {
      return century;
   }
   public void setCentury(Integer century)
   {
      this.century = century;
   }
   @ManagementProperty(defaultValue="key1=value1,key2=value2")
   @MetaMapping(PropertiesMetaMapper.class)
   public Properties getProps()
   {
      return props;
   }
   public void setProps(Properties props)
   {
      this.props = props;
   }
   @ManagementProperty(defaultValue="key1=props2-value1;key2=props2-value2")
   @MetaMapping(PropertiesMetaMapper.class)
   @DefaultValueBuilderFactory(CustomPropsBuilder.class)
   public Properties getProps2()
   {
      return props2;
   }
   public void setProps2(Properties props2)
   {
      this.props2 = props2;
   }
   
   @ManagementProperty(defaultValue="60.5")
   public double getTemperatureD()
   {
      return temperatureD;
   }
   public void setTemperatureD(double temperatureD)
   {
      this.temperatureD = temperatureD;
   }
   @ManagementProperty(defaultValue="3.14159265358979")
   public Double getPiD()
   {
      return piD;
   }
   public void setPiD(Double piD)
   {
      this.piD = piD;
   }
   @ManagementProperty(defaultValue="123456789")
   public long getPropLongPrimitive()
   {
      return propLongPrimitive;
   }
   public void setPropLongPrimitive(long propLongPrimitive)
   {
      this.propLongPrimitive = propLongPrimitive;
   }
   @ManagementProperty(defaultValue="123456789")
   public Long getPropLong()
   {
      return propLong;
   }
   public void setPropLong(Long propLong)
   {
      this.propLong = propLong;
   }
   @ManagementProperty(defaultValue="123456789.987654321")
   public BigDecimal getPropBD()
   {
      return propBD;
   }
   public void setPropBD(BigDecimal propBD)
   {
      this.propBD = propBD;
   }
   @ManagementProperty(defaultValue="123456789987654321")
   public BigInteger getPropBI()
   {
      return propBI;
   }
   public void setPropBI(BigInteger propBI)
   {
      this.propBI = propBI;
   }
   @ManagementProperty(defaultValue="c")
   public char getPropCharPrimitive()
   {
      return propCharPrimitive;
   }
   public void setPropCharPrimitive(char propCharPrimitive)
   {
      this.propCharPrimitive = propCharPrimitive;
   }
   @ManagementProperty(defaultValue="C")
   public Character getPropChar()
   {
      return propChar;
   }
   public void setPropChar(Character propChar)
   {
      this.propChar = propChar;
   }
   @ManagementProperty(defaultValue="1234")
   public short getPropShortPrimitive()
   {
      return propShortPrimitive;
   }
   public void setPropShortPrimitive(short propShortPrimitive)
   {
      this.propShortPrimitive = propShortPrimitive;
   }
   @ManagementProperty(defaultValue="10")
   public byte getPropBytePrimitive()
   {
      return propBytePrimitive;
   }
   public void setPropBytePrimitive(byte propBytePrimitive)
   {
      this.propBytePrimitive = propBytePrimitive;
   }
   @ManagementProperty(defaultValue="10")
   public Byte getPropByte()
   {
      return propByte;
   }
   public void setPropByte(Byte propByte)
   {
      this.propByte = propByte;
   }
   @ManagementProperty(defaultValue="true")
   public boolean isPropBooleanPrimitive()
   {
      return propBooleanPrimitive;
   }
   public void setPropBooleanPrimitive(boolean propBooleanPrimitive)
   {
      this.propBooleanPrimitive = propBooleanPrimitive;
   }
   @ManagementProperty(defaultValue="true")
   public Boolean getPropBoolean()
   {
      return propBoolean;
   }
   public void setPropBoolean(Boolean propBoolean)
   {
      this.propBoolean = propBoolean;
   }

   
}
