/*
* JBoss, Home of Professional Open Source
* Copyright 2007, JBoss Inc., and individual contributors as indicated
* by the @authors tag. See the copyright.txt in the distribution for a
* full listing of individual contributors.
*
* This is free software; you can redistribute it and/or modify it
* under the terms of the GNU Lesser General Public License as
* published by the Free Software Foundation; either version 2.1 of
* the License, or (at your option) any later version.
*
* This software is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this software; if not, write to the Free
* Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
* 02110-1301 USA, or see the FSF site: http://www.fsf.org.
*/
package org.jboss.test.managed.factory.test;

import java.util.Map;

import junit.framework.Test;

import org.jboss.managed.api.DeploymentTemplateInfo;
import org.jboss.managed.api.ManagedObject;
import org.jboss.managed.api.ManagedProperty;
import org.jboss.managed.plugins.factory.DeploymentTemplateInfoFactory;
import org.jboss.metatype.api.types.SimpleMetaType;
import org.jboss.metatype.api.values.MetaValue;
import org.jboss.metatype.api.values.SimpleValueSupport;
import org.jboss.test.managed.factory.AbstractManagedObjectFactoryTest;
import org.jboss.test.managed.factory.support.JmsDestinationTemplateInfo;
import org.jboss.test.managed.factory.support.ObjectNameBean;
import org.jboss.test.managed.factory.support.template.ManagementObjectExplicit;


/**
 * DeploymentTemplateInfo factory tests.
 * 
 * @author Scott.Stark@jboss.org
 * @version $Revision: 86636 $
 */
public class DeploymentTemplateInfoUnitTestCase extends AbstractManagedObjectFactoryTest
{
   /**
    * Create a testsuite for this test
    * 
    * @return the testsuite
    */
   public static Test suite()
   {
      return suite(DeploymentTemplateInfoUnitTestCase.class);
   }

   /**
    * Create a new DeploymentTemplateInfoUnitTestCase.
    * 
    * @param name the test name
    */
   public DeploymentTemplateInfoUnitTestCase(String name)
   {
      super(name);
   }
   
   /**
    * Test Explicit properties included
    */
   public void testExplicit()
   {
      ManagedObject managedObject = createManagedObject(ManagementObjectExplicit.class);
      checkManagedObjectDefaults(ManagementObjectExplicit.class, managedObject);
      checkManagedProperties(managedObject, "property1");
      DeploymentTemplateInfoFactory factory = new DeploymentTemplateInfoFactory();
      DeploymentTemplateInfo info = factory.createTemplateInfo(managedObject, "testExplicit", "testExplicit");
      log.info(info);
      assertEquals("testExplicit", info.getName());
      assertEquals("testExplicit", info.getDescription());
      assertTrue("property1 is in template info", info.getProperties().containsKey("property1"));
   }
   public void testReflectionOfExplicit()
      throws Exception
   {
      DeploymentTemplateInfoFactory factory = new DeploymentTemplateInfoFactory();
      DeploymentTemplateInfo info = factory.createTemplateInfo(ManagementObjectExplicit.class, "testReflectionOfExplicit", "testReflectionOfExplicit");
      log.info(info);
      assertEquals("testReflectionOfExplicit", info.getName());
      assertEquals("testReflectionOfExplicit", info.getDescription());
      assertTrue("property1 is in template info", info.getProperties().containsKey("property1"));      
   }
   /**
    * Validate that the template factory honors the MetaMappings for ObjectName
    */
   public void testReflectionOfObjectName()
      throws Exception
   {
      DeploymentTemplateInfoFactory factory = new DeploymentTemplateInfoFactory();
      DeploymentTemplateInfo info = factory.createTemplateInfo(ObjectNameBean.class, "testReflectionOfObjectName", "testReflectionOfObjectName");
      log.info(info);
      assertEquals("testReflectionOfObjectName", info.getName());
      assertEquals("testReflectionOfObjectName", info.getDescription());
      Map<String, ManagedProperty> props = info.getProperties();
      ManagedProperty nameAsString = props.get("nameAsString");
      assertNotNull(nameAsString);
      assertEquals(SimpleMetaType.STRING, nameAsString.getMetaType());
   }

   public void testCopy()
   {
      ManagementObjectExplicit explicit = new ManagementObjectExplicit();
      explicit.setProperty1("value1-orig");
      ManagedObject managedObject = super.initManagedObject(explicit);

      DeploymentTemplateInfoFactory factory = new DeploymentTemplateInfoFactory();
      DeploymentTemplateInfo info1 = factory.createTemplateInfo(managedObject, "testExplicit", "testExplicit");
      log.info(info1);
      assertEquals("testExplicit", info1.getName());
      assertEquals("testExplicit", info1.getDescription());
      assertTrue("property1 is in template info", info1.getProperties().containsKey("property1"));
      ManagedProperty property1 = managedObject.getProperty("property1");
      
      DeploymentTemplateInfo info1_1 = info1.copy();
      log.info(info1);
      assertEquals("testExplicit", info1.getName());
      assertEquals("testExplicit", info1.getDescription());
      assertTrue("property1 is in template info", info1.getProperties().containsKey("property1"));

      Map<String, ManagedProperty> props1 = info1.getProperties();
      ManagedProperty iproperty1 = props1.get("property1");
      assertNotNull(iproperty1);
      iproperty1.setValue(SimpleValueSupport.wrap("value1-copy"));

      Map<String, ManagedProperty> props1_1 = info1_1.getProperties();
      assertTrue("info1.props != info1_1.props", props1 != props1_1);
      assertEquals("props size", props1.size(), props1_1.size());
      ManagedProperty iproperty1_1 = props1_1.get("property1");
      assertNotNull("info1.copy property1", iproperty1_1);
      assertTrue("property1 != property1_1", iproperty1 != iproperty1_1);
      assertTrue(property1.getFields() != iproperty1_1.getFields());
      MetaValue value1 = iproperty1.getValue();
      MetaValue value1_1 = iproperty1_1.getValue();
      assertTrue(value1 != value1_1);
      assertEquals("property1.value", SimpleValueSupport.wrap("value1-copy"), value1);
      assertEquals("property1_1.value", SimpleValueSupport.wrap("value1-orig"), value1_1);
   }

   public void testSubclassCopy()
   {
      JmsDestinationTemplateInfo info = new JmsDestinationTemplateInfo("testSubclassCopy", "testSubclassCopy", "queue");
      ManagedProperty jndiName = info.getProperties().get("JNDIName");
      jndiName.setValue(SimpleValueSupport.wrap("testSubclassCopy"));
      JmsDestinationTemplateInfo info2 = info.copy();
      jndiName.setValue(SimpleValueSupport.wrap("testSubclassCopy-updated"));
      ManagedProperty jndiName2 = info2.getProperties().get("JNDIName");
      MetaValue value = jndiName.getValue();
      MetaValue value2 = jndiName2.getValue();

      assertTrue(info.getProperties() != info2.getProperties());
      assertTrue(jndiName != jndiName2);
      assertTrue(jndiName.getFields() != jndiName2.getFields());
      assertTrue(value != value2);
      assertEquals("jndiName", SimpleValueSupport.wrap("testSubclassCopy-updated"), jndiName.getValue());
      assertEquals("jndiName2", SimpleValueSupport.wrap("testSubclassCopy"), value2);
   }
}
