/*
 * JBoss, Home of Professional Open Source
 * Copyright 2009, Red Hat Middleware LLC, and individual contributors
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.test.metatype.values.factory.support;

/**
 * Bean for testing JBMAN-50
 * 
 * @author Scott.Stark@jboss.org
 * @version $Revision:$
 */
public class AbstractPropertyMetaData
{
   private static final long serialVersionUID = 3L;

   /** The property name */
   protected String name;

   /** The preinstantiate */
   protected boolean preInstantiate = true;

   /** The property type */
   protected String type;
   
   /** The property replace */
   private Boolean replace;
   
   /** Whether to trim */
   private Boolean trim;
   
   /**
    * Create a new property meta data
    */
   public AbstractPropertyMetaData()
   {
   }

   public String getName()
   {
      return name;
   }

   public void setName(String name)
   {
      this.name = name;
   }

   public String getType()
   {
      return type;
   }

   public boolean isPreInstantiate()
   {
      return preInstantiate;
   }

   public void setPreInstantiate(boolean preInstantiate)
   {
      this.preInstantiate = preInstantiate;
   }

   public String getPropertyType()
   {
      return type;
   }
   
   public void setPropertyType(String type)
   {
      this.type = type;
   }

   public void setPropertyReplace(boolean replace)
   {
      this.replace = replace;
   }

   public void setPropertyTrim(boolean trim)
   {
      this.trim = trim;
   }

}
