/*
 * JBoss, Home of Professional Open Source
 * Copyright 2008, Red Hat Middleware LLC, and individual contributors
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.test.managed.factory.support.amof;

import java.io.Serializable;
import java.util.Map;

import org.jboss.config.spi.Configuration;
import org.jboss.managed.api.ManagedObject;
import org.jboss.managed.api.MutableManagedObject;
import org.jboss.managed.plugins.factory.AbstractManagedObjectPopulator;
import org.jboss.managed.spi.factory.InstanceClassFactory;
import org.jboss.managed.spi.factory.ManagedObjectPopulator;
import org.jboss.metadata.spi.MetaData;

/**
 * @author Scott.Stark@jboss.org
 * @version $Revision: 80512 $
 */
public class TestMOP extends AbstractManagedObjectPopulator<Serializable>
   implements ManagedObjectPopulator<Serializable>
{
   private boolean createObjectCalled;
   private boolean populateManagedObjectCalled;

   public TestMOP(Configuration configuration,
         InstanceClassFactory<?> defaultInstanceFactory,
         Map<Class<?>, InstanceClassFactory<?>> instanceFactories)
   {
      super(configuration, defaultInstanceFactory, instanceFactories);
   }
   public TestMOP(Configuration configuration)
   {
      super(configuration);
   }

   @Override
   public void createObject(ManagedObject managedObject,
         Class<Serializable> clazz)
   {
      createObjectCalled = true;
      super.createObject(managedObject, clazz);
   }
   @Override
   public void createObject(ManagedObject managedObject,
         Class<Serializable> clazz, MetaData metaData)
   {
      createObjectCalled = true;
      super.createObject(managedObject, clazz, metaData);
   }

   @Override
   public void populateManagedObject(MutableManagedObject managedObject,
         Serializable object)
   {
      populateManagedObjectCalled = true;
      super.populateManagedObject(managedObject, object);
   }
   @Override
   public void populateManagedObject(MutableManagedObject managedObject,
         Serializable object, MetaData metaData)
   {
      populateManagedObjectCalled = true;
      super.populateManagedObject(managedObject, object, metaData);
   }

   public boolean isCreateObjectCalled()
   {
      return createObjectCalled;
   }
   public boolean isPopulateManagedObjectCalled()
   {
      return populateManagedObjectCalled;
   }
}
