/*
 * JBoss, Home of Professional Open Source
 * Copyright 2008, Red Hat Middleware LLC, and individual contributors
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.test.managed.factory.test;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;

import javax.management.ObjectName;

import org.jboss.managed.api.ManagedObject;
import org.jboss.managed.api.ManagedProperty;
import org.jboss.metatype.api.types.CompositeMetaType;
import org.jboss.metatype.api.types.MetaType;
import org.jboss.metatype.api.types.PropertiesMetaType;
import org.jboss.metatype.api.types.SimpleMetaType;
import org.jboss.metatype.api.values.MapCompositeValueSupport;
import org.jboss.metatype.api.values.MetaValue;
import org.jboss.metatype.api.values.PropertiesMetaValue;
import org.jboss.metatype.api.values.SimpleValue;
import org.jboss.metatype.api.values.SimpleValueSupport;
import org.jboss.metatype.spi.values.MetaMapper;
import org.jboss.test.managed.factory.AbstractManagedObjectFactoryTest;
import org.jboss.test.managed.factory.support.ConstrainedBean;
import org.jboss.test.managed.factory.support.ObjectNameBean;

/**
 * Tests of specifying constraints on managed properties
 * @author Scott.Stark@jboss.org
 * @version $Revision:$
 */
public class PropertyConstraintsUnitTestCase extends AbstractManagedObjectFactoryTest
{

   public PropertyConstraintsUnitTestCase(String name)
   {
      super(name);
   }

   public void testTemperature()
      throws Exception
   {
      ConstrainedBean bean = new ConstrainedBean();
      ManagedObject managedObject = super.initManagedObject(bean);

      // Test the temperature constraints
      ManagedProperty temperature = managedObject.getProperty("temperature");
      SimpleValue minValue = (SimpleValue) temperature.getMinimumValue();
      assertNotNull(minValue);
      getLog().debug("min: "+minValue);
      int compare = minValue.compareTo(SimpleValueSupport.wrap(0f));
      assertTrue("temperature >= 0; "+compare, compare == 0);
      compare = minValue.compareTo(SimpleValueSupport.wrap(0.1f));
      assertTrue("temperature 0.1 > min; "+compare, compare < 0);
      compare = minValue.compareTo(SimpleValueSupport.wrap(-0.1f));
      assertTrue("temperature -0.1 < min; "+compare, compare > 0);
      compare = minValue.compareTo(SimpleValueSupport.wrap(50f));
      assertTrue("temperature 50 > min; "+compare, compare < 0);
      compare = minValue.compareTo(SimpleValueSupport.wrap(-50f));
      assertTrue("temperature -50 < min; "+compare, compare > 0);
      SimpleValue maxValue = (SimpleValue) temperature.getMaximumValue();
      assertNotNull(maxValue);
      getLog().debug("max: "+maxValue);
      compare = maxValue.compareTo(SimpleValueSupport.wrap(100f));
      assertTrue("temperature <= 100; "+compare, compare == 0);
      compare = maxValue.compareTo(SimpleValueSupport.wrap(50f));
      assertTrue("temperature 50 < max; "+compare, compare > 0);
      compare = maxValue.compareTo(SimpleValueSupport.wrap(150f));
      assertTrue("temperature 150 > max; "+compare, compare < 0);

      String check = temperature.checkValidValue(SimpleValueSupport.wrap(100f));
      assertNull(check, check);
      check = temperature.checkValidValue(SimpleValueSupport.wrap(1f));
      assertNull(check, check);
      check = temperature.checkValidValue(SimpleValueSupport.wrap(-1f));
      assertNotNull(check, check);
      
   }

   public void testMonth()
   {
      ConstrainedBean bean = new ConstrainedBean();
      ManagedObject managedObject = super.initManagedObject(bean);

      // Test the month constraints
      ManagedProperty month = managedObject.getProperty("month");
      Set<MetaValue> legalValues = month.getLegalValues();
      assertEquals("There are 12 legal values", 12, legalValues.size());
      MetaValue JUN = SimpleValueSupport.wrap("JUN");
      assertTrue("JUN", legalValues.contains(JUN));

      String check = month.checkValidValue(JUN);
      assertNull(check, check);
      check = month.checkValidValue(SimpleValueSupport.wrap("XYZ"));
      assertNotNull("XYZ", check);
   }
   
}
