/*
 * JBoss, Home of Professional Open Source
 * Copyright 2008, Red Hat Middleware LLC, and individual contributors
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.managed.plugins.jmx;

import java.lang.management.ClassLoadingMXBean;
import java.lang.management.ManagementFactory;

import org.jboss.managed.api.annotation.ManagementComponent;
import org.jboss.managed.api.annotation.ManagementObject;
import org.jboss.managed.api.annotation.ManagementProperty;

/**
 * Stub class for the ClassLoadingMXBean interface that is marked up with
 * management annotations.
 * 
 * @author Scott.Stark@jboss.org
 * @version $Revision:$
 */
@ManagementObject(name=ManagementFactory.CLASS_LOADING_MXBEAN_NAME,
      isRuntime=true,
      componentType=@ManagementComponent(type="MBean", subtype="Platform"),
      targetInterface=ClassLoadingMXBean.class)
public class ClassLoadingMXBeanMO implements ClassLoadingMXBean
{
   @ManagementProperty(description="the number of currently loaded classes.")
   public int getLoadedClassCount()
   {
      return 0;
   }

   @ManagementProperty(description="the total number of classes loaded.")
   public long getTotalLoadedClassCount()
   {
      return 0;
   }

   @ManagementProperty(description="the total number of unloaded classes.")
   public long getUnloadedClassCount()
   {
      return 0;
   }

   @ManagementProperty(description="the verbose output flag for the class loading system.")
   public boolean isVerbose()
   {
      return false;
   }

   public void setVerbose(boolean value)
   {
   }
}
