/*
 * JBoss, Home of Professional Open Source
 * Copyright 2009, Red Hat Middleware LLC, and individual contributors
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.metatype.plugins.values.defaults;

import java.util.Properties;

import org.jboss.metatype.api.types.MetaType;
import org.jboss.metatype.api.types.PropertiesMetaType;
import org.jboss.metatype.api.values.MetaValue;
import org.jboss.metatype.api.values.PropertiesMetaValue;
import org.jboss.metatype.spi.values.DefaultValueBuilder;

/**
 * A DefaultValueBuilder for java.util.Properties
 * 
 * @author Scott.Stark@jboss.org
 * @version $Revision:$
 */
public class PropertiesDefaultValueBuilder
   implements DefaultValueBuilder
{
   public MetaType getType()
   {
      return PropertiesMetaType.INSTANCE;
   }
   /**
    * @param metaType - a PropertiesMetaType
    * @param value - a comma separated list of key=value pairs
    */
   public MetaValue buildMetaValue(String value)
         throws Exception
   {
      Properties props = new Properties();
      String[] pairs = value.split(",");
      for(int n = 0; n < pairs.length; n ++)
      {
         String[] kv = pairs[n].split("=");
         props.put(kv[0], kv[1]);
      }
      PropertiesMetaValue metaValue = new PropertiesMetaValue(props);
      return metaValue;
   }

}
