/*
 * JBoss, Home of Professional Open Source
 * Copyright 2008, Red Hat Middleware LLC, and individual contributors
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.test.metatype.types.support;

import java.lang.reflect.Type;

import org.jboss.metatype.api.types.MapCompositeMetaType;
import org.jboss.metatype.api.types.MetaType;
import org.jboss.metatype.api.types.SimpleMetaType;
import org.jboss.metatype.api.values.CompositeValue;
import org.jboss.metatype.api.values.MapCompositeValueSupport;
import org.jboss.metatype.api.values.MetaValue;
import org.jboss.metatype.api.values.SimpleValue;
import org.jboss.metatype.api.values.SimpleValueSupport;
import org.jboss.metatype.spi.values.MetaMapper;

/**
 * A MetaMapper implementation for the MetaMappingUsage bean that converts
 * to from a MapCompositeMetaType
 * 
 * @author Scott.Stark@jboss.org
 * @version $Revision:$
 */
public class BeanMetaMapper extends MetaMapper<MetaMappingUsage>
{
   MapCompositeMetaType type;

   public BeanMetaMapper()
   {
      type = new MapCompositeMetaType(SimpleMetaType.STRING);
      type.addItem("name", "the name of the bean");
      type.addItem("value", "the string value of the bean");
      type.addItem("type", "the type name of the value");
   }

   @Override
   public MetaType getMetaType()
   {
      return type;
   }
   @Override
   public Type mapToType()
   {
      return BeanMetaMapper.class;
   }

   @Override
   public MetaValue createMetaValue(MetaType metaType, MetaMappingUsage object)
   {
      MapCompositeValueSupport metaValue = new MapCompositeValueSupport(SimpleMetaType.STRING); 
      metaValue.put("name", SimpleValueSupport.wrap(object.getName()));
      metaValue.put("value", SimpleValueSupport.wrap(object.getValue()));
      metaValue.put("type", SimpleValueSupport.wrap(object.getType()));
      return metaValue;
   }

   @Override
   public MetaMappingUsage unwrapMetaValue(MetaValue metaValue)
   {
      MetaMappingUsage bean = new MetaMappingUsage();
      CompositeValue cv = (CompositeValue) metaValue;
      SimpleValue name = (SimpleValue) cv.get("name");
      SimpleValue value = (SimpleValue) cv.get("value");
      SimpleValue type = (SimpleValue) cv.get("value");
      bean.setName((String) name.getValue());
      bean.setValue((String) value.getValue());
      bean.setType((String) type.getValue());
      return bean;
   }

}
