/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.managed.bean.mc.deployer;

import java.util.Collection;
import org.jboss.beans.metadata.api.annotations.Inject;
import org.jboss.beans.metadata.plugins.builder.BeanMetaDataBuilderFactory;
import org.jboss.beans.metadata.spi.BeanMetaData;
import org.jboss.beans.metadata.spi.builder.BeanMetaDataBuilder;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.spi.deployer.DeploymentStages;
import org.jboss.deployers.spi.deployer.helpers.AbstractDeployer;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.managed.bean.impl.manager.ManagedBeanManagerImpl;
import org.jboss.managed.bean.metadata.ManagedBeanDeploymentMetaData;
import org.jboss.managed.bean.metadata.ManagedBeanMetaData;
import org.jboss.reloaded.naming.deployers.javaee.JavaEEComponentInformer;

public class ManagedBeanManagerDeployer
extends AbstractDeployer {
    private JavaEEComponentInformer javaeeComponentInformer;

    public ManagedBeanManagerDeployer() {
        this.setStage(DeploymentStages.REAL);
        this.setInput(ManagedBeanDeploymentMetaData.class);
        this.setOutput(BeanMetaData.class);
    }

    @Inject
    public void setJavaEEComponentInformer(JavaEEComponentInformer componentInformer) {
        this.javaeeComponentInformer = componentInformer;
    }

    public void deploy(DeploymentUnit unit) throws DeploymentException {
        ManagedBeanDeploymentMetaData managedBeanDeployment = (ManagedBeanDeploymentMetaData)unit.getAttachment(ManagedBeanDeploymentMetaData.class);
        Collection managedBeans = managedBeanDeployment.getManagedBeans();
        if (managedBeans == null || managedBeans.isEmpty()) {
            return;
        }
        for (ManagedBeanMetaData managedBean : managedBeans) {
            this.deploy(unit, managedBean);
        }
    }

    private void deploy(DeploymentUnit unit, ManagedBeanMetaData managedBean) throws DeploymentException {
        Class<?> beanClass;
        try {
            beanClass = this.getBeanClass(unit, managedBean);
        }
        catch (ClassNotFoundException cnfe) {
            throw new DeploymentException("Could not load managed bean class " + managedBean.getManagedBeanClass() + " in unit " + unit, (Throwable)cnfe);
        }
        String managedBeanManagerMCBeanName = this.getManagedBeanManagerMCBeanName(unit, managedBean);
        ManagedBeanManagerImpl managedBeanManager = new ManagedBeanManagerImpl(beanClass, managedBean);
        BeanMetaDataBuilder builder = BeanMetaDataBuilderFactory.createBuilder((String)managedBeanManagerMCBeanName, (String)ManagedBeanManagerImpl.class.getName());
        builder.setConstructorValue((Object)managedBeanManager);
        unit.addAttachment(BeanMetaData.class + ":" + managedBeanManagerMCBeanName, (Object)builder.getBeanMetaData(), BeanMetaData.class);
    }

    private Class<?> getBeanClass(DeploymentUnit unit, ManagedBeanMetaData managedBean) throws ClassNotFoundException {
        ClassLoader cl = unit.getClassLoader();
        return Class.forName(managedBean.getManagedBeanClass(), false, cl);
    }

    private String getManagedBeanManagerMCBeanName(DeploymentUnit deploymentUnit, ManagedBeanMetaData managedBean) {
        StringBuilder sb = new StringBuilder("org.jboss.managedbean:");
        String applicationName = this.javaeeComponentInformer.getApplicationName(deploymentUnit);
        String moduleName = this.javaeeComponentInformer.getModuleName(deploymentUnit);
        if (applicationName != null) {
            sb.append("application=");
            sb.append(applicationName);
        }
        sb.append("module=");
        sb.append(moduleName);
        sb.append("name=");
        sb.append(managedBean.getName());
        return sb.toString();
    }
}

