/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.managed.bean.metadata.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jboss.interceptor.spi.metadata.InterceptorMetadata;
import org.jboss.interceptor.spi.model.InterceptionType;
import org.jboss.managed.bean.metadata.ManagedBeanMetaData;
import org.jboss.managed.bean.metadata.MethodMetadata;

public class ManagedBeanMetaDataImpl
implements ManagedBeanMetaData {
    private String managedBeanClass;
    private String managedBeanName;
    private List<InterceptorMetadata> interceptors;
    private MethodMetadata postConstructMethod;

    public String getManagedBeanClass() {
        return this.managedBeanClass;
    }

    public String getName() {
        return this.managedBeanName;
    }

    public MethodMetadata getPreDestroyMethod() {
        return null;
    }

    public MethodMetadata getPostConstructMethod() {
        return this.postConstructMethod;
    }

    public void setPostConstructMethod(MethodMetadata method) {
        this.postConstructMethod = method;
    }

    public void setManagedBeanClass(String managedBeanClass) {
        this.managedBeanClass = managedBeanClass;
    }

    public void setName(String name) {
        this.managedBeanName = name;
    }

    public List<InterceptorMetadata> getInterceptors() {
        if (this.interceptors == null) {
            return Collections.EMPTY_LIST;
        }
        return this.interceptors;
    }

    public List<InterceptorMetadata> getAroundInvokeInterceptors() {
        return this.getInterceptors(InterceptionType.AROUND_INVOKE);
    }

    public List<InterceptorMetadata> getPostConstructInterceptors() {
        return this.getInterceptors(InterceptionType.POST_CONSTRUCT);
    }

    public void setInterceptors(Collection<InterceptorMetadata> interceptors) {
        this.interceptors = new ArrayList<InterceptorMetadata>(interceptors);
    }

    public void addInterceptor(InterceptorMetadata interceptor) {
        if (this.interceptors == null) {
            this.interceptors = new ArrayList<InterceptorMetadata>();
        }
        this.interceptors.add(interceptor);
    }

    private List<InterceptorMetadata> getInterceptors(InterceptionType interceptionType) {
        if (this.interceptors == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<InterceptorMetadata> applicableInterceptors = new ArrayList<InterceptorMetadata>();
        for (InterceptorMetadata interceptor : this.interceptors) {
            if (!interceptor.isEligible(interceptionType)) continue;
            applicableInterceptors.add(interceptor);
        }
        return applicableInterceptors;
    }
}

