/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.marshalling.serial;

import java.io.EOFException;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.StreamCorruptedException;
import org.jboss.marshalling.ByteInput;
import org.jboss.marshalling.Marshalling;
import org.jboss.marshalling.UTFUtils;
import org.jboss.marshalling.Unmarshaller;
import org.jboss.marshalling.serial.ExtendedObjectStreamConstants;
import org.jboss.marshalling.serial.SerialUnmarshaller;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class BlockUnmarshaller
implements Unmarshaller,
ExtendedObjectStreamConstants {
    private final SerialUnmarshaller serialUnmarshaller;
    private int remaining;

    BlockUnmarshaller(SerialUnmarshaller serialUnmarshaller) {
        this.serialUnmarshaller = serialUnmarshaller;
    }

    boolean inBlock() {
        return this.remaining > 0;
    }

    int remaining() {
        return this.remaining;
    }

    void endOfStream() {
        if (this.remaining != 0) {
            throw new IllegalStateException("Not at end of block");
        }
        this.remaining = -1;
    }

    void unblock() {
        if (this.remaining == -1) {
            this.remaining = 0;
        }
    }

    void readBlockHeader(int leadByte) throws IOException {
        switch (leadByte) {
            case 119: {
                this.remaining = this.serialUnmarshaller.readUnsignedByte();
                return;
            }
            case 122: {
                int len = this.serialUnmarshaller.readInt();
                if (len < 0) {
                    throw new StreamCorruptedException("Invalid block length");
                }
                this.remaining = len;
                return;
            }
            case 120: {
                this.remaining = -1;
                return;
            }
        }
        throw this.badLeadByte(leadByte);
    }

    void readToEndBlockData() throws IOException, ClassNotFoundException {
        block5: while (true) {
            if (this.remaining > 0) {
                this.skipBytes(this.remaining);
                continue;
            }
            if (this.remaining == -1) {
                return;
            }
            int b = this.serialUnmarshaller.read();
            switch (b) {
                case -1: {
                    this.remaining = -1;
                    return;
                }
                case 120: {
                    this.remaining = -1;
                    return;
                }
                case 119: 
                case 122: {
                    this.readBlockHeader(b);
                    continue block5;
                }
            }
            this.serialUnmarshaller.doReadObject(b, false);
        }
    }

    private StreamCorruptedException badLeadByte(int leadByte) {
        return new StreamCorruptedException("Unexpected lead byte " + leadByte);
    }

    public Object readObjectUnshared() throws ClassNotFoundException, IOException {
        return this.readObject(true);
    }

    public Object readObject() throws ClassNotFoundException, IOException {
        return this.readObject(false);
    }

    private Object readObject(boolean unshared) throws ClassNotFoundException, IOException {
        if (this.remaining > 0) {
            throw Marshalling.createOptionalDataException((int)this.remaining);
        }
        if (this.remaining == -1) {
            throw Marshalling.createOptionalDataException((boolean)true);
        }
        int leadByte = this.serialUnmarshaller.read();
        if (leadByte == -1 || leadByte == 120) {
            this.remaining = -1;
            throw Marshalling.createOptionalDataException((boolean)true);
        }
        return this.serialUnmarshaller.doReadObject(leadByte, unshared);
    }

    public int read() throws IOException {
        while (this.remaining == 0) {
            int v = this.serialUnmarshaller.read();
            if (v == -1) {
                return -1;
            }
            this.readBlockHeader(v);
        }
        if (this.remaining == -1) {
            return -1;
        }
        --this.remaining;
        return this.serialUnmarshaller.read();
    }

    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    public int read(byte[] b, int off, int len) throws IOException {
        while (this.remaining == 0) {
            int v = this.serialUnmarshaller.read();
            if (v == -1) {
                return -1;
            }
            this.readBlockHeader(v);
        }
        int remaining = this.remaining;
        if (remaining == -1) {
            return -1;
        }
        int cnt = this.serialUnmarshaller.read(b, off, Math.min(remaining, len));
        this.remaining = remaining - cnt;
        return cnt;
    }

    public long skip(long n) throws IOException {
        while (this.remaining == 0) {
            int v = this.serialUnmarshaller.read();
            if (v == -1) {
                return -1L;
            }
            this.readBlockHeader(v);
        }
        int remaining = this.remaining;
        if (remaining == -1) {
            return -1L;
        }
        int cnt = this.serialUnmarshaller.skipBytes((int)Math.min((long)remaining, n));
        this.remaining = remaining - cnt;
        return cnt;
    }

    public int available() throws IOException {
        return Math.min(this.remaining, this.serialUnmarshaller.available());
    }

    public void readFully(byte[] b) throws IOException {
        Marshalling.readFully((ByteInput)this, (byte[])b);
    }

    public void readFully(byte[] b, int off, int len) throws IOException {
        Marshalling.readFully((ByteInput)this, (byte[])b, (int)off, (int)len);
    }

    public int skipBytes(int n) throws IOException {
        while (this.remaining == 0) {
            int v = this.serialUnmarshaller.read();
            if (v == -1) {
                return -1;
            }
            this.readBlockHeader(v);
        }
        int remaining = this.remaining;
        if (remaining == -1) {
            return -1;
        }
        int cnt = this.serialUnmarshaller.skipBytes(Math.min(remaining, n));
        this.remaining = remaining - cnt;
        return cnt;
    }

    public boolean readBoolean() throws IOException {
        while (this.remaining == 0) {
            this.readBlockHeader(this.serialUnmarshaller.readUnsignedByte());
        }
        if (this.remaining == -1) {
            throw new EOFException();
        }
        --this.remaining;
        return this.serialUnmarshaller.readBoolean();
    }

    public byte readByte() throws IOException {
        while (this.remaining == 0) {
            this.readBlockHeader(this.serialUnmarshaller.readUnsignedByte());
        }
        if (this.remaining == -1) {
            throw new EOFException();
        }
        --this.remaining;
        return this.serialUnmarshaller.readByte();
    }

    public int readUnsignedByte() throws IOException {
        while (this.remaining == 0) {
            this.readBlockHeader(this.serialUnmarshaller.readUnsignedByte());
        }
        if (this.remaining == -1) {
            throw new EOFException();
        }
        --this.remaining;
        return this.serialUnmarshaller.readUnsignedByte();
    }

    public short readShort() throws IOException {
        if (this.remaining < 2) {
            return (short)(this.readUnsignedByte() << 8 | this.readUnsignedByte());
        }
        this.remaining -= 2;
        return this.serialUnmarshaller.readShort();
    }

    public int readUnsignedShort() throws IOException {
        if (this.remaining < 2) {
            return this.readUnsignedByte() << 8 | this.readUnsignedByte();
        }
        this.remaining -= 2;
        return this.serialUnmarshaller.readUnsignedShort();
    }

    public char readChar() throws IOException {
        if (this.remaining < 2) {
            return (char)(this.readUnsignedByte() << 8 | this.readUnsignedByte());
        }
        this.remaining -= 2;
        return this.serialUnmarshaller.readChar();
    }

    public int readInt() throws IOException {
        if (this.remaining < 4) {
            return this.readUnsignedByte() << 24 | this.readUnsignedByte() << 16 | this.readUnsignedByte() << 8 | this.readUnsignedByte();
        }
        this.remaining -= 4;
        return this.serialUnmarshaller.readInt();
    }

    public long readLong() throws IOException {
        if (this.remaining < 8) {
            return (long)this.readUnsignedByte() << 56 | (long)this.readUnsignedByte() << 48 | (long)this.readUnsignedByte() << 40 | (long)this.readUnsignedByte() << 32 | (long)this.readUnsignedByte() << 24 | (long)this.readUnsignedByte() << 16 | (long)this.readUnsignedByte() << 8 | (long)this.readUnsignedByte();
        }
        this.remaining -= 8;
        return this.serialUnmarshaller.readLong();
    }

    public float readFloat() throws IOException {
        return Float.intBitsToFloat(this.readInt());
    }

    public double readDouble() throws IOException {
        return Double.longBitsToDouble(this.readLong());
    }

    public String readLine() throws IOException {
        throw new UnsupportedOperationException("readLine() is deprecated anyway!");
    }

    public String readUTF() throws IOException {
        int len = this.readUnsignedShort();
        return UTFUtils.readUTFBytesByByteCount((ByteInput)this, (long)len);
    }

    public void clearInstanceCache() throws IOException {
        throw new IllegalStateException("clearInstanceCache() may not be called in this context");
    }

    public void clearClassCache() throws IOException {
        throw new IllegalStateException("clearClassCache() may not be called in this context");
    }

    public void start(ByteInput newInput) throws IOException {
        throw new IllegalStateException("start() may not be called in this context");
    }

    public void finish() throws IOException {
        throw new IllegalStateException("finish() may not be called in this context");
    }

    public void close() throws IOException {
        throw new IllegalStateException("close() may not be called in this context");
    }

    public <T> T readObject(Class<T> type) throws ClassNotFoundException, IOException {
        Object obj = this.readObject(false);
        try {
            return type.cast(obj);
        }
        catch (ClassCastException e) {
            throw BlockUnmarshaller.wrongType(e, type, obj.getClass());
        }
    }

    public <T> T readObjectUnshared(Class<T> type) throws ClassNotFoundException, IOException {
        Object obj = this.readObject(true);
        try {
            return type.cast(obj);
        }
        catch (ClassCastException e) {
            throw BlockUnmarshaller.wrongType(e, type, obj.getClass());
        }
    }

    private static InvalidObjectException wrongType(ClassCastException e, Class<?> expected, Class<?> actual) {
        InvalidObjectException ioe = new InvalidObjectException("Object is of the wrong type (expected " + expected + ", got " + actual + ")");
        ioe.initCause(e);
        return ioe;
    }
}

