/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.marshalling.reflect;

import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.concurrent.atomic.AtomicReference;
import org.jboss.marshalling.reflect.SerializableClass;
import org.jboss.marshalling.util.Kind;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SerializableField {
    private final WeakReference<Class<?>> classRef;
    private final WeakReference<Class<?>> typeRef;
    private final AtomicReference<WeakReference<Field>> fieldRefRef = new AtomicReference();
    private final String name;
    private final boolean unshared;
    private final Kind kind;
    private volatile boolean missing;

    SerializableField(Class<?> clazz, Class<?> type, String name, boolean unshared) {
        this.classRef = new WeakReference(clazz);
        this.typeRef = new WeakReference(type);
        this.name = name;
        this.unshared = unshared;
        this.kind = type == Boolean.TYPE ? Kind.BOOLEAN : (type == Byte.TYPE ? Kind.BYTE : (type == Short.TYPE ? Kind.SHORT : (type == Integer.TYPE ? Kind.INT : (type == Long.TYPE ? Kind.LONG : (type == Character.TYPE ? Kind.CHAR : (type == Float.TYPE ? Kind.FLOAT : (type == Double.TYPE ? Kind.DOUBLE : Kind.OBJECT)))))));
    }

    private Field lookupField() {
        if (this.missing) {
            return null;
        }
        final Class clazz = (Class)this.classRef.get();
        if (clazz != null) {
            return AccessController.doPrivileged(new PrivilegedAction<Field>(){

                @Override
                public Field run() {
                    try {
                        return clazz.getDeclaredField(SerializableField.this.name);
                    }
                    catch (NoSuchFieldException e) {
                        SerializableField.this.missing = true;
                        return null;
                    }
                }
            });
        }
        throw new IllegalStateException("Class unloaded");
    }

    public Field getField() {
        final WeakReference<Field> fieldRef = this.fieldRefRef.get();
        if (fieldRef == null) {
            final Field field = this.lookupField();
            if (field != null) {
                this.fieldRefRef.compareAndSet(null, new WeakReference<Field>(field));
            }
            AccessController.doPrivileged(new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    field.setAccessible(true);
                    return null;
                }
            });
            return field;
        }
        Field field = (Field)fieldRef.get();
        if (field != null) {
            return field;
        }
        return AccessController.doPrivileged(new PrivilegedAction<Field>(){

            @Override
            public Field run() {
                WeakReference<Field> newFieldRef;
                Field newField = SerializableField.this.lookupField();
                if (newField == null) {
                    newFieldRef = null;
                } else {
                    newField.setAccessible(true);
                    newFieldRef = new WeakReference<Field>(newField);
                }
                SerializableField.this.fieldRefRef.compareAndSet(fieldRef, newFieldRef);
                return newField;
            }
        });
    }

    public String getName() {
        return this.name;
    }

    public boolean isUnshared() {
        return this.unshared;
    }

    public Kind getKind() {
        return this.kind;
    }

    public Class<?> getType() throws ClassNotFoundException {
        return SerializableClass.dereference(this.typeRef);
    }
}

