/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.river;

import java.util.Arrays;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class IdentityIntMap<T> {
    private int[] values;
    private Object[] keys;
    private int count;
    private int resizeCount;

    public IdentityIntMap(int initialCapacity, float loadFactor) {
        if (initialCapacity < 1) {
            throw new IllegalArgumentException("initialCapacity must be > 0");
        }
        if (loadFactor <= 0.0f || loadFactor >= 1.0f) {
            throw new IllegalArgumentException("loadFactor must be > 0.0 and < 1.0");
        }
        if (initialCapacity < 16) {
            initialCapacity = 16;
        } else {
            int c = Integer.highestOneBit(initialCapacity) - 1;
            initialCapacity = Integer.highestOneBit(initialCapacity + c);
        }
        this.keys = new Object[initialCapacity];
        this.values = new int[initialCapacity];
        this.resizeCount = (int)((double)initialCapacity * (double)loadFactor);
    }

    public IdentityIntMap(float loadFactor) {
        this(64, loadFactor);
    }

    public IdentityIntMap(int initialCapacity) {
        this(initialCapacity, 0.5f);
    }

    public IdentityIntMap() {
        this(0.5f);
    }

    public int get(T key, int defVal) {
        if (key == null) {
            throw new NullPointerException("key is null");
        }
        Object[] keys = this.keys;
        int mask = keys.length - 1;
        int hc = System.identityHashCode(key) & mask;
        Object v;
        while ((v = keys[hc]) != key) {
            if (v == null) {
                return defVal;
            }
            hc = hc + 1 & mask;
        }
        return this.values[hc];
    }

    public void put(T key, int value) {
        int hc;
        if (key == null) {
            throw new NullPointerException("key is null");
        }
        Object[] keys = this.keys;
        int mask = keys.length - 1;
        int[] values = this.values;
        int idx = hc = System.identityHashCode(key) & mask;
        while (true) {
            Object v;
            if ((v = keys[idx]) == null) {
                keys[idx] = key;
                values[idx] = value;
                if (++this.count > this.resizeCount) {
                    this.resize();
                }
                return;
            }
            if (v == key) {
                values[idx] = value;
                return;
            }
            idx = hc++ & mask;
        }
    }

    private final void resize() {
        Object[] oldKeys = this.keys;
        int oldsize = oldKeys.length;
        int[] oldValues = this.values;
        if (oldsize >= 0x40000000) {
            throw new IllegalStateException("Table full");
        }
        int newsize = oldsize << 1;
        int mask = newsize - 1;
        Object[] newKeys = new Object[newsize];
        int[] newValues = new int[newsize];
        this.keys = newKeys;
        this.values = newValues;
        if ((this.resizeCount <<= 1) == 0) {
            this.resizeCount = Integer.MAX_VALUE;
        }
        block0: for (int oi = 0; oi < oldsize; ++oi) {
            Object key = oldKeys[oi];
            if (key == null) continue;
            int ni = System.identityHashCode(key) & mask;
            while (true) {
                Object v;
                if ((v = newKeys[ni]) == null) {
                    newKeys[ni] = key;
                    newValues[ni] = oldValues[oi];
                    continue block0;
                }
                ni = ni + 1 & mask;
            }
        }
    }

    public void clear() {
        Arrays.fill(this.keys, null);
        this.count = 0;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Map length = ").append(this.keys.length).append(", count = ").append(this.count).append(", resize count = ").append(this.resizeCount).append('\n');
        for (int i = 0; i < this.keys.length; ++i) {
            builder.append('[').append(i).append("] = ");
            if (this.keys[i] != null) {
                int hc = System.identityHashCode(this.keys[i]);
                builder.append("{ ").append(this.keys[i]).append(" (hash ").append(hc).append(", modulus ").append(hc % this.keys.length).append(") => ").append(this.values[i]).append(" }");
            } else {
                builder.append("(blank)");
            }
            builder.append('\n');
        }
        return builder.toString();
    }
}

