/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.river;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.NotActiveException;
import java.io.ObjectInputStream;
import java.io.ObjectInputValidation;
import java.io.ObjectStreamClass;
import java.util.concurrent.atomic.AtomicReference;
import org.jboss.marshalling.MarshallerObjectInputStream;
import org.jboss.marshalling.Unmarshaller;
import org.jboss.marshalling.reflect.SerializableField;
import org.jboss.river.ReadField;
import org.jboss.river.RiverUnmarshaller;
import org.jboss.river.SerializableClassDescriptor;

public class RiverObjectInputStream
extends MarshallerObjectInputStream {
    private AtomicReference<State> state = new AtomicReference<State>(State.OFF);
    private final RiverUnmarshaller unmarshaller;
    private SerializableClassDescriptor serializableClassDescriptor;
    private Object current;

    protected RiverObjectInputStream(RiverUnmarshaller unmarshaller) throws IOException, SecurityException {
        super((Unmarshaller)unmarshaller);
        this.unmarshaller = unmarshaller;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void defaultReadObject() throws IOException, ClassNotFoundException {
        if (!this.state.compareAndSet(State.UNREAD_FIELDS, State.ON)) {
            throw new NotActiveException("defaultReadObject() may only be called when the fields have not yet been read");
        }
        try {
            this.unmarshaller.readFields(this.current, this.serializableClassDescriptor);
        }
        finally {
            this.serializableClassDescriptor = null;
            this.current = null;
        }
    }

    public ObjectInputStream.GetField readFields() throws IOException, ClassNotFoundException {
        if (!this.state.compareAndSet(State.UNREAD_FIELDS, State.ON)) {
            throw new NotActiveException("readFields() may only be called when the fields have not yet been read");
        }
        SerializableField[] streamFields = this.serializableClassDescriptor.getFields();
        int cnt = streamFields.length;
        final ReadField[] readFields = new ReadField[cnt];
        block11: for (int i = 0; i < cnt; ++i) {
            SerializableField field = streamFields[i];
            switch (field.getKind()) {
                case BOOLEAN: {
                    final boolean value = this.unmarshaller.readBoolean();
                    readFields[i] = new ReadField(field.getName(), false){

                        public boolean getBoolean() throws IOException {
                            return value;
                        }
                    };
                    continue block11;
                }
                case BYTE: {
                    final byte value = this.unmarshaller.readByte();
                    readFields[i] = new ReadField(field.getName(), false){

                        public byte getByte() throws IOException {
                            return value;
                        }
                    };
                    continue block11;
                }
                case CHAR: {
                    final char value = this.unmarshaller.readChar();
                    readFields[i] = new ReadField(field.getName(), false){

                        public char getChar() throws IOException {
                            return value;
                        }
                    };
                    continue block11;
                }
                case DOUBLE: {
                    final double value = this.unmarshaller.readDouble();
                    readFields[i] = new ReadField(field.getName(), false){

                        public double getDouble() throws IOException {
                            return value;
                        }
                    };
                    continue block11;
                }
                case FLOAT: {
                    final float value = this.unmarshaller.readFloat();
                    readFields[i] = new ReadField(field.getName(), false){

                        public float getFloat() throws IOException {
                            return value;
                        }
                    };
                    continue block11;
                }
                case INT: {
                    final int value = this.unmarshaller.readInt();
                    readFields[i] = new ReadField(field.getName(), false){

                        public int getInt() throws IOException {
                            return value;
                        }
                    };
                    continue block11;
                }
                case LONG: {
                    final long value = this.unmarshaller.readLong();
                    readFields[i] = new ReadField(field.getName(), false){

                        public long getLong() throws IOException {
                            return value;
                        }
                    };
                    continue block11;
                }
                case OBJECT: {
                    final Object value = this.unmarshaller.readObject();
                    readFields[i] = new ReadField(field.getName(), false){

                        public Object getObject() throws IOException {
                            return value;
                        }
                    };
                    continue block11;
                }
                case SHORT: {
                    final short value = this.unmarshaller.readShort();
                    readFields[i] = new ReadField(field.getName(), false){

                        public short getShort() throws IOException {
                            return value;
                        }
                    };
                    continue block11;
                }
                default: {
                    throw new IllegalStateException("Wrong field type");
                }
            }
        }
        return new ObjectInputStream.GetField(){

            public ObjectStreamClass getObjectStreamClass() {
                throw new UnsupportedOperationException("TODO...");
            }

            private ReadField find(String name) {
                if (name == null) {
                    throw new NullPointerException("name is null");
                }
                for (ReadField field : readFields) {
                    if (!name.equals(field.getName())) continue;
                    return field;
                }
                throw new IllegalArgumentException("No field named '" + name + "'");
            }

            public boolean defaulted(String name) throws IOException {
                return this.find(name).isDefaulted();
            }

            public boolean get(String name, boolean val) throws IOException {
                ReadField field = this.find(name);
                return field.isDefaulted() ? val : field.getBoolean();
            }

            public byte get(String name, byte val) throws IOException {
                ReadField field = this.find(name);
                return field.isDefaulted() ? val : field.getByte();
            }

            public char get(String name, char val) throws IOException {
                ReadField field = this.find(name);
                return field.isDefaulted() ? val : field.getChar();
            }

            public short get(String name, short val) throws IOException {
                ReadField field = this.find(name);
                return field.isDefaulted() ? val : field.getShort();
            }

            public int get(String name, int val) throws IOException {
                ReadField field = this.find(name);
                return field.isDefaulted() ? val : field.getInt();
            }

            public long get(String name, long val) throws IOException {
                ReadField field = this.find(name);
                return field.isDefaulted() ? val : field.getLong();
            }

            public float get(String name, float val) throws IOException {
                ReadField field = this.find(name);
                return field.isDefaulted() ? val : field.getFloat();
            }

            public double get(String name, double val) throws IOException {
                ReadField field = this.find(name);
                return field.isDefaulted() ? val : field.getDouble();
            }

            public Object get(String name, Object val) throws IOException {
                ReadField field = this.find(name);
                return field.isDefaulted() ? val : field.getObject();
            }
        };
    }

    public void registerValidation(ObjectInputValidation obj, int prio) throws NotActiveException, InvalidObjectException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SerializableClassDescriptor swapClass(SerializableClassDescriptor descriptor) {
        try {
            SerializableClassDescriptor serializableClassDescriptor = this.serializableClassDescriptor;
            return serializableClassDescriptor;
        }
        finally {
            this.serializableClassDescriptor = descriptor;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object swapCurrent(Object obj) {
        try {
            Object object = this.current;
            return object;
        }
        finally {
            this.current = obj;
        }
    }

    protected State start() {
        return this.state.getAndSet(State.UNREAD_FIELDS);
    }

    protected void finish(State restoreState) throws IOException {
        switch (this.state.getAndSet(restoreState)) {
            case OFF: {
                break;
            }
            case ON: {
                break;
            }
            case UNREAD_FIELDS: {
                throw new NotActiveException("Fields were never read");
            }
        }
    }

    protected void fullReset() {
        this.state.set(State.OFF);
        this.serializableClassDescriptor = null;
        this.current = null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum State {
        OFF,
        UNREAD_FIELDS,
        ON;

    }
}

