/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.river;

import java.io.IOException;
import java.io.NotActiveException;
import java.io.ObjectOutputStream;
import java.util.concurrent.atomic.AtomicReference;
import org.jboss.marshalling.Marshaller;
import org.jboss.marshalling.MarshallerObjectOutputStream;
import org.jboss.marshalling.reflect.SerializableClass;
import org.jboss.marshalling.reflect.SerializableField;
import org.jboss.river.BooleanFieldPutter;
import org.jboss.river.ByteFieldPutter;
import org.jboss.river.CharFieldPutter;
import org.jboss.river.DoubleFieldPutter;
import org.jboss.river.FieldPutter;
import org.jboss.river.FloatFieldPutter;
import org.jboss.river.IntFieldPutter;
import org.jboss.river.LongFieldPutter;
import org.jboss.river.ObjectFieldPutter;
import org.jboss.river.RiverMarshaller;
import org.jboss.river.RiverPutField;
import org.jboss.river.ShortFieldPutter;

public class RiverObjectOutputStream
extends MarshallerObjectOutputStream {
    private final boolean blockMode = false;
    private final AtomicReference<State> state = new AtomicReference<State>(State.OFF);
    private final RiverMarshaller marshaller;
    private RiverPutField putField;
    private SerializableClass serializableClass;
    private Object current;

    protected RiverObjectOutputStream(RiverMarshaller marshaller) throws IOException, SecurityException {
        super((Marshaller)marshaller);
        this.marshaller = marshaller;
    }

    public void writeFields() throws IOException {
        RiverPutField putField = this.putField;
        if (putField == null) {
            throw new NotActiveException("no current PutField object");
        }
        if (!this.state.compareAndSet(State.UNWRITTEN_FIELDS, State.ON)) {
            throw new NotActiveException("writeFields() may only be called when the fields have not yet been written");
        }
        this.putField = null;
        putField.write((Marshaller)this.marshaller);
    }

    public ObjectOutputStream.PutField putFields() throws IOException {
        if (this.state.get() == State.OFF) {
            throw new NotActiveException("No object is currently being serialized");
        }
        if (this.putField == null) {
            SerializableField[] serializableFields = this.serializableClass.getFields();
            int cnt = serializableFields.length;
            FieldPutter[] fields = new FieldPutter[cnt];
            String[] names = new String[cnt];
            block11: for (int i = 0; i < cnt; ++i) {
                SerializableField field = serializableFields[i];
                names[i] = field.getName();
                switch (field.getKind()) {
                    case BOOLEAN: {
                        fields[i] = new BooleanFieldPutter();
                        continue block11;
                    }
                    case BYTE: {
                        fields[i] = new ByteFieldPutter();
                        continue block11;
                    }
                    case CHAR: {
                        fields[i] = new CharFieldPutter();
                        continue block11;
                    }
                    case DOUBLE: {
                        fields[i] = new DoubleFieldPutter();
                        continue block11;
                    }
                    case FLOAT: {
                        fields[i] = new FloatFieldPutter();
                        continue block11;
                    }
                    case INT: {
                        fields[i] = new IntFieldPutter();
                        continue block11;
                    }
                    case LONG: {
                        fields[i] = new LongFieldPutter();
                        continue block11;
                    }
                    case OBJECT: {
                        fields[i] = new ObjectFieldPutter(field.isUnshared());
                        continue block11;
                    }
                    case SHORT: {
                        fields[i] = new ShortFieldPutter();
                    }
                }
            }
            this.putField = new RiverPutField(fields, names);
        }
        return this.putField;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SerializableClass swapClass(SerializableClass newSerializableClass) {
        try {
            SerializableClass serializableClass = this.serializableClass;
            return serializableClass;
        }
        finally {
            this.serializableClass = newSerializableClass;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object swapCurrent(Object current) {
        try {
            Object object = this.current;
            return object;
        }
        finally {
            this.current = current;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void defaultWriteObject() throws IOException {
        if (!this.state.compareAndSet(State.UNWRITTEN_FIELDS, State.ON)) {
            throw new NotActiveException("writeFields() may only be called when the fields have not yet been written");
        }
        try {
            this.marshaller.doWriteFields(this.serializableClass, this.current);
        }
        finally {
            this.putField = null;
            this.serializableClass = null;
            this.current = null;
        }
    }

    protected State start() throws IOException {
        return this.state.getAndSet(State.UNWRITTEN_FIELDS);
    }

    protected void finish(State restoreState) throws IOException {
        switch (this.state.getAndSet(restoreState)) {
            case OFF: {
                break;
            }
            case ON: {
                break;
            }
            case UNWRITTEN_FIELDS: {
                throw new NotActiveException("Fields were never written");
            }
        }
    }

    protected void fullReset() {
        this.state.set(State.OFF);
        this.putField = null;
        this.serializableClass = null;
        this.current = null;
    }

    private void checkState() throws NotActiveException {
        switch (this.state.get()) {
            case OFF: {
                throw new NotActiveException("Object stream not active");
            }
            case ON: {
                return;
            }
            case UNWRITTEN_FIELDS: {
                throw new NotActiveException("Fields not yet written");
            }
        }
        throw new IllegalStateException("Unknown state");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum State {
        OFF,
        UNWRITTEN_FIELDS,
        ON;

    }
}

