/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.river;

import java.io.IOException;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.util.Arrays;
import org.jboss.marshalling.Marshaller;
import org.jboss.river.BooleanFieldPutter;
import org.jboss.river.ByteFieldPutter;
import org.jboss.river.CharFieldPutter;
import org.jboss.river.DoubleFieldPutter;
import org.jboss.river.FieldPutter;
import org.jboss.river.FloatFieldPutter;
import org.jboss.river.IntFieldPutter;
import org.jboss.river.LongFieldPutter;
import org.jboss.river.ObjectFieldPutter;
import org.jboss.river.ShortFieldPutter;

public class RiverPutField
extends ObjectOutputStream.PutField {
    private final FieldPutter[] fields;
    private final String[] names;

    public RiverPutField(FieldPutter[] fields, String[] names) {
        this.fields = fields;
        this.names = names;
    }

    private FieldPutter find(String name) {
        int pos = Arrays.binarySearch(this.names, name);
        if (pos < 0) {
            throw new IllegalArgumentException("No field named '" + name + "' could be found");
        }
        return this.fields[pos];
    }

    public void put(String name, boolean val) {
        try {
            ((BooleanFieldPutter)this.find(name)).set(val);
        }
        catch (ClassCastException ex) {
            throw new IllegalArgumentException("Field named '" + name + "' is not a boolean field");
        }
    }

    public void put(String name, byte val) {
        try {
            ((ByteFieldPutter)this.find(name)).set(val);
        }
        catch (ClassCastException ex) {
            throw new IllegalArgumentException("Field named '" + name + "' is not a byte field");
        }
    }

    public void put(String name, char val) {
        try {
            ((CharFieldPutter)this.find(name)).set(val);
        }
        catch (ClassCastException ex) {
            throw new IllegalArgumentException("Field named '" + name + "' is not a char field");
        }
    }

    public void put(String name, short val) {
        try {
            ((ShortFieldPutter)this.find(name)).set(val);
        }
        catch (ClassCastException ex) {
            throw new IllegalArgumentException("Field named '" + name + "' is not a short field");
        }
    }

    public void put(String name, int val) {
        try {
            ((IntFieldPutter)this.find(name)).set(val);
        }
        catch (ClassCastException ex) {
            throw new IllegalArgumentException("Field named '" + name + "' is not an int field");
        }
    }

    public void put(String name, long val) {
        try {
            ((LongFieldPutter)this.find(name)).set(val);
        }
        catch (ClassCastException ex) {
            throw new IllegalArgumentException("Field named '" + name + "' is not a long field");
        }
    }

    public void put(String name, float val) {
        try {
            ((FloatFieldPutter)this.find(name)).set(val);
        }
        catch (ClassCastException ex) {
            throw new IllegalArgumentException("Field named '" + name + "' is not a float field");
        }
    }

    public void put(String name, double val) {
        try {
            ((DoubleFieldPutter)this.find(name)).set(val);
        }
        catch (ClassCastException ex) {
            throw new IllegalArgumentException("Field named '" + name + "' is not a double field");
        }
    }

    public void put(String name, Object val) {
        try {
            ((ObjectFieldPutter)this.find(name)).set(val);
        }
        catch (ClassCastException ex) {
            throw new IllegalArgumentException("Field named '" + name + "' is not an object field");
        }
    }

    @Deprecated
    public final void write(ObjectOutput out) throws IOException {
        throw new UnsupportedOperationException("write(ObjectOutput)");
    }

    protected final void write(Marshaller marshaller) throws IOException {
        for (FieldPutter putter : this.fields) {
            putter.write(marshaller);
        }
    }
}

