/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.marshalling.river;

import java.io.Externalizable;
import java.io.IOException;
import java.io.InvalidClassException;
import java.io.InvalidObjectException;
import java.io.NotSerializableException;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Proxy;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.IdentityHashMap;
import org.jboss.marshalling.AbstractMarshaller;
import org.jboss.marshalling.AbstractMarshallerFactory;
import org.jboss.marshalling.ByteOutput;
import org.jboss.marshalling.ClassExternalizerFactory;
import org.jboss.marshalling.ClassTable;
import org.jboss.marshalling.Externalizer;
import org.jboss.marshalling.ExternalizerFactory;
import org.jboss.marshalling.Marshaller;
import org.jboss.marshalling.MarshallerObjectOutput;
import org.jboss.marshalling.MarshallingConfiguration;
import org.jboss.marshalling.ObjectResolver;
import org.jboss.marshalling.ObjectTable;
import org.jboss.marshalling.UTFUtils;
import org.jboss.marshalling.reflect.SerializableClass;
import org.jboss.marshalling.reflect.SerializableClassRegistry;
import org.jboss.marshalling.reflect.SerializableField;
import org.jboss.marshalling.river.BlockMarshaller;
import org.jboss.marshalling.river.RiverMarshallerFactory;
import org.jboss.marshalling.river.RiverObjectOutputStream;
import org.jboss.marshalling.util.IdentityIntMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RiverMarshaller
extends AbstractMarshaller {
    private final IdentityIntMap<Object> instanceCache;
    private final IdentityIntMap<Class<?>> classCache;
    private final IdentityHashMap<Class<?>, Externalizer> externalizers;
    private final IdentityHashMap<Object, Object> replacementCache;
    private int instanceSeq;
    private int classSeq;
    private final SerializableClassRegistry registry;
    private RiverObjectOutputStream objectOutputStream;
    private ObjectOutput objectOutput;
    private BlockMarshaller blockMarshaller;
    private final PrivilegedExceptionAction<RiverObjectOutputStream> createObjectOutputStreamAction = new PrivilegedExceptionAction<RiverObjectOutputStream>(){

        @Override
        public RiverObjectOutputStream run() throws IOException {
            return new RiverObjectOutputStream((Marshaller)(RiverMarshaller.this.configuredVersion == 0 ? RiverMarshaller.this : RiverMarshaller.this.getBlockMarshaller()), RiverMarshaller.this);
        }
    };
    private static final IdentityIntMap<Class<?>> BASIC_CLASSES;

    protected RiverMarshaller(RiverMarshallerFactory marshallerFactory, SerializableClassRegistry registry, MarshallingConfiguration configuration) throws IOException {
        super((AbstractMarshallerFactory)marshallerFactory, configuration);
        if (this.configuredVersion > 1) {
            throw new IOException("Protocol version not supported");
        }
        this.registry = registry;
        float loadFactor = 0.3125f;
        this.instanceCache = new IdentityIntMap((int)((double)configuration.getInstanceCount() / 0.3125), 0.3125f);
        this.classCache = new IdentityIntMap((int)((double)configuration.getClassCount() / 0.3125), 0.3125f);
        this.externalizers = new IdentityHashMap(configuration.getClassCount());
        this.replacementCache = new IdentityHashMap(configuration.getInstanceCount());
    }

    protected void doWriteObject(Object original, boolean unshared) throws IOException {
        Externalizer externalizer;
        SerializableClass info;
        boolean isArray;
        boolean isEnum;
        int id;
        Class<?> objClass;
        ClassExternalizerFactory classExternalizerFactory = this.classExternalizerFactory;
        ExternalizerFactory externalizerFactory = this.externalizerFactory;
        ObjectResolver objectResolver = this.objectResolver;
        boolean replacing = true;
        Object obj = original;
        int ttl = 100;
        while (true) {
            ObjectTable.Writer objectTableWriter;
            int rid;
            if (--ttl == 0) {
                throw new InvalidObjectException("Replacement looped too many times");
            }
            if (obj == null) {
                this.write(1);
                return;
            }
            if (this.replacementCache.containsKey(obj)) {
                obj = this.replacementCache.get(obj);
                continue;
            }
            if (!unshared && (rid = this.instanceCache.get(obj, -1)) != -1) {
                this.write(2);
                this.writeInt(rid);
                return;
            }
            if (!unshared && (objectTableWriter = this.objectTable.getObjectWriter(obj)) != null) {
                this.write(3);
                if (this.configuredVersion > 0) {
                    objectTableWriter.writeObject((Marshaller)this.getBlockMarshaller(), obj);
                    this.writeEndBlock();
                } else {
                    objectTableWriter.writeObject((Marshaller)this, obj);
                }
                return;
            }
            objClass = obj.getClass();
            id = BASIC_CLASSES.get(objClass, -1);
            if (id == 21) {
                Class classObj = (Class)obj;
                this.write(4);
                this.write(21);
                this.writeClassClass(classObj);
                this.instanceCache.put((Object)classObj, this.instanceSeq++);
                return;
            }
            isEnum = obj instanceof Enum;
            isArray = objClass.isArray();
            SerializableClass serializableClass = info = isArray || isEnum ? null : this.registry.lookup(objClass);
            if (!replacing) break;
            if (info != null && info.hasWriteReplace()) {
                obj = info.callWriteReplace(obj);
            }
            obj = objectResolver.writeReplace(obj);
            replacing = false;
        }
        if (obj != original) {
            this.replacementCache.put(original, obj);
        }
        if (isEnum) {
            Enum theEnum = (Enum)obj;
            this.write(4);
            this.writeEnumClass(theEnum.getDeclaringClass());
            this.writeString(theEnum.name());
            this.instanceCache.put(obj, this.instanceSeq++);
            return;
        }
        switch (id) {
            case 42: {
                this.write(unshared ? 5 : 4);
                this.write(42);
                this.writeByte(((Byte)original).byteValue());
                return;
            }
            case 41: {
                this.write(unshared ? 5 : 4);
                this.write(41);
                this.writeBoolean((Boolean)original);
                return;
            }
            case 46: {
                this.write(unshared ? 5 : 4);
                this.write(46);
                this.writeChar(((Character)original).charValue());
                return;
            }
            case 48: {
                this.write(unshared ? 5 : 4);
                this.write(48);
                this.writeDouble((Double)original);
                return;
            }
            case 47: {
                this.write(unshared ? 5 : 4);
                this.write(47);
                this.writeFloat(((Float)original).floatValue());
                return;
            }
            case 44: {
                this.write(unshared ? 5 : 4);
                this.write(44);
                this.writeInt((Integer)original);
                return;
            }
            case 45: {
                this.write(unshared ? 5 : 4);
                this.write(45);
                this.writeLong((Long)original);
                return;
            }
            case 43: {
                this.write(unshared ? 5 : 4);
                this.write(43);
                this.writeShort(((Short)original).shortValue());
                return;
            }
            case 20: {
                String string = (String)obj;
                this.write(unshared ? 5 : 4);
                this.write(20);
                this.writeString(string);
                if (unshared) {
                    this.instanceCache.put(obj, -1);
                    ++this.instanceSeq;
                } else {
                    this.instanceCache.put(obj, this.instanceSeq++);
                }
                return;
            }
            case 25: {
                if (!unshared) {
                    this.instanceCache.put(obj, this.instanceSeq++);
                }
                this.write(unshared ? 5 : 4);
                this.write(25);
                byte[] bytes = (byte[])obj;
                int len = bytes.length;
                this.writeInt(len);
                this.write(bytes, 0, len);
                if (unshared) {
                    this.instanceCache.put(obj, -1);
                }
                return;
            }
            case 24: {
                if (!unshared) {
                    this.instanceCache.put(obj, this.instanceSeq++);
                }
                this.write(unshared ? 5 : 4);
                this.write(24);
                boolean[] booleans = (boolean[])obj;
                int len = booleans.length;
                this.writeInt(len);
                int bc = len & 0xFFFFFFF8;
                int i = 0;
                while (i < bc) {
                    this.write((booleans[i++] ? 1 : 0) | (booleans[i++] ? 2 : 0) | (booleans[i++] ? 4 : 0) | (booleans[i++] ? 8 : 0) | (booleans[i++] ? 16 : 0) | (booleans[i++] ? 32 : 0) | (booleans[i++] ? 64 : 0) | (booleans[i++] ? 128 : 0));
                }
                if (bc < len) {
                    int out = 0;
                    int bit = 1;
                    for (int i2 = bc; i2 < len; ++i2) {
                        if (booleans[i2]) {
                            out |= bit;
                        }
                        bit <<= 1;
                    }
                    this.write(out);
                }
                if (unshared) {
                    this.instanceCache.put(obj, -1);
                }
                return;
            }
            case 29: {
                if (!unshared) {
                    this.instanceCache.put(obj, this.instanceSeq++);
                }
                this.write(unshared ? 5 : 4);
                this.write(29);
                char[] chars = (char[])obj;
                int len = chars.length;
                this.writeInt(len);
                for (int i = 0; i < len; ++i) {
                    this.writeChar(chars[i]);
                }
                if (unshared) {
                    this.instanceCache.put(obj, -1);
                }
                return;
            }
            case 26: {
                if (!unshared) {
                    this.instanceCache.put(obj, this.instanceSeq++);
                }
                this.write(unshared ? 5 : 4);
                this.write(26);
                short[] shorts = (short[])obj;
                int len = shorts.length;
                this.writeInt(len);
                for (int i = 0; i < len; ++i) {
                    this.writeShort(shorts[i]);
                }
                if (unshared) {
                    this.instanceCache.put(obj, -1);
                }
                return;
            }
            case 27: {
                if (!unshared) {
                    this.instanceCache.put(obj, this.instanceSeq++);
                }
                this.write(unshared ? 5 : 4);
                this.write(27);
                int[] ints = (int[])obj;
                int len = ints.length;
                this.writeInt(len);
                for (int i = 0; i < len; ++i) {
                    this.writeInt(ints[i]);
                }
                if (unshared) {
                    this.instanceCache.put(obj, -1);
                }
                return;
            }
            case 28: {
                if (!unshared) {
                    this.instanceCache.put(obj, this.instanceSeq++);
                }
                this.write(unshared ? 5 : 4);
                this.write(28);
                long[] longs = (long[])obj;
                int len = longs.length;
                this.writeInt(len);
                for (int i = 0; i < len; ++i) {
                    this.writeLong(longs[i]);
                }
                if (unshared) {
                    this.instanceCache.put(obj, -1);
                }
                return;
            }
            case 30: {
                if (!unshared) {
                    this.instanceCache.put(obj, this.instanceSeq++);
                }
                this.write(unshared ? 5 : 4);
                this.write(30);
                float[] floats = (float[])obj;
                int len = floats.length;
                this.writeInt(len);
                for (int i = 0; i < len; ++i) {
                    this.writeFloat(floats[i]);
                }
                if (unshared) {
                    this.instanceCache.put(obj, -1);
                }
                return;
            }
            case 31: {
                this.instanceCache.put(obj, this.instanceSeq++);
                this.write(unshared ? 5 : 4);
                this.write(31);
                double[] doubles = (double[])obj;
                int len = doubles.length;
                this.writeInt(len);
                for (int i = 0; i < len; ++i) {
                    this.writeDouble(doubles[i]);
                }
                if (unshared) {
                    this.instanceCache.put(obj, -1);
                }
                return;
            }
            case -1: {
                break;
            }
            default: {
                throw new NotSerializableException(objClass.getName());
            }
        }
        if (isArray) {
            this.write(unshared ? 5 : 4);
            this.writeObjectArrayClass(objClass);
            this.instanceCache.put(obj, this.instanceSeq++);
            Object[] objects = (Object[])obj;
            int len = objects.length;
            this.writeInt(len);
            for (int i = 0; i < len; ++i) {
                this.doWriteObject(objects[i], unshared);
            }
            if (unshared) {
                this.instanceCache.put(obj, -1);
            }
            return;
        }
        if (Proxy.isProxyClass(objClass)) {
            this.write(unshared ? 5 : 4);
            this.instanceCache.put(obj, this.instanceSeq++);
            this.writeProxyClass(objClass);
            this.doWriteObject(Proxy.getInvocationHandler(obj), false);
            if (unshared) {
                this.instanceCache.put(obj, -1);
            }
            return;
        }
        if (this.externalizers.containsKey(objClass)) {
            externalizer = this.externalizers.get(objClass);
        } else {
            externalizer = classExternalizerFactory.getExternalizer(objClass);
            if (externalizer == null) {
                externalizer = externalizerFactory.getExternalizer(obj);
            }
            this.externalizers.put(objClass, externalizer);
        }
        if (externalizer != null) {
            this.write(unshared ? 5 : 4);
            this.writeExternalizerClass(objClass, externalizer);
            this.instanceCache.put(obj, this.instanceSeq++);
            ObjectOutput objectOutput = this.getObjectOutput();
            externalizer.writeExternal(obj, objectOutput);
            this.writeEndBlock();
            if (unshared) {
                this.instanceCache.put(obj, -1);
            }
            return;
        }
        if (obj instanceof Externalizable) {
            this.write(unshared ? 5 : 4);
            this.instanceCache.put(obj, this.instanceSeq++);
            Externalizable ext = (Externalizable)obj;
            ObjectOutput objectOutput = this.getObjectOutput();
            this.writeExternalizableClass(objClass);
            ext.writeExternal(objectOutput);
            this.writeEndBlock();
            if (unshared) {
                this.instanceCache.put(obj, -1);
            }
            return;
        }
        if (obj instanceof Serializable) {
            this.write(unshared ? 5 : 4);
            this.writeSerializableClass(objClass);
            this.instanceCache.put(obj, this.instanceSeq++);
            this.doWriteSerializableObject(info, obj, objClass);
            if (unshared) {
                this.instanceCache.put(obj, -1);
            }
            return;
        }
        throw new NotSerializableException(objClass.getName());
    }

    private void writeEndBlock() throws IOException {
        BlockMarshaller blockMarshaller = this.blockMarshaller;
        if (blockMarshaller != null) {
            blockMarshaller.flush();
            this.writeByte(53);
        }
    }

    protected ObjectOutput getObjectOutput() {
        Object object;
        ObjectOutput output = this.objectOutput;
        if (output == null) {
            if (this.configuredVersion == 0) {
                this.objectOutput = new MarshallerObjectOutput((Marshaller)this);
                object = this.objectOutput;
            } else {
                object = this.objectOutput = this.getBlockMarshaller();
            }
        } else {
            object = output;
        }
        return object;
    }

    protected BlockMarshaller getBlockMarshaller() {
        BlockMarshaller blockMarshaller = this.blockMarshaller;
        return blockMarshaller == null ? (this.blockMarshaller = new BlockMarshaller(this, this.bufferSize)) : blockMarshaller;
    }

    private RiverObjectOutputStream getObjectOutputStream() throws IOException {
        RiverObjectOutputStream objectOutputStream = this.objectOutputStream;
        return objectOutputStream == null ? (this.objectOutputStream = this.createObjectOutputStream()) : objectOutputStream;
    }

    private RiverObjectOutputStream createObjectOutputStream() throws IOException {
        try {
            return AccessController.doPrivileged(this.createObjectOutputStreamAction);
        }
        catch (PrivilegedActionException e) {
            throw (IOException)e.getCause();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doWriteSerializableObject(SerializableClass info, Object obj, Class<?> objClass) throws IOException {
        Class<?> superclass = objClass.getSuperclass();
        if (Serializable.class.isAssignableFrom(superclass)) {
            this.doWriteSerializableObject(this.registry.lookup(superclass), obj, superclass);
        }
        if (info.hasWriteObject()) {
            RiverObjectOutputStream objectOutputStream = this.getObjectOutputStream();
            SerializableClass oldInfo = objectOutputStream.swapClass(info);
            Object oldObj = objectOutputStream.swapCurrent(obj);
            RiverObjectOutputStream.State restoreState = objectOutputStream.start();
            boolean ok = false;
            try {
                info.callWriteObject(obj, (ObjectOutputStream)((Object)objectOutputStream));
                this.writeEndBlock();
                objectOutputStream.finish(restoreState);
                objectOutputStream.swapCurrent(oldObj);
                objectOutputStream.swapClass(oldInfo);
                ok = true;
            }
            finally {
                if (!ok) {
                    objectOutputStream.fullReset();
                }
            }
        } else {
            this.doWriteFields(info, obj);
        }
    }

    protected void doWriteFields(SerializableClass info, Object obj) throws IOException {
        SerializableField[] serializableFields;
        for (SerializableField serializableField : serializableFields = info.getFields()) {
            try {
                Field field = serializableField.getField();
                switch (serializableField.getKind()) {
                    case BOOLEAN: {
                        this.writeBoolean(field.getBoolean(obj));
                        break;
                    }
                    case BYTE: {
                        this.writeByte(field.getByte(obj));
                        break;
                    }
                    case SHORT: {
                        this.writeShort(field.getShort(obj));
                        break;
                    }
                    case INT: {
                        this.writeInt(field.getInt(obj));
                        break;
                    }
                    case CHAR: {
                        this.writeChar(field.getChar(obj));
                        break;
                    }
                    case LONG: {
                        this.writeLong(field.getLong(obj));
                        break;
                    }
                    case DOUBLE: {
                        this.writeDouble(field.getDouble(obj));
                        break;
                    }
                    case FLOAT: {
                        this.writeFloat(field.getFloat(obj));
                        break;
                    }
                    case OBJECT: {
                        this.doWriteObject(field.get(obj), serializableField.isUnshared());
                    }
                }
            }
            catch (IllegalAccessException e) {
                InvalidObjectException ioe = new InvalidObjectException("Unexpected illegal access exception");
                ioe.initCause(e);
                throw ioe;
            }
        }
    }

    protected void writeProxyClass(Class<?> objClass) throws IOException {
        if (!this.writeKnownClass(objClass)) {
            this.writeNewProxyClass(objClass);
        }
    }

    protected void writeNewProxyClass(Class<?> objClass) throws IOException {
        ClassTable.Writer classTableWriter = this.classTable.getClassWriter(objClass);
        if (classTableWriter != null) {
            this.write(15);
            this.classCache.put(objClass, this.classSeq++);
            this.writeClassTableData(objClass, classTableWriter);
        } else {
            this.write(8);
            String[] names = this.classResolver.getProxyInterfaces(objClass);
            this.writeInt(names.length);
            for (String name : names) {
                this.writeString(name);
            }
            this.classCache.put(objClass, this.classSeq++);
            if (this.configuredVersion > 0) {
                BlockMarshaller blockMarshaller = this.getBlockMarshaller();
                this.classResolver.annotateProxyClass((Marshaller)blockMarshaller, objClass);
                this.writeEndBlock();
            } else {
                this.classResolver.annotateProxyClass((Marshaller)this, objClass);
            }
        }
    }

    protected void writeEnumClass(Class<? extends Enum> objClass) throws IOException {
        if (!this.writeKnownClass(objClass)) {
            this.writeNewEnumClass(objClass);
        }
    }

    protected void writeNewEnumClass(Class<? extends Enum> objClass) throws IOException {
        ClassTable.Writer classTableWriter = this.classTable.getClassWriter(objClass);
        if (classTableWriter != null) {
            this.write(19);
            this.classCache.put(objClass, this.classSeq++);
            this.writeClassTableData(objClass, classTableWriter);
        } else {
            this.write(12);
            this.writeString(this.classResolver.getClassName(objClass));
            this.classCache.put(objClass, this.classSeq++);
            this.doAnnotateClass(objClass);
        }
    }

    protected void writeClassClass(Class<?> classObj) throws IOException {
        this.write(21);
        this.writeClass(classObj);
    }

    protected void writeObjectArrayClass(Class<?> objClass) throws IOException {
        this.write(13);
        this.writeClass(objClass.getComponentType());
        this.classCache.put(objClass, this.classSeq++);
    }

    protected void writeClass(Class<?> objClass) throws IOException {
        if (!this.writeKnownClass(objClass)) {
            this.writeNewClass(objClass);
        }
    }

    protected void writeNewClass(Class<?> objClass) throws IOException {
        if (objClass.isEnum()) {
            this.writeNewEnumClass(objClass.asSubclass(Enum.class));
        } else if (Proxy.isProxyClass(objClass)) {
            this.writeNewProxyClass(objClass);
        } else if (objClass.isArray()) {
            this.writeObjectArrayClass(objClass);
        } else if (!objClass.isInterface() && Serializable.class.isAssignableFrom(objClass)) {
            if (Externalizable.class.isAssignableFrom(objClass)) {
                this.writeNewExternalizableClass(objClass);
            } else {
                this.writeNewSerializableClass(objClass);
            }
        } else {
            ClassTable.Writer classTableWriter = this.classTable.getClassWriter(objClass);
            if (classTableWriter != null) {
                this.write(14);
                this.classCache.put(objClass, this.classSeq++);
                this.writeClassTableData(objClass, classTableWriter);
            } else {
                this.write(7);
                this.writeString(this.classResolver.getClassName(objClass));
                this.doAnnotateClass(objClass);
                this.classCache.put(objClass, this.classSeq++);
            }
        }
    }

    private void writeClassTableData(Class<?> objClass, ClassTable.Writer classTableWriter) throws IOException {
        if (this.configuredVersion > 0) {
            classTableWriter.writeClass((Marshaller)this.getBlockMarshaller(), objClass);
            this.writeEndBlock();
        } else {
            classTableWriter.writeClass((Marshaller)this, objClass);
        }
    }

    protected boolean writeKnownClass(Class<?> objClass) throws IOException {
        int i = BASIC_CLASSES.get(objClass, -1);
        if (i != -1) {
            this.write(i);
            return true;
        }
        i = this.classCache.get(objClass, -1);
        if (i != -1) {
            this.write(6);
            this.writeInt(i);
            return true;
        }
        return false;
    }

    protected void writeSerializableClass(Class<?> objClass) throws IOException {
        if (!this.writeKnownClass(objClass)) {
            this.writeNewSerializableClass(objClass);
        }
    }

    protected void writeNewSerializableClass(Class<?> objClass) throws IOException {
        ClassTable.Writer classTableWriter = this.classTable.getClassWriter(objClass);
        if (classTableWriter != null) {
            this.write(16);
            this.classCache.put(objClass, this.classSeq++);
            this.writeClassTableData(objClass, classTableWriter);
        } else {
            SerializableClass info = this.registry.lookup(objClass);
            if (this.configuredVersion > 0 && info.hasWriteObject()) {
                this.write(56);
            } else {
                this.write(9);
            }
            this.writeString(this.classResolver.getClassName(objClass));
            this.writeLong(info.getEffectiveSerialVersionUID());
            this.classCache.put(objClass, this.classSeq++);
            this.doAnnotateClass(objClass);
            SerializableField[] fields = info.getFields();
            int cnt = fields.length;
            this.writeInt(cnt);
            for (int i = 0; i < cnt; ++i) {
                SerializableField field = fields[i];
                this.writeUTF(field.getName());
                try {
                    this.writeClass(field.getType());
                }
                catch (ClassNotFoundException e) {
                    throw new InvalidClassException("Class of field was unloaded");
                }
                this.writeBoolean(field.isUnshared());
            }
        }
        this.writeClass(objClass.getSuperclass());
    }

    protected void writeExternalizableClass(Class<?> objClass) throws IOException {
        if (!this.writeKnownClass(objClass)) {
            this.writeNewExternalizableClass(objClass);
        }
    }

    protected void writeNewExternalizableClass(Class<?> objClass) throws IOException {
        ClassTable.Writer classTableWriter = this.classTable.getClassWriter(objClass);
        if (classTableWriter != null) {
            this.write(17);
            this.classCache.put(objClass, this.classSeq++);
            this.writeClassTableData(objClass, classTableWriter);
        } else {
            this.write(10);
            this.writeString(this.classResolver.getClassName(objClass));
            this.writeLong(this.registry.lookup(objClass).getEffectiveSerialVersionUID());
            this.classCache.put(objClass, this.classSeq++);
            this.doAnnotateClass(objClass);
        }
    }

    protected void writeExternalizerClass(Class<?> objClass, Externalizer externalizer) throws IOException {
        if (!this.writeKnownClass(objClass)) {
            this.writeNewExternalizerClass(objClass, externalizer);
        }
    }

    protected void writeNewExternalizerClass(Class<?> objClass, Externalizer externalizer) throws IOException {
        ClassTable.Writer classTableWriter = this.classTable.getClassWriter(objClass);
        if (classTableWriter != null) {
            this.write(18);
            this.classCache.put(objClass, this.classSeq++);
            this.writeClassTableData(objClass, classTableWriter);
        } else {
            this.write(11);
            this.writeString(this.classResolver.getClassName(objClass));
            this.classCache.put(objClass, this.classSeq++);
            this.doAnnotateClass(objClass);
            this.writeObject(externalizer);
        }
    }

    protected void doAnnotateClass(Class<?> objClass) throws IOException {
        if (this.configuredVersion > 0) {
            this.classResolver.annotateClass((Marshaller)this.getBlockMarshaller(), objClass);
            this.writeEndBlock();
        } else {
            this.classResolver.annotateClass((Marshaller)this, objClass);
        }
    }

    public void clearInstanceCache() throws IOException {
        this.instanceCache.clear();
        this.replacementCache.clear();
        this.instanceSeq = 0;
        if (this.byteOutput != null) {
            this.write(55);
        }
    }

    public void clearClassCache() throws IOException {
        this.classCache.clear();
        this.externalizers.clear();
        this.classSeq = 0;
        this.instanceCache.clear();
        this.replacementCache.clear();
        this.instanceSeq = 0;
        if (this.byteOutput != null) {
            this.write(54);
        }
    }

    protected void doStart() throws IOException {
        super.doStart();
        int configuredVersion = this.configuredVersion;
        if (configuredVersion > 0) {
            this.writeByte(configuredVersion);
        }
    }

    private void writeString(String string) throws IOException {
        this.writeInt(string.length());
        this.flush();
        UTFUtils.writeUTFBytes((ByteOutput)this.byteOutput, (String)string);
    }

    public void writeUTF(String string) throws IOException {
        this.writeInt(string.length());
        this.flush();
        UTFUtils.writeUTFBytes((ByteOutput)this.byteOutput, (String)string);
    }

    static {
        IdentityIntMap map = new IdentityIntMap(0.375f);
        map.put(Byte.TYPE, 33);
        map.put(Boolean.TYPE, 32);
        map.put(Character.TYPE, 37);
        map.put(Double.TYPE, 39);
        map.put(Float.TYPE, 38);
        map.put(Integer.TYPE, 35);
        map.put(Long.TYPE, 36);
        map.put(Short.TYPE, 34);
        map.put(Void.TYPE, 40);
        map.put(Byte.class, 42);
        map.put(Boolean.class, 41);
        map.put(Character.class, 46);
        map.put(Double.class, 48);
        map.put(Float.class, 47);
        map.put(Integer.class, 44);
        map.put(Long.class, 45);
        map.put(Short.class, 43);
        map.put(Void.class, 49);
        map.put(Object.class, 22);
        map.put(Class.class, 21);
        map.put(String.class, 20);
        map.put(Enum.class, 23);
        map.put(byte[].class, 25);
        map.put(boolean[].class, 24);
        map.put(char[].class, 29);
        map.put(double[].class, 31);
        map.put(float[].class, 30);
        map.put(int[].class, 27);
        map.put(long[].class, 28);
        map.put(short[].class, 26);
        BASIC_CLASSES = map;
    }
}

