/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.marshalling.river;

import java.io.Externalizable;
import java.io.IOException;
import java.io.InvalidClassException;
import java.io.InvalidObjectException;
import java.io.NotSerializableException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectInputValidation;
import java.io.Serializable;
import java.io.StreamCorruptedException;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import org.jboss.marshalling.AbstractMarshallerFactory;
import org.jboss.marshalling.AbstractUnmarshaller;
import org.jboss.marshalling.ByteInput;
import org.jboss.marshalling.Creator;
import org.jboss.marshalling.Externalizer;
import org.jboss.marshalling.MarshallerObjectInput;
import org.jboss.marshalling.MarshallingConfiguration;
import org.jboss.marshalling.UTFUtils;
import org.jboss.marshalling.Unmarshaller;
import org.jboss.marshalling.reflect.SerializableClass;
import org.jboss.marshalling.reflect.SerializableClassRegistry;
import org.jboss.marshalling.reflect.SerializableField;
import org.jboss.marshalling.river.BlockUnmarshaller;
import org.jboss.marshalling.river.ClassDescriptor;
import org.jboss.marshalling.river.ExternalizerClassDescriptor;
import org.jboss.marshalling.river.IncompleteClassDescriptor;
import org.jboss.marshalling.river.RiverMarshallerFactory;
import org.jboss.marshalling.river.RiverObjectInputStream;
import org.jboss.marshalling.river.SerializableClassDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RiverUnmarshaller
extends AbstractUnmarshaller {
    private final ArrayList<Object> instanceCache;
    private final ArrayList<ClassDescriptor> classCache;
    private final SerializableClassRegistry registry;
    private ObjectInput objectInput;
    private int version;
    private int depth;
    private BlockUnmarshaller blockUnmarshaller;
    private RiverObjectInputStream objectInputStream;
    private final SortedMap<Integer, Set<ObjectInputValidation>> validationMap = new TreeMap(Collections.reverseOrder());
    private static final Field proxyInvocationHandler = AccessController.doPrivileged(new PrivilegedAction<Field>(){

        @Override
        public Field run() {
            try {
                Field field = Proxy.class.getDeclaredField("h");
                field.setAccessible(true);
                return field;
            }
            catch (NoSuchFieldException e) {
                throw new NoSuchFieldError(e.getMessage());
            }
        }
    });
    private final PrivilegedExceptionAction<RiverObjectInputStream> createObjectInputStreamAction = new PrivilegedExceptionAction<RiverObjectInputStream>(){

        @Override
        public RiverObjectInputStream run() throws IOException {
            return new RiverObjectInputStream(RiverUnmarshaller.this, (Unmarshaller)(RiverUnmarshaller.this.version > 0 ? RiverUnmarshaller.this.getBlockUnmarshaller() : RiverUnmarshaller.this));
        }
    };
    private static final InvocationHandler DUMMY_HANDLER = new DummyInvocationHandler();

    protected RiverUnmarshaller(RiverMarshallerFactory marshallerFactory, SerializableClassRegistry registry, MarshallingConfiguration configuration) {
        super((AbstractMarshallerFactory)marshallerFactory, configuration);
        this.registry = registry;
        this.instanceCache = new ArrayList(configuration.getInstanceCount());
        this.classCache = new ArrayList(configuration.getClassCount());
    }

    public void clearInstanceCache() throws IOException {
        this.instanceCache.clear();
    }

    public void clearClassCache() throws IOException {
        this.clearInstanceCache();
        this.classCache.clear();
    }

    public void close() throws IOException {
        this.finish();
    }

    public void finish() throws IOException {
        super.finish();
        this.blockUnmarshaller = null;
        this.objectInput = null;
        this.objectInputStream = null;
    }

    private ObjectInput getObjectInput() {
        ObjectInput objectInput = this.objectInput;
        return objectInput == null ? (this.objectInput = this.version > 0 ? this.getBlockUnmarshaller() : new MarshallerObjectInput((Unmarshaller)this)) : objectInput;
    }

    private BlockUnmarshaller getBlockUnmarshaller() {
        BlockUnmarshaller blockUnmarshaller = this.blockUnmarshaller;
        return blockUnmarshaller == null ? (this.blockUnmarshaller = new BlockUnmarshaller(this)) : blockUnmarshaller;
    }

    private RiverObjectInputStream getObjectInputStream() throws IOException {
        RiverObjectInputStream objectInputStream = this.objectInputStream;
        return objectInputStream == null ? (this.objectInputStream = this.createObjectInputStream()) : objectInputStream;
    }

    private RiverObjectInputStream createObjectInputStream() throws IOException {
        try {
            return AccessController.doPrivileged(this.createObjectInputStreamAction);
        }
        catch (PrivilegedActionException e) {
            throw (IOException)e.getCause();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object doReadObject(boolean unshared) throws ClassNotFoundException, IOException {
        Object obj = this.doReadObject(this.readUnsignedByte(), unshared);
        if (this.depth == 0) {
            try {
                for (Set<ObjectInputValidation> validations : this.validationMap.values()) {
                    for (ObjectInputValidation validation : validations) {
                        validation.validateObject();
                    }
                }
            }
            finally {
                this.validationMap.clear();
            }
        }
        return obj;
    }

    Object doReadObject(int leadByte, boolean unshared) throws IOException, ClassNotFoundException {
        ++this.depth;
        try {
            block18: while (true) {
                switch (leadByte) {
                    case 1: {
                        Object var3_3 = null;
                        return var3_3;
                    }
                    case 2: {
                        if (unshared) {
                            throw new InvalidObjectException("Attempt to read a backreference as unshared");
                        }
                        try {
                            Object obj = this.instanceCache.get(this.readInt());
                            if (obj != null) {
                                Object object = obj;
                                return object;
                            }
                        }
                        catch (IndexOutOfBoundsException e) {
                            // empty catch block
                        }
                        throw new InvalidObjectException("Attempt to read a backreference with an invalid ID");
                    }
                    case 4: 
                    case 5: {
                        if (unshared != (leadByte == 5)) {
                            throw new InvalidObjectException("Shared/unshared object mismatch");
                        }
                        Object e = this.doReadNewObject(this.readUnsignedByte(), unshared);
                        return e;
                    }
                    case 3: {
                        if (unshared) {
                            throw new InvalidObjectException("Attempt to read a predefined object as unshared");
                        }
                        if (this.version > 0) {
                            BlockUnmarshaller blockUnmarshaller = this.getBlockUnmarshaller();
                            Object obj = this.objectTable.readObject((Unmarshaller)blockUnmarshaller);
                            blockUnmarshaller.readToEndBlockData();
                            blockUnmarshaller.unblock();
                            Object object = obj;
                            return object;
                        }
                        Object object = this.objectTable.readObject((Unmarshaller)this);
                        return object;
                    }
                    case 54: {
                        if (this.depth > 1) {
                            throw new StreamCorruptedException("ID_CLEAR_CLASS_CACHE token in the middle of stream processing");
                        }
                        this.classCache.clear();
                        this.instanceCache.clear();
                        leadByte = this.readUnsignedByte();
                        continue block18;
                    }
                    case 55: {
                        if (this.depth > 1) {
                            throw new StreamCorruptedException("ID_CLEAR_INSTANCE_CACHE token in the middle of stream processing");
                        }
                        this.instanceCache.clear();
                        continue block18;
                    }
                }
                break;
            }
            throw new StreamCorruptedException("Unexpected byte found when reading an object: " + leadByte);
        }
        finally {
            --this.depth;
        }
    }

    ClassDescriptor doReadClassDescriptor(int classType) throws IOException, ClassNotFoundException {
        switch (classType) {
            case 6: {
                return this.classCache.get(this.readInt());
            }
            case 19: {
                int idx = this.classCache.size();
                this.classCache.add(null);
                Class<?> type = this.readClassTableClass();
                ClassDescriptor descriptor = new ClassDescriptor(type, 12);
                this.classCache.set(idx, descriptor);
                return descriptor;
            }
            case 17: {
                int idx = this.classCache.size();
                this.classCache.add(null);
                Class<?> type = this.readClassTableClass();
                ClassDescriptor descriptor = new ClassDescriptor(type, 10);
                this.classCache.set(idx, descriptor);
                return descriptor;
            }
            case 18: {
                int idx = this.classCache.size();
                this.classCache.add(null);
                Class<?> type = this.readClassTableClass();
                Externalizer externalizer = (Externalizer)this.readObject();
                ExternalizerClassDescriptor descriptor = new ExternalizerClassDescriptor(type, externalizer);
                this.classCache.set(idx, descriptor);
                return descriptor;
            }
            case 14: {
                int idx = this.classCache.size();
                this.classCache.add(null);
                Class<?> type = this.readClassTableClass();
                ClassDescriptor descriptor = new ClassDescriptor(type, 7);
                if (this.version > 0) {
                    this.blockUnmarshaller.readToEndBlockData();
                    this.blockUnmarshaller.unblock();
                }
                this.classCache.set(idx, descriptor);
                return descriptor;
            }
            case 15: {
                int idx = this.classCache.size();
                this.classCache.add(null);
                Class<?> type = this.readClassTableClass();
                ClassDescriptor descriptor = new ClassDescriptor(type, 8);
                this.classCache.set(idx, descriptor);
                return descriptor;
            }
            case 16: {
                int idx = this.classCache.size();
                this.classCache.add(null);
                Class<?> type = this.readClassTableClass();
                SerializableClass serializableClass = this.registry.lookup(type);
                int descType = this.version > 0 && serializableClass.hasWriteObject() ? 56 : 9;
                SerializableClassDescriptor descriptor = new SerializableClassDescriptor(serializableClass, this.doReadClassDescriptor(this.readUnsignedByte()), serializableClass.getFields(), descType);
                this.classCache.set(idx, descriptor);
                return descriptor;
            }
            case 7: {
                String className = this.readString();
                Class<?> clazz = this.doResolveClass(className, 0L);
                ClassDescriptor descriptor = new ClassDescriptor(clazz, 7);
                this.classCache.add(descriptor);
                return descriptor;
            }
            case 8: {
                ClassDescriptor descriptor;
                String[] interfaces = new String[this.readInt()];
                for (int i = 0; i < interfaces.length; ++i) {
                    interfaces[i] = this.readString();
                }
                if (this.version > 0) {
                    BlockUnmarshaller blockUnmarshaller = this.getBlockUnmarshaller();
                    descriptor = new ClassDescriptor(this.classResolver.resolveProxyClass((Unmarshaller)blockUnmarshaller, interfaces), 8);
                    blockUnmarshaller.readToEndBlockData();
                    blockUnmarshaller.unblock();
                } else {
                    descriptor = new ClassDescriptor(this.classResolver.resolveProxyClass((Unmarshaller)this, interfaces), 8);
                }
                this.classCache.add(descriptor);
                return descriptor;
            }
            case 9: 
            case 56: {
                int idx = this.classCache.size();
                this.classCache.add(null);
                String className = this.readString();
                long uid = this.readLong();
                Class<?> clazz = this.doResolveClass(className, uid);
                Class<?> superClazz = clazz.getSuperclass();
                this.classCache.set(idx, new IncompleteClassDescriptor(clazz, classType));
                int cnt = this.readInt();
                String[] names = new String[cnt];
                ClassDescriptor[] descriptors = new ClassDescriptor[cnt];
                boolean[] unshareds = new boolean[cnt];
                for (int i = 0; i < cnt; ++i) {
                    names[i] = this.readUTF();
                    descriptors[i] = this.doReadClassDescriptor(this.readUnsignedByte());
                    unshareds[i] = this.readBoolean();
                }
                ClassDescriptor superDescriptor = this.doReadClassDescriptor(this.readUnsignedByte());
                if (superDescriptor != null) {
                    Class<?> superType = superDescriptor.getType();
                    if (!superType.isAssignableFrom(clazz)) {
                        throw new InvalidClassException(clazz.getName(), "Class does not extend stream superclass");
                    }
                    for (Class<?> cl = superClazz; cl != superType; cl = cl.getSuperclass()) {
                        superDescriptor = new SerializableClassDescriptor(this.registry.lookup(cl), superDescriptor);
                    }
                } else if (superClazz != null) {
                    Class<?> cl = superClazz;
                    while (Serializable.class.isAssignableFrom(cl)) {
                        superDescriptor = new SerializableClassDescriptor(this.registry.lookup(cl), superDescriptor);
                        cl = cl.getSuperclass();
                    }
                }
                SerializableClass serializableClass = this.registry.lookup(clazz);
                SerializableField[] fields = new SerializableField[cnt];
                for (int i = 0; i < cnt; ++i) {
                    fields[i] = serializableClass.getSerializableField(names[i], descriptors[i].getType(), unshareds[i]);
                }
                SerializableClassDescriptor descriptor = new SerializableClassDescriptor(serializableClass, superDescriptor, fields, classType);
                this.classCache.set(idx, descriptor);
                return descriptor;
            }
            case 10: {
                String className = this.readString();
                long uid = this.readLong();
                Class<?> clazz = this.doResolveClass(className, uid);
                ClassDescriptor descriptor = new ClassDescriptor(clazz, 10);
                this.classCache.add(descriptor);
                return descriptor;
            }
            case 11: {
                String className = this.readString();
                int idx = this.classCache.size();
                this.classCache.add(null);
                Class<?> clazz = this.doResolveClass(className, 0L);
                Externalizer externalizer = (Externalizer)this.readObject();
                ExternalizerClassDescriptor descriptor = new ExternalizerClassDescriptor(clazz, externalizer);
                this.classCache.set(idx, descriptor);
                return descriptor;
            }
            case 12: {
                ClassDescriptor descriptor = new ClassDescriptor(this.doResolveClass(this.readString(), 0L), 12);
                this.classCache.add(descriptor);
                return descriptor;
            }
            case 13: {
                ClassDescriptor elementType = this.doReadClassDescriptor(this.readUnsignedByte());
                ClassDescriptor arrayDescriptor = new ClassDescriptor(Array.newInstance(elementType.getType(), 0).getClass(), 13);
                this.classCache.add(arrayDescriptor);
                return arrayDescriptor;
            }
            case 20: {
                return ClassDescriptor.STRING_DESCRIPTOR;
            }
            case 22: {
                return ClassDescriptor.OBJECT_DESCRIPTOR;
            }
            case 21: {
                return ClassDescriptor.CLASS_DESCRIPTOR;
            }
            case 23: {
                return ClassDescriptor.ENUM_DESCRIPTOR;
            }
            case 24: {
                return ClassDescriptor.BOOLEAN_ARRAY;
            }
            case 25: {
                return ClassDescriptor.BYTE_ARRAY;
            }
            case 26: {
                return ClassDescriptor.SHORT_ARRAY;
            }
            case 27: {
                return ClassDescriptor.INT_ARRAY;
            }
            case 28: {
                return ClassDescriptor.LONG_ARRAY;
            }
            case 29: {
                return ClassDescriptor.CHAR_ARRAY;
            }
            case 30: {
                return ClassDescriptor.FLOAT_ARRAY;
            }
            case 31: {
                return ClassDescriptor.DOUBLE_ARRAY;
            }
            case 32: {
                return ClassDescriptor.BOOLEAN;
            }
            case 33: {
                return ClassDescriptor.BYTE;
            }
            case 37: {
                return ClassDescriptor.CHAR;
            }
            case 39: {
                return ClassDescriptor.DOUBLE;
            }
            case 38: {
                return ClassDescriptor.FLOAT;
            }
            case 35: {
                return ClassDescriptor.INT;
            }
            case 36: {
                return ClassDescriptor.LONG;
            }
            case 34: {
                return ClassDescriptor.SHORT;
            }
            case 40: {
                return ClassDescriptor.VOID;
            }
            case 41: {
                return ClassDescriptor.BOOLEAN_OBJ;
            }
            case 42: {
                return ClassDescriptor.BYTE_OBJ;
            }
            case 43: {
                return ClassDescriptor.SHORT_OBJ;
            }
            case 44: {
                return ClassDescriptor.INTEGER_OBJ;
            }
            case 45: {
                return ClassDescriptor.LONG_OBJ;
            }
            case 46: {
                return ClassDescriptor.CHARACTER_OBJ;
            }
            case 47: {
                return ClassDescriptor.FLOAT_OBJ;
            }
            case 48: {
                return ClassDescriptor.DOUBLE_OBJ;
            }
            case 49: {
                return ClassDescriptor.VOID_OBJ;
            }
        }
        throw new InvalidClassException("Unexpected class ID " + classType);
    }

    private Class<?> readClassTableClass() throws IOException, ClassNotFoundException {
        if (this.version > 0) {
            BlockUnmarshaller blockUnmarshaller = this.getBlockUnmarshaller();
            Class type = this.classTable.readClass((Unmarshaller)blockUnmarshaller);
            blockUnmarshaller.readToEndBlockData();
            blockUnmarshaller.unblock();
            return type;
        }
        return this.classTable.readClass((Unmarshaller)this);
    }

    private Class<?> doResolveClass(String className, long uid) throws IOException, ClassNotFoundException {
        if (this.version > 0) {
            BlockUnmarshaller blockUnmarshaller = this.getBlockUnmarshaller();
            Class resolvedClass = this.classResolver.resolveClass((Unmarshaller)blockUnmarshaller, className, uid);
            blockUnmarshaller.readToEndBlockData();
            blockUnmarshaller.unblock();
            return resolvedClass;
        }
        return this.classResolver.resolveClass((Unmarshaller)this, className, uid);
    }

    protected String readString() throws IOException {
        int length = this.readInt();
        return UTFUtils.readUTFBytes((ByteInput)this, (int)length);
    }

    protected void doStart() throws IOException {
        super.doStart();
        if (this.configuredVersion > 0) {
            int version = this.readUnsignedByte();
            if (version > 1) {
                throw new IOException("Unsupported protocol version " + version);
            }
            this.version = version;
        } else {
            this.version = 0;
        }
    }

    private static Object createProxyInstance(Creator creator, Class<?> type) throws IOException {
        try {
            return creator.create(type);
        }
        catch (Exception e) {
            return Proxy.newProxyInstance(type.getClassLoader(), type.getInterfaces(), DUMMY_HANDLER);
        }
    }

    protected Object doReadNewObject(int streamClassType, boolean unshared) throws ClassNotFoundException, IOException {
        ClassDescriptor descriptor = this.doReadClassDescriptor(streamClassType);
        int classType = descriptor.getTypeID();
        switch (classType) {
            case 8: {
                Class<?> type = descriptor.getType();
                Object obj = RiverUnmarshaller.createProxyInstance(this.creator, type);
                int idx = this.instanceCache.size();
                this.instanceCache.add(obj);
                try {
                    proxyInvocationHandler.set(obj, this.doReadObject(unshared));
                }
                catch (IllegalAccessException e) {
                    throw new InvalidClassException(type.getName(), "Unable to set proxy invocation handler");
                }
                Object resolvedObject = this.objectResolver.readResolve(obj);
                if (unshared) {
                    this.instanceCache.set(idx, null);
                } else if (obj != resolvedObject) {
                    this.instanceCache.set(idx, resolvedObject);
                }
                return resolvedObject;
            }
            case 9: 
            case 56: {
                SerializableClassDescriptor serializableClassDescriptor = (SerializableClassDescriptor)descriptor;
                Class<?> type = descriptor.getType();
                SerializableClass serializableClass = serializableClassDescriptor.getSerializableClass();
                Object obj = this.creator.create(type);
                int idx = this.instanceCache.size();
                this.instanceCache.add(obj);
                this.doInitSerializable(obj, serializableClassDescriptor);
                Object resolvedObject = this.objectResolver.readResolve(serializableClass.hasReadResolve() ? serializableClass.callReadResolve(obj) : obj);
                if (unshared) {
                    this.instanceCache.set(idx, null);
                } else if (obj != resolvedObject) {
                    this.instanceCache.set(idx, resolvedObject);
                }
                return resolvedObject;
            }
            case 10: {
                Class<?> type = descriptor.getType();
                SerializableClass serializableClass = this.registry.lookup(type);
                Externalizable obj = (Externalizable)this.creator.create(type);
                int idx = this.instanceCache.size();
                this.instanceCache.add(obj);
                obj.readExternal(this.getObjectInput());
                if (this.version > 0) {
                    this.blockUnmarshaller.readToEndBlockData();
                }
                Object resolvedObject = this.objectResolver.readResolve(serializableClass.hasReadResolve() ? serializableClass.callReadResolve((Object)obj) : obj);
                if (unshared) {
                    this.instanceCache.set(idx, null);
                } else if (obj != resolvedObject) {
                    this.instanceCache.set(idx, resolvedObject);
                }
                return resolvedObject;
            }
            case 11: {
                Object obj;
                int idx = this.instanceCache.size();
                this.instanceCache.add(null);
                Externalizer externalizer = ((ExternalizerClassDescriptor)descriptor).getExternalizer();
                Class<?> type = descriptor.getType();
                SerializableClass serializableClass = this.registry.lookup(type);
                if (this.version > 0) {
                    BlockUnmarshaller blockUnmarshaller = this.getBlockUnmarshaller();
                    obj = externalizer.createExternal(type, (ObjectInput)((Object)blockUnmarshaller), this.creator);
                    this.instanceCache.set(idx, obj);
                    externalizer.readExternal(obj, (ObjectInput)((Object)blockUnmarshaller));
                    blockUnmarshaller.readToEndBlockData();
                    blockUnmarshaller.unblock();
                } else {
                    obj = externalizer.createExternal(type, (ObjectInput)((Object)this), this.creator);
                    this.instanceCache.set(idx, obj);
                    externalizer.readExternal(obj, this.getObjectInput());
                }
                Object resolvedObject = this.objectResolver.readResolve(serializableClass.hasReadResolve() ? serializableClass.callReadResolve(obj) : obj);
                if (unshared) {
                    this.instanceCache.set(idx, null);
                } else if (obj != resolvedObject) {
                    this.instanceCache.set(idx, resolvedObject);
                }
                return resolvedObject;
            }
            case 12: {
                String name = this.readString();
                Enum obj = RiverUnmarshaller.resolveEnumConstant(descriptor, name);
                int idx = this.instanceCache.size();
                this.instanceCache.add(obj);
                Object resolvedObject = this.objectResolver.readResolve((Object)obj);
                if (unshared) {
                    this.instanceCache.set(idx, null);
                } else if (obj != resolvedObject) {
                    this.instanceCache.set(idx, resolvedObject);
                }
                return resolvedObject;
            }
            case 13: {
                int cnt = this.readInt();
                Object[] array = (Object[])Array.newInstance(descriptor.getType().getComponentType(), cnt);
                int idx = this.instanceCache.size();
                this.instanceCache.add(array);
                for (int i = 0; i < cnt; ++i) {
                    array[i] = this.doReadObject(unshared);
                }
                Object resolvedObject = this.objectResolver.readResolve((Object)array);
                if (unshared) {
                    this.instanceCache.set(idx, null);
                } else if (array != resolvedObject) {
                    this.instanceCache.set(idx, resolvedObject);
                }
                return resolvedObject;
            }
            case 20: {
                String obj = this.readString();
                Object resolvedObject = this.objectResolver.readResolve((Object)obj);
                if (unshared) {
                    this.instanceCache.add(null);
                } else {
                    this.instanceCache.add(resolvedObject);
                }
                return resolvedObject;
            }
            case 21: {
                ClassDescriptor nestedDescriptor = this.doReadClassDescriptor(this.readUnsignedByte());
                Class<?> obj = nestedDescriptor.getType();
                return obj;
            }
            case 24: {
                int cnt = this.readInt();
                boolean[] array = new boolean[cnt];
                int v = 0;
                int bc = cnt & 0xFFFFFFF8;
                int i = 0;
                while (i < bc) {
                    v = this.readByte();
                    array[i++] = (v & 1) != 0;
                    array[i++] = (v & 2) != 0;
                    array[i++] = (v & 4) != 0;
                    array[i++] = (v & 8) != 0;
                    array[i++] = (v & 0x10) != 0;
                    array[i++] = (v & 0x20) != 0;
                    array[i++] = (v & 0x40) != 0;
                    array[i++] = (v & 0x80) != 0;
                }
                if (bc < cnt) {
                    v = this.readUnsignedByte();
                    int bit = 1;
                    for (int i2 = bc; i2 < cnt; ++i2) {
                        array[i2] = (v & bit) != 0;
                        bit <<= 1;
                    }
                }
                Object resolvedObject = this.objectResolver.readResolve((Object)array);
                this.instanceCache.add(unshared ? null : resolvedObject);
                return resolvedObject;
            }
            case 25: {
                int cnt = this.readInt();
                byte[] array = new byte[cnt];
                this.readFully(array, 0, array.length);
                Object resolvedObject = this.objectResolver.readResolve((Object)array);
                this.instanceCache.add(unshared ? null : resolvedObject);
                return resolvedObject;
            }
            case 26: {
                int cnt = this.readInt();
                short[] array = new short[cnt];
                for (int i = 0; i < cnt; ++i) {
                    array[i] = this.readShort();
                }
                Object resolvedObject = this.objectResolver.readResolve((Object)array);
                this.instanceCache.add(unshared ? null : resolvedObject);
                return resolvedObject;
            }
            case 27: {
                int cnt = this.readInt();
                int[] array = new int[cnt];
                for (int i = 0; i < cnt; ++i) {
                    array[i] = this.readInt();
                }
                Object resolvedObject = this.objectResolver.readResolve((Object)array);
                this.instanceCache.add(unshared ? null : resolvedObject);
                return resolvedObject;
            }
            case 28: {
                int cnt = this.readInt();
                long[] array = new long[cnt];
                for (int i = 0; i < cnt; ++i) {
                    array[i] = this.readLong();
                }
                Object resolvedObject = this.objectResolver.readResolve((Object)array);
                this.instanceCache.add(unshared ? null : resolvedObject);
                return resolvedObject;
            }
            case 29: {
                int cnt = this.readInt();
                char[] array = new char[cnt];
                for (int i = 0; i < cnt; ++i) {
                    array[i] = this.readChar();
                }
                Object resolvedObject = this.objectResolver.readResolve((Object)array);
                this.instanceCache.add(unshared ? null : resolvedObject);
                return resolvedObject;
            }
            case 30: {
                int cnt = this.readInt();
                float[] array = new float[cnt];
                for (int i = 0; i < cnt; ++i) {
                    array[i] = this.readFloat();
                }
                Object resolvedObject = this.objectResolver.readResolve((Object)array);
                this.instanceCache.add(unshared ? null : resolvedObject);
                return resolvedObject;
            }
            case 31: {
                int cnt = this.readInt();
                double[] array = new double[cnt];
                for (int i = 0; i < cnt; ++i) {
                    array[i] = this.readDouble();
                }
                Object resolvedObject = this.objectResolver.readResolve((Object)array);
                this.instanceCache.add(unshared ? null : resolvedObject);
                return resolvedObject;
            }
            case 41: {
                return this.readBoolean();
            }
            case 42: {
                return this.readByte();
            }
            case 43: {
                return this.readShort();
            }
            case 44: {
                return this.readInt();
            }
            case 45: {
                return this.readLong();
            }
            case 46: {
                return Character.valueOf(this.readChar());
            }
            case 47: {
                return Float.valueOf(this.readFloat());
            }
            case 48: {
                return this.readDouble();
            }
            case 7: 
            case 22: {
                throw new NotSerializableException("(remote)" + descriptor.getType().getName());
            }
        }
        throw new InvalidObjectException("Unexpected class type " + classType);
    }

    private static Enum resolveEnumConstant(ClassDescriptor descriptor, String name) {
        return Enum.valueOf(descriptor.getType(), name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doInitSerializable(Object obj, SerializableClassDescriptor descriptor) throws IOException, ClassNotFoundException {
        Class<?> type = descriptor.getType();
        SerializableClass info = this.registry.lookup(type);
        ClassDescriptor superDescriptor = descriptor.getSuperClassDescriptor();
        if (superDescriptor instanceof SerializableClassDescriptor) {
            SerializableClassDescriptor serializableSuperDescriptor = (SerializableClassDescriptor)superDescriptor;
            this.doInitSerializable(obj, serializableSuperDescriptor);
        }
        int typeId = descriptor.getTypeID();
        if (descriptor.isGap()) {
            if (info.hasReadObjectNoData()) {
                info.callReadObjectNoData(obj);
            }
        } else if (info.hasReadObject()) {
            RiverObjectInputStream objectInputStream = this.getObjectInputStream();
            SerializableClassDescriptor oldDescriptor = objectInputStream.swapClass(descriptor);
            Object oldObj = objectInputStream.swapCurrent(obj);
            RiverObjectInputStream.State restoreState = objectInputStream.start();
            boolean ok = false;
            try {
                if (typeId == 56) {
                    info.callReadObject(obj, (ObjectInputStream)((Object)objectInputStream));
                    this.blockUnmarshaller.readToEndBlockData();
                    this.blockUnmarshaller.unblock();
                } else if (this.version >= 1) {
                    this.blockUnmarshaller.endOfStream();
                    info.callReadObject(obj, (ObjectInputStream)((Object)objectInputStream));
                    this.blockUnmarshaller.readToEndBlockData();
                    this.blockUnmarshaller.unblock();
                } else {
                    info.callReadObject(obj, (ObjectInputStream)((Object)objectInputStream));
                }
                objectInputStream.finish(restoreState);
                objectInputStream.swapCurrent(oldObj);
                objectInputStream.swapClass(oldDescriptor);
                ok = true;
            }
            finally {
                if (!ok) {
                    objectInputStream.fullReset();
                }
            }
        } else {
            this.readFields(obj, descriptor);
            if (typeId == 56) {
                this.blockUnmarshaller.readToEndBlockData();
                this.blockUnmarshaller.unblock();
            }
        }
    }

    protected void readFields(Object obj, SerializableClassDescriptor descriptor) throws IOException, ClassNotFoundException {
        for (SerializableField serializableField : descriptor.getFields()) {
            Field field = serializableField.getField();
            if (field == null) {
                switch (serializableField.getKind()) {
                    case BOOLEAN: {
                        this.readBoolean();
                        break;
                    }
                    case BYTE: {
                        this.readByte();
                        break;
                    }
                    case CHAR: {
                        this.readChar();
                        break;
                    }
                    case DOUBLE: {
                        this.readDouble();
                        break;
                    }
                    case FLOAT: {
                        this.readFloat();
                        break;
                    }
                    case INT: {
                        this.readInt();
                        break;
                    }
                    case LONG: {
                        this.readLong();
                        break;
                    }
                    case OBJECT: {
                        if (serializableField.isUnshared()) {
                            this.readObjectUnshared();
                            break;
                        }
                        this.readObject();
                        break;
                    }
                    case SHORT: {
                        this.readShort();
                    }
                }
                continue;
            }
            try {
                switch (serializableField.getKind()) {
                    case BOOLEAN: {
                        field.setBoolean(obj, this.readBoolean());
                        break;
                    }
                    case BYTE: {
                        field.setByte(obj, this.readByte());
                        break;
                    }
                    case CHAR: {
                        field.setChar(obj, this.readChar());
                        break;
                    }
                    case DOUBLE: {
                        field.setDouble(obj, this.readDouble());
                        break;
                    }
                    case FLOAT: {
                        field.setFloat(obj, this.readFloat());
                        break;
                    }
                    case INT: {
                        field.setInt(obj, this.readInt());
                        break;
                    }
                    case LONG: {
                        field.setLong(obj, this.readLong());
                        break;
                    }
                    case OBJECT: {
                        Object robj = serializableField.isUnshared() ? this.readObjectUnshared() : this.readObject();
                        field.set(obj, robj);
                        break;
                    }
                    case SHORT: {
                        field.setShort(obj, this.readShort());
                    }
                }
            }
            catch (IllegalAccessException e) {
                InvalidObjectException ioe = new InvalidObjectException("Unable to set a field");
                ioe.initCause(e);
                throw ioe;
            }
        }
    }

    void addValidation(ObjectInputValidation validation, int prio) {
        Set<ObjectInputValidation> validations;
        Integer prioKey = prio;
        if (this.validationMap.containsKey(prioKey)) {
            validations = (Set)this.validationMap.get(prioKey);
        } else {
            validations = new HashSet();
            this.validationMap.put(prioKey, validations);
        }
        validations.add(validation);
    }

    public String readUTF() throws IOException {
        int len = this.readInt();
        return UTFUtils.readUTFBytes((ByteInput)this, (int)len);
    }

    private static final class DummyInvocationHandler
    implements InvocationHandler {
        private DummyInvocationHandler() {
        }

        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            throw new NoSuchMethodError("Invocation handler not yet loaded");
        }
    }
}

