/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.marshalling.river;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.NotActiveException;
import java.io.ObjectInputStream;
import java.io.ObjectInputValidation;
import java.io.ObjectStreamClass;
import java.util.concurrent.atomic.AtomicReference;
import org.jboss.marshalling.MarshallerObjectInputStream;
import org.jboss.marshalling.Unmarshaller;
import org.jboss.marshalling.reflect.SerializableField;
import org.jboss.marshalling.river.RiverUnmarshaller;
import org.jboss.marshalling.river.SerializableClassDescriptor;
import org.jboss.marshalling.util.BooleanReadField;
import org.jboss.marshalling.util.ByteReadField;
import org.jboss.marshalling.util.CharReadField;
import org.jboss.marshalling.util.DoubleReadField;
import org.jboss.marshalling.util.FloatReadField;
import org.jboss.marshalling.util.IntReadField;
import org.jboss.marshalling.util.LongReadField;
import org.jboss.marshalling.util.ObjectReadField;
import org.jboss.marshalling.util.ReadField;
import org.jboss.marshalling.util.ShortReadField;

public class RiverObjectInputStream
extends MarshallerObjectInputStream {
    private AtomicReference<State> state = new AtomicReference<State>(State.OFF);
    private final RiverUnmarshaller unmarshaller;
    private SerializableClassDescriptor serializableClassDescriptor;
    private Object current;

    protected RiverObjectInputStream(RiverUnmarshaller riverUnmarshaller, Unmarshaller delegateUnmarshaller) throws IOException, SecurityException {
        super(delegateUnmarshaller);
        this.unmarshaller = riverUnmarshaller;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void defaultReadObject() throws IOException, ClassNotFoundException {
        if (!this.state.compareAndSet(State.UNREAD_FIELDS, State.ON)) {
            throw new NotActiveException("defaultReadObject() may only be called when the fields have not yet been read");
        }
        try {
            this.unmarshaller.readFields(this.current, this.serializableClassDescriptor);
        }
        finally {
            this.serializableClassDescriptor = null;
            this.current = null;
        }
    }

    public ObjectInputStream.GetField readFields() throws IOException, ClassNotFoundException {
        if (!this.state.compareAndSet(State.UNREAD_FIELDS, State.ON)) {
            throw new NotActiveException("readFields() may only be called when the fields have not yet been read");
        }
        SerializableField[] streamFields = this.serializableClassDescriptor.getFields();
        int cnt = streamFields.length;
        final ReadField[] readFields = new ReadField[cnt];
        block11: for (int i = 0; i < cnt; ++i) {
            SerializableField field = streamFields[i];
            switch (field.getKind()) {
                case BOOLEAN: {
                    readFields[i] = new BooleanReadField(field, this.unmarshaller.readBoolean());
                    continue block11;
                }
                case BYTE: {
                    readFields[i] = new ByteReadField(field, this.unmarshaller.readByte());
                    continue block11;
                }
                case CHAR: {
                    readFields[i] = new CharReadField(field, this.unmarshaller.readChar());
                    continue block11;
                }
                case DOUBLE: {
                    readFields[i] = new DoubleReadField(field, this.unmarshaller.readDouble());
                    continue block11;
                }
                case FLOAT: {
                    readFields[i] = new FloatReadField(field, this.unmarshaller.readFloat());
                    continue block11;
                }
                case INT: {
                    readFields[i] = new IntReadField(field, this.unmarshaller.readInt());
                    continue block11;
                }
                case LONG: {
                    readFields[i] = new LongReadField(field, this.unmarshaller.readLong());
                    continue block11;
                }
                case OBJECT: {
                    readFields[i] = new ObjectReadField(field, this.unmarshaller.readObject());
                    continue block11;
                }
                case SHORT: {
                    readFields[i] = new ShortReadField(field, this.unmarshaller.readShort());
                    continue block11;
                }
                default: {
                    throw new IllegalStateException("Wrong field type");
                }
            }
        }
        return new ObjectInputStream.GetField(){

            public ObjectStreamClass getObjectStreamClass() {
                throw new UnsupportedOperationException("TODO...");
            }

            private ReadField find(String name) {
                if (name == null) {
                    throw new NullPointerException("name is null");
                }
                for (ReadField field : readFields) {
                    if (!name.equals(field.getName())) continue;
                    return field;
                }
                throw new IllegalArgumentException("No field named '" + name + "'");
            }

            public boolean defaulted(String name) throws IOException {
                return this.find(name).isDefaulted();
            }

            public boolean get(String name, boolean val) throws IOException {
                ReadField field = this.find(name);
                return field.isDefaulted() ? val : field.getBoolean();
            }

            public byte get(String name, byte val) throws IOException {
                ReadField field = this.find(name);
                return field.isDefaulted() ? val : field.getByte();
            }

            public char get(String name, char val) throws IOException {
                ReadField field = this.find(name);
                return field.isDefaulted() ? val : field.getChar();
            }

            public short get(String name, short val) throws IOException {
                ReadField field = this.find(name);
                return field.isDefaulted() ? val : field.getShort();
            }

            public int get(String name, int val) throws IOException {
                ReadField field = this.find(name);
                return field.isDefaulted() ? val : field.getInt();
            }

            public long get(String name, long val) throws IOException {
                ReadField field = this.find(name);
                return field.isDefaulted() ? val : field.getLong();
            }

            public float get(String name, float val) throws IOException {
                ReadField field = this.find(name);
                return field.isDefaulted() ? val : field.getFloat();
            }

            public double get(String name, double val) throws IOException {
                ReadField field = this.find(name);
                return field.isDefaulted() ? val : field.getDouble();
            }

            public Object get(String name, Object val) throws IOException {
                ReadField field = this.find(name);
                return field.isDefaulted() ? val : field.getObject();
            }
        };
    }

    public void registerValidation(ObjectInputValidation obj, int prio) throws NotActiveException, InvalidObjectException {
        this.unmarshaller.addValidation(obj, prio);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SerializableClassDescriptor swapClass(SerializableClassDescriptor descriptor) {
        try {
            SerializableClassDescriptor serializableClassDescriptor = this.serializableClassDescriptor;
            return serializableClassDescriptor;
        }
        finally {
            this.serializableClassDescriptor = descriptor;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object swapCurrent(Object obj) {
        try {
            Object object = this.current;
            return object;
        }
        finally {
            this.current = obj;
        }
    }

    protected State start() {
        return this.state.getAndSet(State.UNREAD_FIELDS);
    }

    protected void finish(State restoreState) throws IOException {
        switch (this.state.getAndSet(restoreState)) {
            case OFF: {
                break;
            }
            case ON: {
                break;
            }
            case UNREAD_FIELDS: {
                throw new NotActiveException("Fields were never read");
            }
        }
    }

    protected void fullReset() {
        this.state.set(State.OFF);
        this.serializableClassDescriptor = null;
        this.current = null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum State {
        OFF,
        UNREAD_FIELDS,
        ON;

    }
}

