/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.marshalling.river;

import java.io.IOException;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.util.Arrays;
import org.jboss.marshalling.Marshaller;
import org.jboss.marshalling.util.FieldPutter;

public class RiverPutField
extends ObjectOutputStream.PutField {
    private final FieldPutter[] fields;
    private final String[] names;

    public RiverPutField(FieldPutter[] fields, String[] names) {
        this.fields = fields;
        this.names = names;
    }

    private FieldPutter find(String name) {
        int pos = Arrays.binarySearch(this.names, name);
        if (pos < 0) {
            throw new IllegalArgumentException("No field named '" + name + "' could be found");
        }
        return this.fields[pos];
    }

    public void put(String name, boolean val) {
        this.find(name).setBoolean(val);
    }

    public void put(String name, byte val) {
        this.find(name).setByte(val);
    }

    public void put(String name, char val) {
        this.find(name).setChar(val);
    }

    public void put(String name, short val) {
        this.find(name).setShort(val);
    }

    public void put(String name, int val) {
        this.find(name).setInt(val);
    }

    public void put(String name, long val) {
        this.find(name).setLong(val);
    }

    public void put(String name, float val) {
        this.find(name).setFloat(val);
    }

    public void put(String name, double val) {
        this.find(name).setDouble(val);
    }

    public void put(String name, Object val) {
        this.find(name).setObject(val);
    }

    @Deprecated
    public final void write(ObjectOutput out) throws IOException {
        throw new UnsupportedOperationException("write(ObjectOutput)");
    }

    protected final void write(Marshaller marshaller) throws IOException {
        for (FieldPutter putter : this.fields) {
            putter.write(marshaller);
        }
    }
}

