/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.marshalling.river;

import java.io.Externalizable;
import java.io.IOException;
import java.io.InvalidClassException;
import java.io.InvalidObjectException;
import java.io.NotSerializableException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectInputValidation;
import java.io.Serializable;
import java.io.StreamCorruptedException;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import org.jboss.marshalling.AbstractMarshallerFactory;
import org.jboss.marshalling.AbstractUnmarshaller;
import org.jboss.marshalling.ByteInput;
import org.jboss.marshalling.Creator;
import org.jboss.marshalling.Externalizer;
import org.jboss.marshalling.MarshallerObjectInput;
import org.jboss.marshalling.MarshallingConfiguration;
import org.jboss.marshalling.UTFUtils;
import org.jboss.marshalling.Unmarshaller;
import org.jboss.marshalling.reflect.SerializableClass;
import org.jboss.marshalling.reflect.SerializableClassRegistry;
import org.jboss.marshalling.reflect.SerializableField;
import org.jboss.marshalling.river.BlockUnmarshaller;
import org.jboss.marshalling.river.ClassDescriptor;
import org.jboss.marshalling.river.ExternalizerClassDescriptor;
import org.jboss.marshalling.river.IncompleteClassDescriptor;
import org.jboss.marshalling.river.RiverMarshallerFactory;
import org.jboss.marshalling.river.RiverObjectInputStream;
import org.jboss.marshalling.river.SerializableClassDescriptor;
import org.jboss.marshalling.river.Validator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RiverUnmarshaller
extends AbstractUnmarshaller {
    private final ArrayList<Object> instanceCache;
    private final ArrayList<ClassDescriptor> classCache;
    private final SerializableClassRegistry registry;
    private ObjectInput objectInput;
    private int version;
    private int depth;
    private BlockUnmarshaller blockUnmarshaller;
    private RiverObjectInputStream objectInputStream;
    private SortedSet<Validator> validators;
    private int validatorSeq;
    private static final Field proxyInvocationHandler = AccessController.doPrivileged(new PrivilegedAction<Field>(){

        @Override
        public Field run() {
            try {
                Field field = Proxy.class.getDeclaredField("h");
                field.setAccessible(true);
                return field;
            }
            catch (NoSuchFieldException e) {
                throw new NoSuchFieldError(e.getMessage());
            }
        }
    });
    private final PrivilegedExceptionAction<RiverObjectInputStream> createObjectInputStreamAction = new PrivilegedExceptionAction<RiverObjectInputStream>(){

        @Override
        public RiverObjectInputStream run() throws IOException {
            return new RiverObjectInputStream(RiverUnmarshaller.this, (Unmarshaller)(RiverUnmarshaller.this.version > 0 ? RiverUnmarshaller.this.getBlockUnmarshaller() : RiverUnmarshaller.this));
        }
    };
    private static final InvocationHandler DUMMY_HANDLER = new DummyInvocationHandler();

    protected RiverUnmarshaller(RiverMarshallerFactory marshallerFactory, SerializableClassRegistry registry, MarshallingConfiguration configuration) {
        super((AbstractMarshallerFactory)marshallerFactory, configuration);
        this.registry = registry;
        this.instanceCache = new ArrayList(configuration.getInstanceCount());
        this.classCache = new ArrayList(configuration.getClassCount());
    }

    public void clearInstanceCache() throws IOException {
        this.instanceCache.clear();
    }

    public void clearClassCache() throws IOException {
        this.clearInstanceCache();
        this.classCache.clear();
    }

    public void close() throws IOException {
        this.finish();
    }

    public void finish() throws IOException {
        super.finish();
        this.blockUnmarshaller = null;
        this.objectInput = null;
        this.objectInputStream = null;
    }

    private ObjectInput getObjectInput() {
        ObjectInput objectInput = this.objectInput;
        return objectInput == null ? (this.objectInput = this.version > 0 ? this.getBlockUnmarshaller() : new MarshallerObjectInput((Unmarshaller)this)) : objectInput;
    }

    private BlockUnmarshaller getBlockUnmarshaller() {
        BlockUnmarshaller blockUnmarshaller = this.blockUnmarshaller;
        return blockUnmarshaller == null ? (this.blockUnmarshaller = new BlockUnmarshaller(this)) : blockUnmarshaller;
    }

    private RiverObjectInputStream getObjectInputStream() throws IOException {
        RiverObjectInputStream objectInputStream = this.objectInputStream;
        return objectInputStream == null ? (this.objectInputStream = this.createObjectInputStream()) : objectInputStream;
    }

    private RiverObjectInputStream createObjectInputStream() throws IOException {
        try {
            return AccessController.doPrivileged(this.createObjectInputStreamAction);
        }
        catch (PrivilegedActionException e) {
            throw (IOException)e.getCause();
        }
    }

    protected Object doReadObject(boolean unshared) throws ClassNotFoundException, IOException {
        SortedSet<Validator> validators;
        Object obj = this.doReadObject(this.readUnsignedByte(), unshared);
        if (this.depth == 0 && (validators = this.validators) != null) {
            this.validators = null;
            this.validatorSeq = 0;
            for (Validator validator : validators) {
                validator.getValidation().validateObject();
            }
        }
        return obj;
    }

    Object doReadObject(int leadByte, boolean unshared) throws IOException, ClassNotFoundException {
        ++this.depth;
        try {
            block181: while (true) {
                switch (leadByte) {
                    case 1: {
                        Object var3_3 = null;
                        return var3_3;
                    }
                    case 2: {
                        if (unshared) {
                            throw new InvalidObjectException("Attempt to read a backreference as unshared");
                        }
                        int index = this.readInt();
                        try {
                            Object obj = this.instanceCache.get(index);
                            if (obj != null) {
                                Object object = obj;
                                return object;
                            }
                        }
                        catch (IndexOutOfBoundsException e) {
                            // empty catch block
                        }
                        throw new InvalidObjectException("Attempt to read a backreference with an invalid ID (absolute " + index + ")");
                    }
                    case 57: {
                        if (unshared) {
                            throw new InvalidObjectException("Attempt to read a backreference as unshared");
                        }
                        int index = this.readByte() | 0xFFFFFF00;
                        try {
                            Object obj = this.instanceCache.get(index + this.instanceCache.size());
                            if (obj != null) {
                                Object object = obj;
                                return object;
                            }
                        }
                        catch (IndexOutOfBoundsException e) {
                            // empty catch block
                        }
                        throw new InvalidObjectException("Attempt to read a backreference with an invalid ID (relative near " + index + ")");
                    }
                    case 58: {
                        if (unshared) {
                            throw new InvalidObjectException("Attempt to read a backreference as unshared");
                        }
                        int index = this.readShort() | 0xFFFF0000;
                        try {
                            Object obj = this.instanceCache.get(index + this.instanceCache.size());
                            if (obj != null) {
                                Object object = obj;
                                return object;
                            }
                        }
                        catch (IndexOutOfBoundsException e) {
                            // empty catch block
                        }
                        throw new InvalidObjectException("Attempt to read a backreference with an invalid ID (relative nearish " + index + ")");
                    }
                    case 4: 
                    case 5: {
                        if (unshared != (leadByte == 5)) {
                            throw RiverUnmarshaller.sharedMismatch();
                        }
                        Object index = this.doReadNewObject(this.readUnsignedByte(), unshared);
                        return index;
                    }
                    case 61: {
                        String index = "";
                        return index;
                    }
                    case 62: {
                        int length = this.readUnsignedByte();
                        String s = UTFUtils.readUTFBytes((ByteInput)this, (int)(length == 0 ? 256 : length));
                        this.instanceCache.add(s);
                        String string = s;
                        return string;
                    }
                    case 63: {
                        int length = this.readUnsignedShort();
                        String s = UTFUtils.readUTFBytes((ByteInput)this, (int)(length == 0 ? 65536 : length));
                        this.instanceCache.add(s);
                        String string = s;
                        return string;
                    }
                    case 64: {
                        int length = this.readInt();
                        if (length <= 0) {
                            throw new StreamCorruptedException("Invalid length value for string in stream (" + length + ")");
                        }
                        String s = UTFUtils.readUTFBytes((ByteInput)this, (int)length);
                        this.instanceCache.add(s);
                        String string = s;
                        return string;
                    }
                    case 65: 
                    case 69: {
                        if (unshared != (leadByte == 69)) {
                            throw RiverUnmarshaller.sharedMismatch();
                        }
                        ArrayList<Object> instanceCache = this.instanceCache;
                        int idx = instanceCache.size();
                        instanceCache.add(null);
                        Object obj2 = Array.newInstance(this.doReadClassDescriptor(this.readUnsignedByte()).getType(), 0);
                        instanceCache.set(idx, obj2);
                        Object resolvedObject2 = this.objectResolver.readResolve(obj2);
                        if (unshared) {
                            instanceCache.set(idx, null);
                        } else if (obj2 != resolvedObject2) {
                            instanceCache.set(idx, resolvedObject2);
                        }
                        Object object = obj2;
                        return object;
                    }
                    case 66: 
                    case 70: {
                        if (unshared != (leadByte == 70)) {
                            throw RiverUnmarshaller.sharedMismatch();
                        }
                        int len = this.readUnsignedByte();
                        Object idx = this.doReadArray(len == 0 ? 256 : len, unshared);
                        return idx;
                    }
                    case 67: 
                    case 71: {
                        if (unshared != (leadByte == 71)) {
                            throw RiverUnmarshaller.sharedMismatch();
                        }
                        int len = this.readUnsignedShort();
                        Object idx = this.doReadArray(len == 0 ? 65536 : len, unshared);
                        return idx;
                    }
                    case 68: 
                    case 72: {
                        if (unshared != (leadByte == 72)) {
                            throw RiverUnmarshaller.sharedMismatch();
                        }
                        int len = this.readUnsignedShort();
                        Object idx = this.doReadArray(len, unshared);
                        return idx;
                    }
                    case 3: {
                        if (unshared) {
                            throw new InvalidObjectException("Attempt to read a predefined object as unshared");
                        }
                        if (this.version == 1) {
                            BlockUnmarshaller blockUnmarshaller = this.getBlockUnmarshaller();
                            Object obj = this.objectTable.readObject((Unmarshaller)blockUnmarshaller);
                            blockUnmarshaller.readToEndBlockData();
                            blockUnmarshaller.unblock();
                            Object obj2 = obj;
                            return obj2;
                        }
                        Object blockUnmarshaller = this.objectTable.readObject((Unmarshaller)this);
                        return blockUnmarshaller;
                    }
                    case 80: {
                        Object blockUnmarshaller = this.objectResolver.readResolve((Object)Boolean.TRUE);
                        return blockUnmarshaller;
                    }
                    case 81: {
                        Object blockUnmarshaller = this.objectResolver.readResolve((Object)Boolean.FALSE);
                        return blockUnmarshaller;
                    }
                    case 73: {
                        Object blockUnmarshaller = this.objectResolver.readResolve((Object)this.readByte());
                        return blockUnmarshaller;
                    }
                    case 74: {
                        Object blockUnmarshaller = this.objectResolver.readResolve((Object)this.readShort());
                        return blockUnmarshaller;
                    }
                    case 75: {
                        Object blockUnmarshaller = this.objectResolver.readResolve((Object)this.readInt());
                        return blockUnmarshaller;
                    }
                    case 76: {
                        Object blockUnmarshaller = this.objectResolver.readResolve((Object)this.readLong());
                        return blockUnmarshaller;
                    }
                    case 78: {
                        Object blockUnmarshaller = this.objectResolver.readResolve((Object)Float.valueOf(this.readFloat()));
                        return blockUnmarshaller;
                    }
                    case 79: {
                        Object blockUnmarshaller = this.objectResolver.readResolve((Object)this.readDouble());
                        return blockUnmarshaller;
                    }
                    case 77: {
                        Object blockUnmarshaller = this.objectResolver.readResolve((Object)Character.valueOf(this.readChar()));
                        return blockUnmarshaller;
                    }
                    case 33: {
                        Class<Byte> blockUnmarshaller = Byte.TYPE;
                        return blockUnmarshaller;
                    }
                    case 32: {
                        Class<Boolean> blockUnmarshaller = Boolean.TYPE;
                        return blockUnmarshaller;
                    }
                    case 37: {
                        Class<Character> blockUnmarshaller = Character.TYPE;
                        return blockUnmarshaller;
                    }
                    case 39: {
                        Class<Double> blockUnmarshaller = Double.TYPE;
                        return blockUnmarshaller;
                    }
                    case 38: {
                        Class<Float> blockUnmarshaller = Float.TYPE;
                        return blockUnmarshaller;
                    }
                    case 35: {
                        Class<Integer> blockUnmarshaller = Integer.TYPE;
                        return blockUnmarshaller;
                    }
                    case 36: {
                        Class<Long> blockUnmarshaller = Long.TYPE;
                        return blockUnmarshaller;
                    }
                    case 34: {
                        Class<Short> blockUnmarshaller = Short.TYPE;
                        return blockUnmarshaller;
                    }
                    case 40: {
                        Class<Void> blockUnmarshaller = Void.TYPE;
                        return blockUnmarshaller;
                    }
                    case 42: {
                        Class<Byte> blockUnmarshaller = Byte.class;
                        return blockUnmarshaller;
                    }
                    case 41: {
                        Class<Boolean> blockUnmarshaller = Boolean.class;
                        return blockUnmarshaller;
                    }
                    case 46: {
                        Class<Character> blockUnmarshaller = Character.class;
                        return blockUnmarshaller;
                    }
                    case 48: {
                        Class<Double> blockUnmarshaller = Double.class;
                        return blockUnmarshaller;
                    }
                    case 47: {
                        Class<Float> blockUnmarshaller = Float.class;
                        return blockUnmarshaller;
                    }
                    case 44: {
                        Class<Integer> blockUnmarshaller = Integer.class;
                        return blockUnmarshaller;
                    }
                    case 45: {
                        Class<Long> blockUnmarshaller = Long.class;
                        return blockUnmarshaller;
                    }
                    case 43: {
                        Class<Short> blockUnmarshaller = Short.class;
                        return blockUnmarshaller;
                    }
                    case 49: {
                        Class<Void> blockUnmarshaller = Void.class;
                        return blockUnmarshaller;
                    }
                    case 22: {
                        Class<Object> blockUnmarshaller = Object.class;
                        return blockUnmarshaller;
                    }
                    case 21: {
                        Class<Class> blockUnmarshaller = Class.class;
                        return blockUnmarshaller;
                    }
                    case 20: {
                        Class<String> blockUnmarshaller = String.class;
                        return blockUnmarshaller;
                    }
                    case 23: {
                        Class<Enum> blockUnmarshaller = Enum.class;
                        return blockUnmarshaller;
                    }
                    case 25: {
                        Class<byte[]> blockUnmarshaller = byte[].class;
                        return blockUnmarshaller;
                    }
                    case 24: {
                        Class<boolean[]> blockUnmarshaller = boolean[].class;
                        return blockUnmarshaller;
                    }
                    case 29: {
                        Class<char[]> blockUnmarshaller = char[].class;
                        return blockUnmarshaller;
                    }
                    case 31: {
                        Class<double[]> blockUnmarshaller = double[].class;
                        return blockUnmarshaller;
                    }
                    case 30: {
                        Class<float[]> blockUnmarshaller = float[].class;
                        return blockUnmarshaller;
                    }
                    case 27: {
                        Class<int[]> blockUnmarshaller = int[].class;
                        return blockUnmarshaller;
                    }
                    case 28: {
                        Class<long[]> blockUnmarshaller = long[].class;
                        return blockUnmarshaller;
                    }
                    case 26: {
                        Class<short[]> blockUnmarshaller = short[].class;
                        return blockUnmarshaller;
                    }
                    case 90: {
                        Class<ArrayList> blockUnmarshaller = ArrayList.class;
                        return blockUnmarshaller;
                    }
                    case 100: {
                        Class<HashMap> blockUnmarshaller = HashMap.class;
                        return blockUnmarshaller;
                    }
                    case 94: {
                        Class<HashSet> blockUnmarshaller = HashSet.class;
                        return blockUnmarshaller;
                    }
                    case 101: {
                        Class<Hashtable> blockUnmarshaller = Hashtable.class;
                        return blockUnmarshaller;
                    }
                    case 99: {
                        Class<HashMap> blockUnmarshaller = HashMap.class;
                        return blockUnmarshaller;
                    }
                    case 102: {
                        Class<LinkedHashMap> blockUnmarshaller = LinkedHashMap.class;
                        return blockUnmarshaller;
                    }
                    case 95: {
                        Class<LinkedHashSet> blockUnmarshaller = LinkedHashSet.class;
                        return blockUnmarshaller;
                    }
                    case 91: {
                        Class<LinkedList> blockUnmarshaller = LinkedList.class;
                        return blockUnmarshaller;
                    }
                    case 103: {
                        Class<TreeMap> blockUnmarshaller = TreeMap.class;
                        return blockUnmarshaller;
                    }
                    case 96: {
                        Class<TreeSet> blockUnmarshaller = TreeSet.class;
                        return blockUnmarshaller;
                    }
                    case 92: {
                        int idx = this.instanceCache.size();
                        this.instanceCache.add(null);
                        List<Object> obj = Collections.singletonList(this.doReadObject(false));
                        Object resolvedObject = this.objectResolver.readResolve(obj);
                        if (!unshared) {
                            this.instanceCache.set(idx, resolvedObject);
                        }
                        Object resolvedObject2 = resolvedObject;
                        return resolvedObject2;
                    }
                    case 97: {
                        int idx = this.instanceCache.size();
                        this.instanceCache.add(null);
                        Set<Object> obj = Collections.singleton(this.doReadObject(false));
                        Object resolvedObject = this.objectResolver.readResolve(obj);
                        if (!unshared) {
                            this.instanceCache.set(idx, resolvedObject);
                        }
                        Object resolvedObject2 = resolvedObject;
                        return resolvedObject2;
                    }
                    case 104: {
                        int idx = this.instanceCache.size();
                        this.instanceCache.add(null);
                        Map<Object, Object> obj = Collections.singletonMap(this.doReadObject(false), this.doReadObject(false));
                        Object resolvedObject = this.objectResolver.readResolve(obj);
                        if (!unshared) {
                            this.instanceCache.set(idx, resolvedObject);
                        }
                        Object resolvedObject2 = resolvedObject;
                        return resolvedObject2;
                    }
                    case 93: {
                        List idx = Collections.emptyList();
                        return idx;
                    }
                    case 98: {
                        Set idx = Collections.emptySet();
                        return idx;
                    }
                    case 105: {
                        Map idx = Collections.emptyMap();
                        return idx;
                    }
                    case 82: 
                    case 83: 
                    case 84: 
                    case 85: 
                    case 86: 
                    case 87: 
                    case 88: 
                    case 89: {
                        int len;
                        switch (leadByte) {
                            case 82: 
                            case 86: {
                                len = 0;
                                break;
                            }
                            case 83: 
                            case 87: {
                                int b = this.readUnsignedByte();
                                len = b == 0 ? 256 : b;
                                break;
                            }
                            case 84: 
                            case 88: {
                                int b = this.readUnsignedShort();
                                len = b == 0 ? 65536 : b;
                                break;
                            }
                            case 85: 
                            case 89: {
                                len = this.readInt();
                                break;
                            }
                            default: {
                                throw new IllegalStateException();
                            }
                        }
                        int id = this.readUnsignedByte();
                        ArrayList<Object> instanceCache = this.instanceCache;
                        switch (id) {
                            case 90: {
                                ArrayList<Object> target = new ArrayList<Object>(len);
                                int idx = instanceCache.size();
                                instanceCache.add(target);
                                for (int i = 0; i < len; ++i) {
                                    target.add(this.doReadObject(false));
                                }
                                Object resolvedObject = this.objectResolver.readResolve(target);
                                if (unshared) {
                                    instanceCache.set(idx, null);
                                } else if (target != resolvedObject) {
                                    instanceCache.set(idx, resolvedObject);
                                }
                                Object object = resolvedObject;
                                return object;
                            }
                            case 94: {
                                HashSet<Object> target = new HashSet<Object>(len);
                                int idx = instanceCache.size();
                                instanceCache.add(target);
                                for (int i = 0; i < len; ++i) {
                                    target.add(this.doReadObject(false));
                                }
                                Object resolvedObject = this.objectResolver.readResolve(target);
                                if (unshared) {
                                    instanceCache.set(idx, null);
                                } else if (target != resolvedObject) {
                                    instanceCache.set(idx, resolvedObject);
                                }
                                Object object = resolvedObject;
                                return object;
                            }
                            case 95: {
                                LinkedHashSet<Object> target = new LinkedHashSet<Object>(len);
                                int idx = instanceCache.size();
                                instanceCache.add(target);
                                for (int i = 0; i < len; ++i) {
                                    target.add(this.doReadObject(false));
                                }
                                Object resolvedObject = this.objectResolver.readResolve(target);
                                if (unshared) {
                                    instanceCache.set(idx, null);
                                } else if (target != resolvedObject) {
                                    instanceCache.set(idx, resolvedObject);
                                }
                                Object object = resolvedObject;
                                return object;
                            }
                            case 91: {
                                LinkedList<Object> target = new LinkedList<Object>();
                                int idx = instanceCache.size();
                                instanceCache.add(target);
                                for (int i = 0; i < len; ++i) {
                                    target.add(this.doReadObject(false));
                                }
                                Object resolvedObject = this.objectResolver.readResolve(target);
                                if (unshared) {
                                    instanceCache.set(idx, null);
                                } else if (target != resolvedObject) {
                                    instanceCache.set(idx, resolvedObject);
                                }
                                Object object = resolvedObject;
                                return object;
                            }
                            case 96: {
                                TreeSet<Object> target = new TreeSet<Object>((Comparator)this.doReadObject(false));
                                int idx = instanceCache.size();
                                instanceCache.add(target);
                                for (int i = 0; i < len; ++i) {
                                    target.add(this.doReadObject(false));
                                }
                                Object resolvedObject = this.objectResolver.readResolve(target);
                                if (unshared) {
                                    instanceCache.set(idx, null);
                                } else if (target != resolvedObject) {
                                    instanceCache.set(idx, resolvedObject);
                                }
                                Object object = resolvedObject;
                                return object;
                            }
                            case 100: {
                                HashMap<Object, Object> target = new HashMap<Object, Object>(len);
                                int idx = instanceCache.size();
                                instanceCache.add(target);
                                for (int i = 0; i < len; ++i) {
                                    target.put(this.doReadObject(false), this.doReadObject(false));
                                }
                                Object resolvedObject = this.objectResolver.readResolve(target);
                                if (unshared) {
                                    instanceCache.set(idx, null);
                                } else if (target != resolvedObject) {
                                    instanceCache.set(idx, resolvedObject);
                                }
                                Object object = resolvedObject;
                                return object;
                            }
                            case 101: {
                                Hashtable<Object, Object> target = new Hashtable<Object, Object>(len);
                                int idx = instanceCache.size();
                                instanceCache.add(target);
                                for (int i = 0; i < len; ++i) {
                                    target.put(this.doReadObject(false), this.doReadObject(false));
                                }
                                Object resolvedObject = this.objectResolver.readResolve(target);
                                if (unshared) {
                                    instanceCache.set(idx, null);
                                } else if (target != resolvedObject) {
                                    instanceCache.set(idx, resolvedObject);
                                }
                                Object object = resolvedObject;
                                return object;
                            }
                            case 99: {
                                IdentityHashMap<Object, Object> target = new IdentityHashMap<Object, Object>(len);
                                int idx = instanceCache.size();
                                instanceCache.add(target);
                                for (int i = 0; i < len; ++i) {
                                    target.put(this.doReadObject(false), this.doReadObject(false));
                                }
                                Object resolvedObject = this.objectResolver.readResolve(target);
                                if (unshared) {
                                    instanceCache.set(idx, null);
                                } else if (target != resolvedObject) {
                                    instanceCache.set(idx, resolvedObject);
                                }
                                Object object = resolvedObject;
                                return object;
                            }
                            case 102: {
                                LinkedHashMap<Object, Object> target = new LinkedHashMap<Object, Object>(len);
                                int idx = instanceCache.size();
                                instanceCache.add(target);
                                for (int i = 0; i < len; ++i) {
                                    target.put(this.doReadObject(false), this.doReadObject(false));
                                }
                                Object resolvedObject = this.objectResolver.readResolve(target);
                                if (unshared) {
                                    instanceCache.set(idx, null);
                                } else if (target != resolvedObject) {
                                    instanceCache.set(idx, resolvedObject);
                                }
                                Object object = resolvedObject;
                                return object;
                            }
                            case 103: {
                                TreeMap<Object, Object> target = new TreeMap<Object, Object>((Comparator)this.doReadObject(false));
                                int idx = instanceCache.size();
                                instanceCache.add(target);
                                for (int i = 0; i < len; ++i) {
                                    target.put(this.doReadObject(false), this.doReadObject(false));
                                }
                                Object resolvedObject = this.objectResolver.readResolve(target);
                                if (unshared) {
                                    instanceCache.set(idx, null);
                                } else if (target != resolvedObject) {
                                    instanceCache.set(idx, resolvedObject);
                                }
                                Object object = resolvedObject;
                                return object;
                            }
                        }
                        throw new StreamCorruptedException("Unexpected byte foudn when reading a collection type: " + leadByte);
                    }
                    case 54: {
                        if (this.depth > 1) {
                            throw new StreamCorruptedException("ID_CLEAR_CLASS_CACHE token in the middle of stream processing");
                        }
                        this.classCache.clear();
                        this.instanceCache.clear();
                        leadByte = this.readUnsignedByte();
                        continue block181;
                    }
                    case 55: {
                        if (this.depth > 1) {
                            throw new StreamCorruptedException("ID_CLEAR_INSTANCE_CACHE token in the middle of stream processing");
                        }
                        this.instanceCache.clear();
                        continue block181;
                    }
                }
                break;
            }
            throw new StreamCorruptedException("Unexpected byte found when reading an object: " + leadByte);
        }
        finally {
            --this.depth;
        }
    }

    private static InvalidObjectException sharedMismatch() {
        return new InvalidObjectException("Shared/unshared object mismatch");
    }

    ClassDescriptor doReadClassDescriptor(int classType) throws IOException, ClassNotFoundException {
        ArrayList<ClassDescriptor> classCache = this.classCache;
        switch (classType) {
            case 6: {
                return classCache.get(this.readInt());
            }
            case 59: {
                return classCache.get((this.readByte() | 0xFFFFFF00) + classCache.size());
            }
            case 60: {
                return classCache.get((this.readShort() | 0xFFFF0000) + classCache.size());
            }
            case 19: {
                int idx = classCache.size();
                classCache.add(null);
                Class<?> type = this.readClassTableClass();
                ClassDescriptor descriptor = new ClassDescriptor(type, 12);
                classCache.set(idx, descriptor);
                return descriptor;
            }
            case 17: {
                int idx = classCache.size();
                classCache.add(null);
                Class<?> type = this.readClassTableClass();
                ClassDescriptor descriptor = new ClassDescriptor(type, 10);
                classCache.set(idx, descriptor);
                return descriptor;
            }
            case 18: {
                int idx = classCache.size();
                classCache.add(null);
                Class<?> type = this.readClassTableClass();
                Externalizer externalizer = (Externalizer)this.readObject();
                ExternalizerClassDescriptor descriptor = new ExternalizerClassDescriptor(type, externalizer);
                classCache.set(idx, descriptor);
                return descriptor;
            }
            case 14: {
                int idx = classCache.size();
                classCache.add(null);
                Class<?> type = this.readClassTableClass();
                ClassDescriptor descriptor = new ClassDescriptor(type, 7);
                classCache.set(idx, descriptor);
                return descriptor;
            }
            case 15: {
                int idx = classCache.size();
                classCache.add(null);
                Class<?> type = this.readClassTableClass();
                ClassDescriptor descriptor = new ClassDescriptor(type, 8);
                classCache.set(idx, descriptor);
                return descriptor;
            }
            case 16: {
                int idx = classCache.size();
                classCache.add(null);
                Class<?> type = this.readClassTableClass();
                SerializableClass serializableClass = this.registry.lookup(type);
                int descType = this.version > 0 && serializableClass.hasWriteObject() ? 56 : 9;
                SerializableClassDescriptor descriptor = new SerializableClassDescriptor(serializableClass, this.doReadClassDescriptor(this.readUnsignedByte()), serializableClass.getFields(), descType);
                classCache.set(idx, descriptor);
                return descriptor;
            }
            case 7: {
                String className = this.readString();
                Class<?> clazz = this.doResolveClass(className, 0L);
                ClassDescriptor descriptor = new ClassDescriptor(clazz, 7);
                classCache.add(descriptor);
                return descriptor;
            }
            case 8: {
                ClassDescriptor descriptor;
                String[] interfaces = new String[this.readInt()];
                for (int i = 0; i < interfaces.length; ++i) {
                    interfaces[i] = this.readString();
                }
                if (this.version == 1) {
                    BlockUnmarshaller blockUnmarshaller = this.getBlockUnmarshaller();
                    descriptor = new ClassDescriptor(this.classResolver.resolveProxyClass((Unmarshaller)blockUnmarshaller, interfaces), 8);
                    blockUnmarshaller.readToEndBlockData();
                    blockUnmarshaller.unblock();
                } else {
                    descriptor = new ClassDescriptor(this.classResolver.resolveProxyClass((Unmarshaller)this, interfaces), 8);
                }
                classCache.add(descriptor);
                return descriptor;
            }
            case 9: 
            case 56: {
                int idx = classCache.size();
                classCache.add(null);
                String className = this.readString();
                long uid = this.readLong();
                Class<?> clazz = this.doResolveClass(className, uid);
                Class<?> superClazz = clazz.getSuperclass();
                classCache.set(idx, new IncompleteClassDescriptor(clazz, classType));
                int cnt = this.readInt();
                String[] names = new String[cnt];
                ClassDescriptor[] descriptors = new ClassDescriptor[cnt];
                boolean[] unshareds = new boolean[cnt];
                for (int i = 0; i < cnt; ++i) {
                    names[i] = this.readUTF();
                    descriptors[i] = this.doReadClassDescriptor(this.readUnsignedByte());
                    unshareds[i] = this.readBoolean();
                }
                ClassDescriptor superDescriptor = this.doReadClassDescriptor(this.readUnsignedByte());
                if (superDescriptor != null) {
                    Class<?> superType = superDescriptor.getType();
                    if (!superType.isAssignableFrom(clazz)) {
                        throw new InvalidClassException(clazz.getName(), "Class does not extend stream superclass");
                    }
                    for (Class<?> cl = superClazz; cl != superType; cl = cl.getSuperclass()) {
                        superDescriptor = new SerializableClassDescriptor(this.registry.lookup(cl), superDescriptor);
                    }
                } else if (superClazz != null) {
                    Class<?> cl = superClazz;
                    while (Serializable.class.isAssignableFrom(cl)) {
                        superDescriptor = new SerializableClassDescriptor(this.registry.lookup(cl), superDescriptor);
                        cl = cl.getSuperclass();
                    }
                }
                SerializableClass serializableClass = this.registry.lookup(clazz);
                SerializableField[] fields = new SerializableField[cnt];
                for (int i = 0; i < cnt; ++i) {
                    fields[i] = serializableClass.getSerializableField(names[i], descriptors[i].getType(), unshareds[i]);
                }
                SerializableClassDescriptor descriptor = new SerializableClassDescriptor(serializableClass, superDescriptor, fields, classType);
                classCache.set(idx, descriptor);
                return descriptor;
            }
            case 10: {
                String className = this.readString();
                long uid = this.readLong();
                Class<?> clazz = this.doResolveClass(className, uid);
                ClassDescriptor descriptor = new ClassDescriptor(clazz, 10);
                classCache.add(descriptor);
                return descriptor;
            }
            case 11: {
                String className = this.readString();
                int idx = classCache.size();
                classCache.add(null);
                Class<?> clazz = this.doResolveClass(className, 0L);
                Externalizer externalizer = (Externalizer)this.readObject();
                ExternalizerClassDescriptor descriptor = new ExternalizerClassDescriptor(clazz, externalizer);
                classCache.set(idx, descriptor);
                return descriptor;
            }
            case 12: {
                ClassDescriptor descriptor = new ClassDescriptor(this.doResolveClass(this.readString(), 0L), 12);
                classCache.add(descriptor);
                return descriptor;
            }
            case 13: {
                ClassDescriptor elementType = this.doReadClassDescriptor(this.readUnsignedByte());
                ClassDescriptor arrayDescriptor = new ClassDescriptor(Array.newInstance(elementType.getType(), 0).getClass(), 13);
                classCache.add(arrayDescriptor);
                return arrayDescriptor;
            }
            case 20: {
                return ClassDescriptor.STRING_DESCRIPTOR;
            }
            case 22: {
                return ClassDescriptor.OBJECT_DESCRIPTOR;
            }
            case 21: {
                return ClassDescriptor.CLASS_DESCRIPTOR;
            }
            case 23: {
                return ClassDescriptor.ENUM_DESCRIPTOR;
            }
            case 24: {
                return ClassDescriptor.BOOLEAN_ARRAY;
            }
            case 25: {
                return ClassDescriptor.BYTE_ARRAY;
            }
            case 26: {
                return ClassDescriptor.SHORT_ARRAY;
            }
            case 27: {
                return ClassDescriptor.INT_ARRAY;
            }
            case 28: {
                return ClassDescriptor.LONG_ARRAY;
            }
            case 29: {
                return ClassDescriptor.CHAR_ARRAY;
            }
            case 30: {
                return ClassDescriptor.FLOAT_ARRAY;
            }
            case 31: {
                return ClassDescriptor.DOUBLE_ARRAY;
            }
            case 32: {
                return ClassDescriptor.BOOLEAN;
            }
            case 33: {
                return ClassDescriptor.BYTE;
            }
            case 37: {
                return ClassDescriptor.CHAR;
            }
            case 39: {
                return ClassDescriptor.DOUBLE;
            }
            case 38: {
                return ClassDescriptor.FLOAT;
            }
            case 35: {
                return ClassDescriptor.INT;
            }
            case 36: {
                return ClassDescriptor.LONG;
            }
            case 34: {
                return ClassDescriptor.SHORT;
            }
            case 40: {
                return ClassDescriptor.VOID;
            }
            case 41: {
                return ClassDescriptor.BOOLEAN_OBJ;
            }
            case 42: {
                return ClassDescriptor.BYTE_OBJ;
            }
            case 43: {
                return ClassDescriptor.SHORT_OBJ;
            }
            case 44: {
                return ClassDescriptor.INTEGER_OBJ;
            }
            case 45: {
                return ClassDescriptor.LONG_OBJ;
            }
            case 46: {
                return ClassDescriptor.CHARACTER_OBJ;
            }
            case 47: {
                return ClassDescriptor.FLOAT_OBJ;
            }
            case 48: {
                return ClassDescriptor.DOUBLE_OBJ;
            }
            case 49: {
                return ClassDescriptor.VOID_OBJ;
            }
        }
        throw new InvalidClassException("Unexpected class ID " + classType);
    }

    private Class<?> readClassTableClass() throws IOException, ClassNotFoundException {
        if (this.version == 1) {
            BlockUnmarshaller blockUnmarshaller = this.getBlockUnmarshaller();
            Class type = this.classTable.readClass((Unmarshaller)blockUnmarshaller);
            blockUnmarshaller.readToEndBlockData();
            blockUnmarshaller.unblock();
            return type;
        }
        return this.classTable.readClass((Unmarshaller)this);
    }

    private Class<?> doResolveClass(String className, long uid) throws IOException, ClassNotFoundException {
        if (this.version == 1) {
            BlockUnmarshaller blockUnmarshaller = this.getBlockUnmarshaller();
            Class resolvedClass = this.classResolver.resolveClass((Unmarshaller)blockUnmarshaller, className, uid);
            blockUnmarshaller.readToEndBlockData();
            blockUnmarshaller.unblock();
            return resolvedClass;
        }
        return this.classResolver.resolveClass((Unmarshaller)this, className, uid);
    }

    protected String readString() throws IOException {
        int length = this.readInt();
        return UTFUtils.readUTFBytes((ByteInput)this, (int)length);
    }

    protected void doStart() throws IOException {
        super.doStart();
        if (this.configuredVersion > 0) {
            int version = this.readUnsignedByte();
            if (version > 2) {
                throw new IOException("Unsupported protocol version " + version);
            }
            this.version = version;
        } else {
            this.version = 0;
        }
    }

    private static Object createProxyInstance(Creator creator, Class<?> type) throws IOException {
        try {
            return creator.create(type);
        }
        catch (Exception e) {
            return Proxy.newProxyInstance(type.getClassLoader(), type.getInterfaces(), DUMMY_HANDLER);
        }
    }

    protected Object doReadNewObject(int streamClassType, boolean unshared) throws ClassNotFoundException, IOException {
        ClassDescriptor descriptor = this.doReadClassDescriptor(streamClassType);
        int classType = descriptor.getTypeID();
        ArrayList<Object> instanceCache = this.instanceCache;
        switch (classType) {
            case 8: {
                Class<?> type = descriptor.getType();
                Object obj = RiverUnmarshaller.createProxyInstance(this.creator, type);
                int idx = instanceCache.size();
                instanceCache.add(obj);
                try {
                    proxyInvocationHandler.set(obj, this.doReadObject(unshared));
                }
                catch (IllegalAccessException e) {
                    throw new InvalidClassException(type.getName(), "Unable to set proxy invocation handler");
                }
                Object resolvedObject = this.objectResolver.readResolve(obj);
                if (unshared) {
                    instanceCache.set(idx, null);
                } else if (obj != resolvedObject) {
                    instanceCache.set(idx, resolvedObject);
                }
                return resolvedObject;
            }
            case 9: 
            case 56: {
                SerializableClassDescriptor serializableClassDescriptor = (SerializableClassDescriptor)descriptor;
                Class<?> type = descriptor.getType();
                SerializableClass serializableClass = serializableClassDescriptor.getSerializableClass();
                Object obj = this.creator.create(type);
                int idx = instanceCache.size();
                instanceCache.add(obj);
                this.doInitSerializable(obj, serializableClassDescriptor);
                Object resolvedObject = this.objectResolver.readResolve(serializableClass.hasReadResolve() ? serializableClass.callReadResolve(obj) : obj);
                if (unshared) {
                    instanceCache.set(idx, null);
                } else if (obj != resolvedObject) {
                    instanceCache.set(idx, resolvedObject);
                }
                return resolvedObject;
            }
            case 10: {
                Class<?> type = descriptor.getType();
                SerializableClass serializableClass = this.registry.lookup(type);
                Externalizable obj = (Externalizable)this.creator.create(type);
                int idx = instanceCache.size();
                instanceCache.add(obj);
                if (this.version > 0) {
                    BlockUnmarshaller blockUnmarshaller = this.getBlockUnmarshaller();
                    obj.readExternal((ObjectInput)((Object)blockUnmarshaller));
                    blockUnmarshaller.readToEndBlockData();
                    blockUnmarshaller.unblock();
                } else {
                    obj.readExternal(this.getObjectInput());
                }
                Object resolvedObject = this.objectResolver.readResolve(serializableClass.hasReadResolve() ? serializableClass.callReadResolve((Object)obj) : obj);
                if (unshared) {
                    instanceCache.set(idx, null);
                } else if (obj != resolvedObject) {
                    instanceCache.set(idx, resolvedObject);
                }
                return resolvedObject;
            }
            case 11: {
                Object obj;
                int idx = instanceCache.size();
                instanceCache.add(null);
                Externalizer externalizer = ((ExternalizerClassDescriptor)descriptor).getExternalizer();
                Class<?> type = descriptor.getType();
                SerializableClass serializableClass = this.registry.lookup(type);
                if (this.version > 0) {
                    BlockUnmarshaller blockUnmarshaller = this.getBlockUnmarshaller();
                    obj = externalizer.createExternal(type, (ObjectInput)((Object)blockUnmarshaller), this.creator);
                    instanceCache.set(idx, obj);
                    externalizer.readExternal(obj, (ObjectInput)((Object)blockUnmarshaller));
                    blockUnmarshaller.readToEndBlockData();
                    blockUnmarshaller.unblock();
                } else {
                    obj = externalizer.createExternal(type, (ObjectInput)((Object)this), this.creator);
                    instanceCache.set(idx, obj);
                    externalizer.readExternal(obj, this.getObjectInput());
                }
                Object resolvedObject = this.objectResolver.readResolve(serializableClass.hasReadResolve() ? serializableClass.callReadResolve(obj) : obj);
                if (unshared) {
                    instanceCache.set(idx, null);
                } else if (obj != resolvedObject) {
                    instanceCache.set(idx, resolvedObject);
                }
                return resolvedObject;
            }
            case 12: {
                String name = this.readString();
                Enum obj = RiverUnmarshaller.resolveEnumConstant(descriptor, name);
                int idx = instanceCache.size();
                instanceCache.add(obj);
                Object resolvedObject = this.objectResolver.readResolve((Object)obj);
                if (unshared) {
                    instanceCache.set(idx, null);
                } else if (obj != resolvedObject) {
                    instanceCache.set(idx, resolvedObject);
                }
                return resolvedObject;
            }
            case 13: {
                return this.doReadObjectArray(this.readInt(), descriptor.getType().getComponentType(), unshared);
            }
            case 20: {
                String obj = this.readString();
                Object resolvedObject = this.objectResolver.readResolve((Object)obj);
                instanceCache.add(unshared ? null : resolvedObject);
                return resolvedObject;
            }
            case 21: {
                ClassDescriptor nestedDescriptor = this.doReadClassDescriptor(this.readUnsignedByte());
                Class<?> obj = nestedDescriptor.getType();
                return obj;
            }
            case 24: {
                return this.doReadBooleanArray(this.readInt(), unshared);
            }
            case 25: {
                return this.doReadByteArray(this.readInt(), unshared);
            }
            case 26: {
                return this.doReadShortArray(this.readInt(), unshared);
            }
            case 27: {
                return this.doReadIntArray(this.readInt(), unshared);
            }
            case 28: {
                return this.doReadLongArray(this.readInt(), unshared);
            }
            case 29: {
                return this.doReadCharArray(this.readInt(), unshared);
            }
            case 30: {
                return this.doReadFloatArray(this.readInt(), unshared);
            }
            case 31: {
                return this.doReadDoubleArray(this.readInt(), unshared);
            }
            case 41: {
                return this.objectResolver.readResolve((Object)this.readBoolean());
            }
            case 42: {
                return this.objectResolver.readResolve((Object)this.readByte());
            }
            case 43: {
                return this.objectResolver.readResolve((Object)this.readShort());
            }
            case 44: {
                return this.objectResolver.readResolve((Object)this.readInt());
            }
            case 45: {
                return this.objectResolver.readResolve((Object)this.readLong());
            }
            case 46: {
                return this.objectResolver.readResolve((Object)Character.valueOf(this.readChar()));
            }
            case 47: {
                return this.objectResolver.readResolve((Object)Float.valueOf(this.readFloat()));
            }
            case 48: {
                return this.objectResolver.readResolve((Object)this.readDouble());
            }
            case 7: 
            case 22: {
                throw new NotSerializableException("(remote)" + descriptor.getType().getName());
            }
        }
        throw new InvalidObjectException("Unexpected class type " + classType);
    }

    private Object doReadDoubleArray(int cnt, boolean unshared) throws IOException {
        double[] array = new double[cnt];
        for (int i = 0; i < cnt; ++i) {
            array[i] = this.readDouble();
        }
        Object resolvedObject = this.objectResolver.readResolve((Object)array);
        this.instanceCache.add(unshared ? null : resolvedObject);
        return resolvedObject;
    }

    private Object doReadFloatArray(int cnt, boolean unshared) throws IOException {
        float[] array = new float[cnt];
        for (int i = 0; i < cnt; ++i) {
            array[i] = this.readFloat();
        }
        Object resolvedObject = this.objectResolver.readResolve((Object)array);
        this.instanceCache.add(unshared ? null : resolvedObject);
        return resolvedObject;
    }

    private Object doReadCharArray(int cnt, boolean unshared) throws IOException {
        char[] array = new char[cnt];
        for (int i = 0; i < cnt; ++i) {
            array[i] = this.readChar();
        }
        Object resolvedObject = this.objectResolver.readResolve((Object)array);
        this.instanceCache.add(unshared ? null : resolvedObject);
        return resolvedObject;
    }

    private Object doReadLongArray(int cnt, boolean unshared) throws IOException {
        long[] array = new long[cnt];
        for (int i = 0; i < cnt; ++i) {
            array[i] = this.readLong();
        }
        Object resolvedObject = this.objectResolver.readResolve((Object)array);
        this.instanceCache.add(unshared ? null : resolvedObject);
        return resolvedObject;
    }

    private Object doReadIntArray(int cnt, boolean unshared) throws IOException {
        int[] array = new int[cnt];
        for (int i = 0; i < cnt; ++i) {
            array[i] = this.readInt();
        }
        Object resolvedObject = this.objectResolver.readResolve((Object)array);
        this.instanceCache.add(unshared ? null : resolvedObject);
        return resolvedObject;
    }

    private Object doReadShortArray(int cnt, boolean unshared) throws IOException {
        short[] array = new short[cnt];
        for (int i = 0; i < cnt; ++i) {
            array[i] = this.readShort();
        }
        Object resolvedObject = this.objectResolver.readResolve((Object)array);
        this.instanceCache.add(unshared ? null : resolvedObject);
        return resolvedObject;
    }

    private Object doReadByteArray(int cnt, boolean unshared) throws IOException {
        byte[] array = new byte[cnt];
        this.readFully(array, 0, array.length);
        Object resolvedObject = this.objectResolver.readResolve((Object)array);
        this.instanceCache.add(unshared ? null : resolvedObject);
        return resolvedObject;
    }

    private Object doReadBooleanArray(int cnt, boolean unshared) throws IOException {
        boolean[] array = new boolean[cnt];
        byte v = 0;
        int bc = cnt & 0xFFFFFFF8;
        int i = 0;
        while (i < bc) {
            v = this.readByte();
            array[i++] = (v & 1) != 0;
            array[i++] = (v & 2) != 0;
            array[i++] = (v & 4) != 0;
            array[i++] = (v & 8) != 0;
            array[i++] = (v & 0x10) != 0;
            array[i++] = (v & 0x20) != 0;
            array[i++] = (v & 0x40) != 0;
            array[i++] = (v & 0x80) != 0;
        }
        if (bc < cnt) {
            v = this.readByte();
            switch (cnt & 7) {
                case 7: {
                    array[bc + 6] = (v & 0x40) != 0;
                }
                case 6: {
                    array[bc + 5] = (v & 0x20) != 0;
                }
                case 5: {
                    array[bc + 4] = (v & 0x10) != 0;
                }
                case 4: {
                    array[bc + 3] = (v & 8) != 0;
                }
                case 3: {
                    array[bc + 2] = (v & 4) != 0;
                }
                case 2: {
                    array[bc + 1] = (v & 2) != 0;
                }
                case 1: {
                    array[bc] = (v & 1) != 0;
                }
            }
        }
        Object resolvedObject = this.objectResolver.readResolve((Object)array);
        this.instanceCache.add(unshared ? null : resolvedObject);
        return resolvedObject;
    }

    private Object doReadObjectArray(int cnt, Class<?> type, boolean unshared) throws ClassNotFoundException, IOException {
        Object[] array = (Object[])Array.newInstance(type, cnt);
        int idx = this.instanceCache.size();
        this.instanceCache.add(array);
        for (int i = 0; i < cnt; ++i) {
            array[i] = this.doReadObject(unshared);
        }
        Object resolvedObject = this.objectResolver.readResolve((Object)array);
        if (unshared) {
            this.instanceCache.set(idx, null);
        } else if (array != resolvedObject) {
            this.instanceCache.set(idx, resolvedObject);
        }
        return resolvedObject;
    }

    private Object doReadArray(int cnt, boolean unshared) throws ClassNotFoundException, IOException {
        int leadByte = this.readUnsignedByte();
        switch (leadByte) {
            case 32: {
                return this.doReadBooleanArray(cnt, unshared);
            }
            case 33: {
                return this.doReadByteArray(cnt, unshared);
            }
            case 37: {
                return this.doReadCharArray(cnt, unshared);
            }
            case 39: {
                return this.doReadDoubleArray(cnt, unshared);
            }
            case 38: {
                return this.doReadFloatArray(cnt, unshared);
            }
            case 35: {
                return this.doReadIntArray(cnt, unshared);
            }
            case 36: {
                return this.doReadLongArray(cnt, unshared);
            }
            case 34: {
                return this.doReadShortArray(cnt, unshared);
            }
        }
        return this.doReadObjectArray(cnt, this.doReadClassDescriptor(leadByte).getType(), unshared);
    }

    private static Enum resolveEnumConstant(ClassDescriptor descriptor, String name) {
        return Enum.valueOf(descriptor.getType(), name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doInitSerializable(Object obj, SerializableClassDescriptor descriptor) throws IOException, ClassNotFoundException {
        Class<?> type = descriptor.getType();
        SerializableClass info = this.registry.lookup(type);
        ClassDescriptor superDescriptor = descriptor.getSuperClassDescriptor();
        if (superDescriptor instanceof SerializableClassDescriptor) {
            SerializableClassDescriptor serializableSuperDescriptor = (SerializableClassDescriptor)superDescriptor;
            this.doInitSerializable(obj, serializableSuperDescriptor);
        }
        int typeId = descriptor.getTypeID();
        BlockUnmarshaller blockUnmarshaller = this.getBlockUnmarshaller();
        if (descriptor.isGap()) {
            if (info.hasReadObjectNoData()) {
                info.callReadObjectNoData(obj);
            }
        } else if (info.hasReadObject()) {
            RiverObjectInputStream objectInputStream = this.getObjectInputStream();
            SerializableClassDescriptor oldDescriptor = objectInputStream.swapClass(descriptor);
            Object oldObj = objectInputStream.swapCurrent(obj);
            RiverObjectInputStream.State restoreState = objectInputStream.start();
            boolean ok = false;
            try {
                if (typeId == 56) {
                    info.callReadObject(obj, (ObjectInputStream)((Object)objectInputStream));
                    blockUnmarshaller.readToEndBlockData();
                    blockUnmarshaller.unblock();
                } else if (this.version >= 1) {
                    blockUnmarshaller.endOfStream();
                    info.callReadObject(obj, (ObjectInputStream)((Object)objectInputStream));
                    blockUnmarshaller.readToEndBlockData();
                    blockUnmarshaller.unblock();
                } else {
                    info.callReadObject(obj, (ObjectInputStream)((Object)objectInputStream));
                }
                objectInputStream.finish(restoreState);
                objectInputStream.swapCurrent(oldObj);
                objectInputStream.swapClass(oldDescriptor);
                ok = true;
            }
            finally {
                if (!ok) {
                    objectInputStream.fullReset();
                }
            }
        } else {
            this.readFields(obj, descriptor);
            if (typeId == 56) {
                blockUnmarshaller.readToEndBlockData();
                blockUnmarshaller.unblock();
            }
        }
    }

    protected void readFields(Object obj, SerializableClassDescriptor descriptor) throws IOException, ClassNotFoundException {
        for (SerializableField serializableField : descriptor.getFields()) {
            Field field = serializableField.getField();
            if (field == null) {
                switch (serializableField.getKind()) {
                    case BOOLEAN: {
                        this.readBoolean();
                        break;
                    }
                    case BYTE: {
                        this.readByte();
                        break;
                    }
                    case CHAR: {
                        this.readChar();
                        break;
                    }
                    case DOUBLE: {
                        this.readDouble();
                        break;
                    }
                    case FLOAT: {
                        this.readFloat();
                        break;
                    }
                    case INT: {
                        this.readInt();
                        break;
                    }
                    case LONG: {
                        this.readLong();
                        break;
                    }
                    case OBJECT: {
                        if (serializableField.isUnshared()) {
                            this.readObjectUnshared();
                            break;
                        }
                        this.readObject();
                        break;
                    }
                    case SHORT: {
                        this.readShort();
                    }
                }
                continue;
            }
            try {
                switch (serializableField.getKind()) {
                    case BOOLEAN: {
                        field.setBoolean(obj, this.readBoolean());
                        break;
                    }
                    case BYTE: {
                        field.setByte(obj, this.readByte());
                        break;
                    }
                    case CHAR: {
                        field.setChar(obj, this.readChar());
                        break;
                    }
                    case DOUBLE: {
                        field.setDouble(obj, this.readDouble());
                        break;
                    }
                    case FLOAT: {
                        field.setFloat(obj, this.readFloat());
                        break;
                    }
                    case INT: {
                        field.setInt(obj, this.readInt());
                        break;
                    }
                    case LONG: {
                        field.setLong(obj, this.readLong());
                        break;
                    }
                    case OBJECT: {
                        Object robj = serializableField.isUnshared() ? this.readObjectUnshared() : this.readObject();
                        field.set(obj, robj);
                        break;
                    }
                    case SHORT: {
                        field.setShort(obj, this.readShort());
                    }
                }
            }
            catch (IllegalAccessException e) {
                InvalidObjectException ioe = new InvalidObjectException("Unable to set a field");
                ioe.initCause(e);
                throw ioe;
            }
        }
    }

    void addValidation(ObjectInputValidation validation, int prio) {
        Validator validator = new Validator(prio, this.validatorSeq++, validation);
        SortedSet<Validator> validators = this.validators;
        (validators == null ? (this.validators = new TreeSet<Validator>()) : validators).add(validator);
    }

    public String readUTF() throws IOException {
        int len = this.readInt();
        return UTFUtils.readUTFBytes((ByteInput)this, (int)len);
    }

    private static final class DummyInvocationHandler
    implements InvocationHandler {
        private DummyInvocationHandler() {
        }

        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            throw new NoSuchMethodError("Invocation handler not yet loaded");
        }
    }
}

