/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.marshalling.serialization.java;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.jboss.marshalling.Creator;
import org.jboss.marshalling.Externalizer;

public class JavaSerializationExternalizer {
    public static void externalize(ObjectOutput out, Externalizer externalizer, Object obj) throws IOException {
        out.writeObject(externalizer);
        out.writeUTF(obj.getClass().getName());
        externalizer.writeExternal(obj, out);
    }

    public static Object internalize(ObjectInput in, Creator creator) throws IOException, ClassNotFoundException {
        try {
            Externalizer externalizer = (Externalizer)in.readObject();
            if (externalizer == null) {
                throw new IOException("Cannot read Externalizer");
            }
            String objClassName = in.readUTF();
            if (objClassName == null) {
                throw new IOException("Cannot read object class name");
            }
            Class<?> objClass = Class.forName(objClassName);
            Object obj = null;
            if (creator != null) {
                obj = externalizer.createExternal(objClass, in, creator);
            } else {
                obj = objClass.newInstance();
                externalizer.readExternal(obj, in);
            }
            return obj;
        }
        catch (Exception e) {
            throw new IOException(e.getMessage());
        }
    }
}

