/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.marshalling.serialization.java;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import org.jboss.marshalling.ByteInput;
import org.jboss.marshalling.ClassResolver;
import org.jboss.marshalling.ClassTable;
import org.jboss.marshalling.Creator;
import org.jboss.marshalling.ObjectResolver;
import org.jboss.marshalling.ObjectTable;
import org.jboss.marshalling.StreamHeader;
import org.jboss.marshalling.Unmarshaller;
import org.jboss.marshalling.serialization.java.JavaSerializationConstants;
import org.jboss.marshalling.serialization.java.JavaSerializationUnmarshaller;
import org.jboss.marshalling.serialization.java.ObjectResolverWrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaSerializationInputStream
extends ObjectInputStream {
    private static boolean privateFieldsAndMethodsSet;
    private static Field binField;
    private static Field enableOverrideField;
    private static Field externalizableField;
    private static Field handlesField;
    private static Field serializableField;
    private static Field vlistField;
    private static Method clearMethod;
    private static Method getSuperDescMethod;
    private static Method verifySubclassMethod;
    private static Class<?> blockDataInputStreamClass;
    private static Constructor<?> blockDataInputStreamConstructor;
    private static Method setBlockDataModeMethod;
    private static Class<?> handleTableClass;
    private static Constructor<?> handleTableConstructor;
    private static Class<?> validationListClass;
    private static Constructor<?> validationListConstructor;
    private static Constructor<?> objectStreamClassConstructor;
    private JavaSerializationUnmarshaller unmarshaller;
    private StreamHeader streamHeader;
    private ClassResolver classResolver;
    private ClassTable classTable;
    private ObjectResolver objectResolver;
    private ObjectTable objectTable;
    private Creator creator;

    private static Field getAccessibleDeclaredField(final Class<?> clazz, final String name) {
        return AccessController.doPrivileged(new PrivilegedAction<Field>(){

            @Override
            public Field run() {
                try {
                    Field field = clazz.getDeclaredField(name);
                    field.setAccessible(true);
                    return field;
                }
                catch (NoSuchFieldException e) {
                    throw new NoSuchFieldError(e.getMessage());
                }
            }
        });
    }

    private static Method getAccessibleDeclaredMethod(final Class<?> clazz, final String name, final Class<?> ... paramTypes) {
        return AccessController.doPrivileged(new PrivilegedAction<Method>(){

            @Override
            public Method run() {
                try {
                    Method method = clazz.getDeclaredMethod(name, paramTypes);
                    method.setAccessible(true);
                    return method;
                }
                catch (NoSuchMethodException e) {
                    throw new NoSuchMethodError(e.getMessage());
                }
            }
        });
    }

    private static Constructor getAccessibleDeclaredConstructor(final Class<?> clazz, final Class<?> ... paramTypes) {
        return AccessController.doPrivileged(new PrivilegedAction<Constructor>(){

            @Override
            public Constructor run() {
                try {
                    Constructor constructor = clazz.getDeclaredConstructor(paramTypes);
                    constructor.setAccessible(true);
                    return constructor;
                }
                catch (NoSuchMethodException e) {
                    throw new NoSuchMethodError(e.getMessage());
                }
            }
        });
    }

    public JavaSerializationInputStream(JavaSerializationUnmarshaller unmarshaller, StreamHeader streamHeader, ClassResolver classResolver, ClassTable classTable, ObjectResolver objectResolver, ObjectTable objectTable, Creator creator) throws IOException {
        this.unmarshaller = unmarshaller;
        this.streamHeader = streamHeader;
        this.classResolver = classResolver;
        this.classTable = classTable;
        this.objectResolver = new ObjectResolverWrapper(objectResolver);
        this.objectTable = objectTable;
        this.creator = creator;
        try {
            this.setPrivateFieldsAndMethods();
            verifySubclassMethod.invoke((Object)this, JavaSerializationConstants.EMPTY_PARAMS);
            binField.set(this, blockDataInputStreamConstructor.newInstance(this, unmarshaller.getInputStream()));
            handlesField.set(this, handleTableConstructor.newInstance(10));
            vlistField.set(this, validationListConstructor.newInstance(JavaSerializationConstants.EMPTY_PARAMS));
            this.enableOverride(false);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IOException(e.getClass() + ": " + e.getMessage());
        }
    }

    public JavaSerializationInputStream(JavaSerializationUnmarshaller unmarshaller, ClassResolver classResolver, ClassTable classTable, ObjectResolver objectResolver, ObjectTable objectTable, Creator creator) throws IOException {
        super(unmarshaller.getInputStream());
        this.unmarshaller = unmarshaller;
        this.classResolver = classResolver;
        this.classTable = classTable;
        this.objectResolver = new ObjectResolverWrapper(objectResolver);
        this.objectTable = objectTable;
        this.creator = creator;
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                JavaSerializationInputStream.this.enableResolveObject(true);
                return null;
            }
        });
    }

    public void clear() {
        try {
            clearMethod.invoke((Object)this, JavaSerializationConstants.EMPTY_PARAMS);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public Creator getCreator() {
        return this.creator;
    }

    public ObjectTable getObjectTable() {
        return this.objectTable;
    }

    public Unmarshaller getUnmarshaller() {
        return this.unmarshaller;
    }

    protected void completeConstruction() throws IOException {
        try {
            this.readStreamHeader();
            setBlockDataModeMethod.invoke(binField.get(this), Boolean.TRUE);
            AccessController.doPrivileged(new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    JavaSerializationInputStream.this.enableResolveObject(true);
                    return null;
                }
            });
        }
        catch (Exception e) {
            throw new IOException(e.getMessage());
        }
    }

    @Override
    protected ObjectStreamClass readClassDescriptor() throws IOException, ClassNotFoundException {
        if (this.classTable != null && 1 == this.readByte()) {
            Class c = this.classTable.readClass((Unmarshaller)this.unmarshaller);
            if (c != null) {
                try {
                    return (ObjectStreamClass)objectStreamClassConstructor.newInstance(c);
                }
                catch (Exception e) {
                    throw new IOException(e.getClass() + ": " + e.getMessage());
                }
            }
            return super.readClassDescriptor();
        }
        return super.readClassDescriptor();
    }

    @Override
    protected void readStreamHeader() throws IOException {
        if (this.streamHeader != null) {
            this.streamHeader.readHeader((ByteInput)this.unmarshaller);
        } else {
            super.readStreamHeader();
        }
    }

    @Override
    protected Class<?> resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
        if (this.classResolver != null) {
            return this.classResolver.resolveClass((Unmarshaller)this.unmarshaller, desc.getName(), desc.getSerialVersionUID());
        }
        return super.resolveClass(desc);
    }

    @Override
    protected Class<?> resolveProxyClass(String[] interfaces) throws IOException, ClassNotFoundException {
        if (this.classResolver != null) {
            return this.classResolver.resolveProxyClass((Unmarshaller)this.unmarshaller, interfaces);
        }
        return super.resolveProxyClass(interfaces);
    }

    @Override
    protected Object resolveObject(Object obj) throws IOException {
        return this.objectResolver.readResolve(obj);
    }

    private void enableOverride(boolean enable) throws IOException {
        try {
            enableOverrideField.set(this, enable);
        }
        catch (Exception e) {
            throw new IOException(e.getClass() + ": " + e.getMessage());
        }
    }

    private synchronized void setPrivateFieldsAndMethods() {
        if (privateFieldsAndMethodsSet) {
            return;
        }
        try {
            binField = ObjectInputStream.class.getDeclaredField("bin");
            binField.setAccessible(true);
            enableOverrideField = ObjectInputStream.class.getDeclaredField("enableOverride");
            enableOverrideField.setAccessible(true);
            handlesField = ObjectInputStream.class.getDeclaredField("handles");
            handlesField.setAccessible(true);
            vlistField = ObjectInputStream.class.getDeclaredField("vlist");
            vlistField.setAccessible(true);
            verifySubclassMethod = ObjectInputStream.class.getDeclaredMethod("verifySubclass", new Class[0]);
            verifySubclassMethod.setAccessible(true);
            Class<?>[] classes = ObjectInputStream.class.getDeclaredClasses();
            for (int i = 0; i < classes.length; ++i) {
                if ("java.io.ObjectInputStream$BlockDataInputStream".equals(classes[i].getName())) {
                    blockDataInputStreamClass = classes[i];
                }
                if ("java.io.ObjectInputStream$HandleTable".equals(classes[i].getName())) {
                    handleTableClass = classes[i];
                }
                if (!"java.io.ObjectInputStream$ValidationList".equals(classes[i].getName())) continue;
                validationListClass = classes[i];
            }
            if (blockDataInputStreamClass == null) {
                throw new Exception("Unable to find BlockDataInputStream class");
            }
            if (handleTableClass == null) {
                throw new Exception("Unable to find HandleTable class");
            }
            if (validationListClass == null) {
                throw new Exception("Unable to find ValidationList class");
            }
            blockDataInputStreamConstructor = blockDataInputStreamClass.getDeclaredConstructor(ObjectInputStream.class, InputStream.class);
            blockDataInputStreamConstructor.setAccessible(true);
            setBlockDataModeMethod = blockDataInputStreamClass.getDeclaredMethod("setBlockDataMode", Boolean.TYPE);
            setBlockDataModeMethod.setAccessible(true);
            handleTableConstructor = handleTableClass.getDeclaredConstructor(Integer.TYPE);
            handleTableConstructor.setAccessible(true);
            validationListConstructor = validationListClass.getDeclaredConstructor(new Class[0]);
            validationListConstructor.setAccessible(true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static {
        externalizableField = JavaSerializationInputStream.getAccessibleDeclaredField(ObjectStreamClass.class, "externalizable");
        serializableField = JavaSerializationInputStream.getAccessibleDeclaredField(ObjectStreamClass.class, "serializable");
        clearMethod = JavaSerializationInputStream.getAccessibleDeclaredMethod(ObjectInputStream.class, "clear", new Class[0]);
        getSuperDescMethod = JavaSerializationInputStream.getAccessibleDeclaredMethod(ObjectStreamClass.class, "getSuperDesc", new Class[0]);
        objectStreamClassConstructor = JavaSerializationInputStream.getAccessibleDeclaredConstructor(ObjectStreamClass.class, Class.class);
    }
}

