/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.marshalling.serialization.java;

import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import org.jboss.marshalling.AbstractMarshaller;
import org.jboss.marshalling.AbstractMarshallerFactory;
import org.jboss.marshalling.ByteOutput;
import org.jboss.marshalling.MarshallingConfiguration;
import org.jboss.marshalling.serialization.java.ByteOutputStream;
import org.jboss.marshalling.serialization.java.JavaSerializationOutputStream;

public class JavaSerializationMarshaller
extends AbstractMarshaller {
    private ByteOutputStream bos;
    private JavaSerializationOutputStream jsos;

    protected JavaSerializationMarshaller(AbstractMarshallerFactory marshallerFactory, MarshallingConfiguration configuration) throws IOException {
        super(marshallerFactory, configuration);
    }

    public void clearClassCache() throws IOException {
        this.jsos.clear();
    }

    public void clearInstanceCache() throws IOException {
        this.jsos.clear();
    }

    public ByteOutputStream getOutputStream() {
        return this.bos;
    }

    public void flush() throws IOException {
        this.jsos.flush();
    }

    public void finish() throws IOException {
        this.jsos.close();
    }

    public void start(ByteOutput byteOutput) throws IOException {
        super.start(byteOutput);
        this.bos = new ByteOutputStream(byteOutput);
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws IOException {
                    if (JavaSerializationMarshaller.this.streamHeader == null) {
                        JavaSerializationMarshaller.this.jsos = new JavaSerializationOutputStream(JavaSerializationMarshaller.this, JavaSerializationMarshaller.this.classResolver, JavaSerializationMarshaller.this.classTable, JavaSerializationMarshaller.this.objectResolver, JavaSerializationMarshaller.this.objectTable, JavaSerializationMarshaller.this.classExternalizerFactory);
                    } else {
                        JavaSerializationMarshaller.this.jsos = new JavaSerializationOutputStream(JavaSerializationMarshaller.this, JavaSerializationMarshaller.this.streamHeader, JavaSerializationMarshaller.this.classResolver, JavaSerializationMarshaller.this.classTable, JavaSerializationMarshaller.this.objectResolver, JavaSerializationMarshaller.this.objectTable, JavaSerializationMarshaller.this.classExternalizerFactory);
                        JavaSerializationMarshaller.this.jsos.completeConstruction();
                    }
                    return null;
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (IOException)e.getCause();
        }
    }

    protected void doWriteObject(Object obj, boolean unshared) throws IOException {
        if (unshared) {
            this.jsos.writeUnshared(obj);
        } else {
            this.jsos.writeObject(obj);
        }
    }

    public void write(int b) throws IOException {
        this.jsos.write(b);
    }

    public void write(byte[] b) throws IOException {
        this.jsos.write(b);
    }

    public void write(byte[] b, int off, int len) throws IOException {
        this.jsos.write(b, off, len);
    }

    public void writeBoolean(boolean v) throws IOException {
        this.jsos.writeBoolean(v);
    }

    public void writeByte(int v) throws IOException {
        this.jsos.writeByte(v);
    }

    public void writeShort(int v) throws IOException {
        this.jsos.writeShort(v);
    }

    public void writeChar(int v) throws IOException {
        this.jsos.writeChar(v);
    }

    public void writeInt(int v) throws IOException {
        this.jsos.writeInt(v);
    }

    public void writeLong(long v) throws IOException {
        this.jsos.writeLong(v);
    }

    public void writeFloat(float v) throws IOException {
        this.jsos.writeFloat(v);
    }

    public void writeDouble(double v) throws IOException {
        this.jsos.writeDouble(v);
    }

    public void writeBytes(String s) throws IOException {
        this.jsos.writeBytes(s);
    }

    public void writeChars(String s) throws IOException {
        this.jsos.writeChars(s);
    }

    public void writeUTF(String s) throws IOException {
        this.jsos.writeUTF(s);
    }

    protected void doStart() throws IOException {
    }
}

