/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.marshalling.serialization.java;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.Map;
import org.jboss.marshalling.ByteOutput;
import org.jboss.marshalling.ClassExternalizerFactory;
import org.jboss.marshalling.ClassResolver;
import org.jboss.marshalling.ClassTable;
import org.jboss.marshalling.Externalizer;
import org.jboss.marshalling.Marshaller;
import org.jboss.marshalling.ObjectResolver;
import org.jboss.marshalling.ObjectTable;
import org.jboss.marshalling.StreamHeader;
import org.jboss.marshalling.serialization.java.ExternalizableWrapper;
import org.jboss.marshalling.serialization.java.JavaSerializationConstants;
import org.jboss.marshalling.serialization.java.JavaSerializationMarshaller;
import org.jboss.marshalling.serialization.java.ObjectTableWriterWrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaSerializationOutputStream
extends ObjectOutputStream {
    private static boolean privateFieldsAndMethodsSetForStreamHeader;
    private static boolean privateFieldsAndMethodsSetForWriteOverride;
    private static Field boutField;
    private static Field depthField;
    private static Field enableOverrideField;
    private static Field handlesField;
    private static Field subsField;
    private static Method clearMethod;
    private static Method verifySubclassMethod;
    private static Method writeFatalExceptionMethod;
    private static Method writeObject0Method;
    private static Class<?> blockDataOutputStreamClass;
    private static Constructor<?> blockDataOutputStreamConstructor;
    private static Method setBlockDataModeMethod;
    private static Class<?> handleTableClass;
    private static Constructor<?> handleTableConstructor;
    private static Class<?> replaceTableClass;
    private static Constructor<?> replaceTableConstructor;
    private Map<Object, ExternalizableWrapper> externalizedCache = new HashMap<Object, ExternalizableWrapper>();
    private Map<Object, ObjectTableWriterWrapper> objectTableWritableCache = new HashMap<Object, ObjectTableWriterWrapper>();
    private JavaSerializationMarshaller marshaller;
    private StreamHeader streamHeader;
    private ClassResolver classResolver;
    private ObjectResolver objectResolver;
    private ClassExternalizerFactory classExternalizerFactory;
    private ClassTable classTable;
    private ObjectTable objectTable;

    private static Field getAccessibleDeclaredField(final Class<?> clazz, final String name) {
        return AccessController.doPrivileged(new PrivilegedAction<Field>(){

            @Override
            public Field run() {
                try {
                    Field field = clazz.getDeclaredField(name);
                    field.setAccessible(true);
                    return field;
                }
                catch (NoSuchFieldException e) {
                    throw new NoSuchFieldError(e.getMessage());
                }
            }
        });
    }

    private static Method getAccessibleDeclaredMethod(final Class<?> clazz, final String name, final Class<?> ... paramTypes) {
        return AccessController.doPrivileged(new PrivilegedAction<Method>(){

            @Override
            public Method run() {
                try {
                    Method method = clazz.getDeclaredMethod(name, paramTypes);
                    method.setAccessible(true);
                    return method;
                }
                catch (NoSuchMethodException e) {
                    throw new NoSuchMethodError(e.getMessage());
                }
            }
        });
    }

    private static Constructor getAccessibleDeclaredConstructor(final Class<?> clazz, final Class<?> ... paramTypes) {
        return AccessController.doPrivileged(new PrivilegedAction<Constructor>(){

            @Override
            public Constructor run() {
                try {
                    Constructor constructor = clazz.getDeclaredConstructor(paramTypes);
                    constructor.setAccessible(true);
                    return constructor;
                }
                catch (NoSuchMethodException e) {
                    throw new NoSuchMethodError(e.getMessage());
                }
            }
        });
    }

    public JavaSerializationOutputStream(JavaSerializationMarshaller marshaller, StreamHeader streamHeader, ClassResolver classResolver, ClassTable classTable, ObjectResolver objectResolver, ObjectTable objectTable, ClassExternalizerFactory classExternalizerFactory) throws IOException {
        this.marshaller = marshaller;
        this.streamHeader = streamHeader;
        this.classResolver = classResolver;
        this.classTable = classTable;
        this.objectResolver = objectResolver;
        this.objectTable = objectTable;
        this.classExternalizerFactory = classExternalizerFactory;
        try {
            JavaSerializationOutputStream.setPrivateFieldsAndMethodsForStreamHeader();
            verifySubclassMethod.invoke((Object)this, JavaSerializationConstants.EMPTY_PARAMS);
            boutField.set(this, blockDataOutputStreamConstructor.newInstance(marshaller.getOutputStream()));
            handlesField.set(this, handleTableConstructor.newInstance(10, Float.valueOf(3.0f)));
            subsField.set(this, replaceTableConstructor.newInstance(10, Float.valueOf(3.0f)));
            if (objectTable == null && classExternalizerFactory == null) {
                JavaSerializationOutputStream.setPrivateFieldsAndMethodsForWriteOverride();
                this.enableOverride(false);
            }
        }
        catch (Exception e) {
            throw new IOException(e.getClass() + ": " + e.getMessage());
        }
    }

    public JavaSerializationOutputStream(JavaSerializationMarshaller marshaller, ClassResolver classResolver, ClassTable classTable, ObjectResolver objectResolver, ObjectTable objectTable, ClassExternalizerFactory classExternalizerFactory) throws IOException {
        super(marshaller.getOutputStream());
        this.marshaller = marshaller;
        this.classResolver = classResolver;
        this.classTable = classTable;
        this.objectResolver = objectResolver;
        this.objectTable = objectTable;
        this.classExternalizerFactory = classExternalizerFactory;
        if (objectTable != null || classExternalizerFactory != null) {
            try {
                JavaSerializationOutputStream.setPrivateFieldsAndMethodsForWriteOverride();
                this.enableOverride(true);
            }
            catch (Exception e) {
                throw new IOException(e.getClass() + ": " + e.getMessage());
            }
        }
        if (objectResolver != null) {
            this.enableReplaceObject(true);
        }
    }

    public void clear() throws IOException {
        this.reset();
        this.objectTableWritableCache.clear();
        this.externalizedCache.clear();
    }

    @Override
    public void writeStreamHeader() throws IOException {
        if (this.streamHeader != null) {
            this.streamHeader.writeHeader((ByteOutput)this.marshaller);
        } else {
            super.writeStreamHeader();
        }
    }

    @Override
    protected void annotateClass(Class<?> cl) throws IOException {
        if (this.classResolver != null) {
            this.classResolver.annotateClass((Marshaller)this.marshaller, cl);
        }
    }

    @Override
    protected void annotateProxyClass(Class<?> cl) throws IOException {
        if (this.classResolver != null) {
            this.classResolver.annotateProxyClass((Marshaller)this.marshaller, cl);
        }
    }

    protected void completeConstruction() throws IOException {
        try {
            this.writeStreamHeader();
            setBlockDataModeMethod.invoke(boutField.get(this), Boolean.TRUE);
            if (this.objectResolver != null) {
                this.enableReplaceObject(true);
            }
        }
        catch (Exception e) {
            IOException ioe = new IOException(e.getMessage());
            ioe.initCause(e);
            throw ioe;
        }
    }

    @Override
    protected Object replaceObject(Object obj) throws IOException {
        if (this.objectResolver != null) {
            Object replacement = this.objectResolver.writeReplace(obj);
            return replacement;
        }
        throw new RuntimeException("objectResolver should not be null");
    }

    @Override
    protected void writeClassDescriptor(ObjectStreamClass desc) throws IOException {
        if (this.classTable != null) {
            ClassTable.Writer writer = this.classTable.getClassWriter(desc.forClass());
            if (writer == null) {
                this.writeByte(2);
                super.writeClassDescriptor(desc);
            } else {
                this.writeByte(1);
                writer.writeClass((Marshaller)this.marshaller, desc.forClass());
            }
        } else {
            super.writeClassDescriptor(desc);
        }
    }

    @Override
    protected void writeObjectOverride(Object obj) throws IOException {
        Externalizable wrapper;
        ObjectTable.Writer writer;
        if (this.objectTable != null && (writer = this.objectTable.getObjectWriter(obj)) != null) {
            wrapper = this.objectTableWritableCache.get(obj);
            if (wrapper == null) {
                wrapper = new ObjectTableWriterWrapper(writer, (Marshaller)this.marshaller, obj);
                this.objectTableWritableCache.put(obj, (ObjectTableWriterWrapper)wrapper);
            }
            obj = wrapper;
        }
        Externalizer externalizer = null;
        if (this.classExternalizerFactory != null) {
            externalizer = this.classExternalizerFactory.getExternalizer(obj.getClass());
        }
        if (externalizer != null) {
            wrapper = this.externalizedCache.get(obj);
            if (wrapper == null) {
                wrapper = new ExternalizableWrapper(externalizer, obj);
                this.externalizedCache.put(obj, (ExternalizableWrapper)wrapper);
            }
            obj = wrapper;
        }
        try {
            writeObject0Method.invoke((Object)this, obj, false);
        }
        catch (InvocationTargetException ex) {
            try {
                if ((Integer)depthField.get(this) == 0) {
                    writeFatalExceptionMethod.invoke((Object)this, ex);
                }
            }
            catch (Exception e) {
                throw new IOException(e.getCause() + ": " + e.getMessage());
            }
        }
        catch (Exception e) {
            throw new IOException(e.getCause() + ": " + e.getMessage());
        }
    }

    private void enableOverride(boolean enable) throws IOException {
        try {
            enableOverrideField.set(this, enable);
        }
        catch (Exception e) {
            IOException ioe = new IOException(e.getMessage());
            ioe.initCause(e);
            throw ioe;
        }
    }

    private static synchronized void setPrivateFieldsAndMethodsForStreamHeader() {
        if (privateFieldsAndMethodsSetForStreamHeader) {
            return;
        }
        try {
            Class<?>[] classes;
            boutField = JavaSerializationOutputStream.getAccessibleDeclaredField(ObjectOutputStream.class, "bout");
            handlesField = JavaSerializationOutputStream.getAccessibleDeclaredField(ObjectOutputStream.class, "handles");
            subsField = JavaSerializationOutputStream.getAccessibleDeclaredField(ObjectOutputStream.class, "subs");
            verifySubclassMethod = JavaSerializationOutputStream.getAccessibleDeclaredMethod(ObjectOutputStream.class, "verifySubclass", new Class[0]);
            for (Class<?> clazz : classes = ObjectOutputStream.class.getDeclaredClasses()) {
                if ("java.io.ObjectOutputStream$BlockDataOutputStream".equals(clazz.getName())) {
                    blockDataOutputStreamClass = clazz;
                }
                if ("java.io.ObjectOutputStream$HandleTable".equals(clazz.getName())) {
                    handleTableClass = clazz;
                }
                if (!"java.io.ObjectOutputStream$ReplaceTable".equals(clazz.getName())) continue;
                replaceTableClass = clazz;
            }
            if (blockDataOutputStreamClass == null) {
                throw new Exception("Unable to find BlockDataOutputStream class");
            }
            if (handleTableClass == null) {
                throw new Exception("Unable to find HandleTable class");
            }
            if (replaceTableClass == null) {
                throw new Exception("Unable to find ReplaceTable class");
            }
            blockDataOutputStreamConstructor = JavaSerializationOutputStream.getAccessibleDeclaredConstructor(blockDataOutputStreamClass, OutputStream.class);
            setBlockDataModeMethod = JavaSerializationOutputStream.getAccessibleDeclaredMethod(blockDataOutputStreamClass, "setBlockDataMode", Boolean.TYPE);
            handleTableConstructor = JavaSerializationOutputStream.getAccessibleDeclaredConstructor(handleTableClass, Integer.TYPE, Float.TYPE);
            replaceTableConstructor = JavaSerializationOutputStream.getAccessibleDeclaredConstructor(replaceTableClass, Integer.TYPE, Float.TYPE);
            privateFieldsAndMethodsSetForStreamHeader = true;
        }
        catch (Exception e) {
            throw new RuntimeException("unable to obtain private field or method from superclass", e);
        }
    }

    private static synchronized void setPrivateFieldsAndMethodsForWriteOverride() {
        if (privateFieldsAndMethodsSetForWriteOverride) {
            return;
        }
        try {
            depthField = JavaSerializationOutputStream.getAccessibleDeclaredField(ObjectOutputStream.class, "depth");
            enableOverrideField = JavaSerializationOutputStream.getAccessibleDeclaredField(ObjectOutputStream.class, "enableOverride");
            clearMethod = JavaSerializationOutputStream.getAccessibleDeclaredMethod(ObjectOutputStream.class, "clear", new Class[0]);
            writeFatalExceptionMethod = JavaSerializationOutputStream.getAccessibleDeclaredMethod(ObjectOutputStream.class, "writeFatalException", IOException.class);
            writeObject0Method = JavaSerializationOutputStream.getAccessibleDeclaredMethod(ObjectOutputStream.class, "writeObject0", Object.class, Boolean.TYPE);
            privateFieldsAndMethodsSetForWriteOverride = true;
        }
        catch (Exception e) {
            throw new RuntimeException("unable to obtain private field or method from superclass", e);
        }
    }
}

