/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.marshalling.serialization.java;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.jboss.marshalling.Marshaller;
import org.jboss.marshalling.ObjectTable;
import org.jboss.marshalling.Unmarshaller;
import org.jboss.marshalling.serialization.java.JavaSerializationInputStream;

public class ObjectTableWriterWrapper
implements Externalizable {
    private static final long serialVersionUID = 3008264734827845637L;
    private ObjectTable.Writer writer;
    private Marshaller marshaller;
    private Object obj;

    public ObjectTableWriterWrapper(ObjectTable.Writer writer, Marshaller marshaller, Object obj) {
        this.writer = writer;
        if (this.writer == null) {
            throw new RuntimeException("Externalizer must not be null");
        }
        this.marshaller = marshaller;
        this.obj = obj;
    }

    public ObjectTableWriterWrapper() {
    }

    public Object getWrappedObject() {
        return this.obj;
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        try {
            ObjectTable objectTable = null;
            Unmarshaller unmarshaller = null;
            if (!(in instanceof JavaSerializationInputStream)) {
                throw new RuntimeException("expecting JavaSerializationInputStream");
            }
            JavaSerializationInputStream jsis = (JavaSerializationInputStream)in;
            objectTable = jsis.getObjectTable();
            unmarshaller = jsis.getUnmarshaller();
            if (objectTable == null) {
                throw new IOException("ObjectTable must not be null");
            }
            this.obj = objectTable.readObject(unmarshaller);
        }
        catch (Exception e) {
            throw new IOException(e.getMessage());
        }
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        this.writer.writeObject(this.marshaller, this.obj);
        this.writer = null;
        this.marshaller = null;
        this.obj = null;
    }
}

