/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.marshalling.serialization.java;

import java.io.IOException;
import java.io.InputStream;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import org.jboss.marshalling.AbstractMarshallerFactory;
import org.jboss.marshalling.AbstractUnmarshaller;
import org.jboss.marshalling.ByteInput;
import org.jboss.marshalling.MarshallingConfiguration;
import org.jboss.marshalling.serialization.java.ByteInputStream;
import org.jboss.marshalling.serialization.java.JavaSerializationInputStream;

public class JavaSerializationUnmarshaller
extends AbstractUnmarshaller {
    private ByteInputStream bis;
    private JavaSerializationInputStream jsis;

    protected JavaSerializationUnmarshaller(AbstractMarshallerFactory marshallerFactory, MarshallingConfiguration configuration) throws IOException {
        super(marshallerFactory, configuration);
    }

    public InputStream getInputStream() {
        return this.bis;
    }

    public void clearClassCache() throws IOException {
        this.jsis.clear();
    }

    public void clearInstanceCache() throws IOException {
        this.jsis.clear();
    }

    public void close() throws IOException {
        this.jsis.close();
        super.finish();
    }

    public void finish() throws IOException {
        this.jsis.close();
    }

    public void start(ByteInput byteInput) throws IOException {
        super.start(byteInput);
        this.bis = new ByteInputStream(byteInput);
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws IOException {
                    if (JavaSerializationUnmarshaller.this.streamHeader == null) {
                        JavaSerializationUnmarshaller.this.jsis = new JavaSerializationInputStream(JavaSerializationUnmarshaller.this, JavaSerializationUnmarshaller.this.classResolver, JavaSerializationUnmarshaller.this.classTable, JavaSerializationUnmarshaller.this.objectResolver, JavaSerializationUnmarshaller.this.objectTable, JavaSerializationUnmarshaller.this.creator);
                    } else {
                        JavaSerializationUnmarshaller.this.jsis = new JavaSerializationInputStream(JavaSerializationUnmarshaller.this, JavaSerializationUnmarshaller.this.streamHeader, JavaSerializationUnmarshaller.this.classResolver, JavaSerializationUnmarshaller.this.classTable, JavaSerializationUnmarshaller.this.objectResolver, JavaSerializationUnmarshaller.this.objectTable, JavaSerializationUnmarshaller.this.creator);
                        JavaSerializationUnmarshaller.this.jsis.completeConstruction();
                    }
                    return null;
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (IOException)e.getCause();
        }
    }

    public int read() throws IOException {
        return this.jsis.read();
    }

    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    public int read(byte[] b, int off, int len) throws IOException {
        return this.jsis.read(b, off, len);
    }

    public long skip(long n) throws IOException {
        return this.jsis.skip(n);
    }

    public int available() throws IOException {
        return this.jsis.available();
    }

    public void readFully(byte[] b) throws IOException {
        this.jsis.readFully(b);
    }

    public void readFully(byte[] b, int off, int len) throws IOException {
        this.jsis.readFully(b, off, len);
    }

    public int skipBytes(int n) throws IOException {
        return this.jsis.skipBytes(n);
    }

    public boolean readBoolean() throws IOException {
        return this.jsis.readBoolean();
    }

    public byte readByte() throws IOException {
        return this.jsis.readByte();
    }

    public int readUnsignedByte() throws IOException {
        return this.jsis.readUnsignedByte();
    }

    public short readShort() throws IOException {
        return this.jsis.readShort();
    }

    public int readUnsignedShort() throws IOException {
        return this.jsis.readUnsignedShort();
    }

    public char readChar() throws IOException {
        return this.jsis.readChar();
    }

    public int readInt() throws IOException {
        return this.jsis.readInt();
    }

    public long readLong() throws IOException {
        return this.jsis.readLong();
    }

    public float readFloat() throws IOException {
        return this.jsis.readFloat();
    }

    public double readDouble() throws IOException {
        return this.jsis.readDouble();
    }

    @Deprecated
    public String readLine() throws IOException {
        return this.jsis.readLine();
    }

    public String readUTF() throws IOException {
        return this.jsis.readUTF();
    }

    protected Object doReadObject(boolean unshared) throws ClassNotFoundException, IOException {
        if (unshared) {
            return this.jsis.readUnshared();
        }
        return this.jsis.readObject();
    }

    protected void doStart() throws IOException {
    }
}

