/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.marshalling.serialization.java;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.jboss.marshalling.Creator;
import org.jboss.marshalling.Externalizer;
import org.jboss.marshalling.serialization.java.JavaSerializationInputStream;

public class ExternalizableWrapper
implements Externalizable {
    private static final long serialVersionUID = -8877220049146293957L;
    private Externalizer externalizer;
    private Object obj;

    public ExternalizableWrapper(Externalizer externalizer, Object obj) {
        this.externalizer = externalizer;
        if (this.externalizer == null) {
            throw new RuntimeException("Externalizer must not be null");
        }
        this.obj = obj;
    }

    public ExternalizableWrapper() {
    }

    public Object getWrappedObject() {
        return this.obj;
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        try {
            this.externalizer = (Externalizer)in.readObject();
            String objClassName = in.readUTF();
            if (objClassName == null) {
                throw new IOException("Cannot read object class name");
            }
            Class<?> objClass = Class.forName(objClassName);
            if (!(in instanceof JavaSerializationInputStream)) {
                throw new RuntimeException("expecting JavaSerializationInputStream");
            }
            Creator creator = ((JavaSerializationInputStream)in).getCreator();
            this.obj = creator != null ? this.externalizer.createExternal(objClass, in, creator) : objClass.newInstance();
            this.externalizer.readExternal(this.obj, in);
            this.externalizer = null;
        }
        catch (Exception e) {
            throw new IOException(e.getMessage());
        }
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.externalizer);
        out.writeUTF(this.obj.getClass().getName());
        this.externalizer.writeExternal(this.obj, out);
    }
}

