/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.marshalling.serialization.jboss;

import java.io.IOException;
import java.io.OutputStream;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import org.jboss.marshalling.AbstractMarshaller;
import org.jboss.marshalling.AbstractMarshallerFactory;
import org.jboss.marshalling.ByteOutput;
import org.jboss.marshalling.Marshalling;
import org.jboss.marshalling.MarshallingConfiguration;
import org.jboss.marshalling.serialization.jboss.JBossSerializationOutputStream;
import org.jboss.serial.util.StringUtilBuffer;

public class JBossSerializationMarshaller
extends AbstractMarshaller {
    private OutputStream bos;
    private JBossSerializationOutputStream jbsos;
    private boolean nativeImmutableHandling = true;
    private boolean jbossSerializationCompatible = false;

    protected JBossSerializationMarshaller(AbstractMarshallerFactory marshallerFactory, MarshallingConfiguration configuration) throws IOException {
        super(marshallerFactory, configuration);
    }

    public void clearClassCache() throws IOException {
        this.jbsos.clear();
    }

    public void clearInstanceCache() throws IOException {
        this.jbsos.clear();
    }

    public OutputStream getOutputStream() {
        return this.bos;
    }

    public void flush() throws IOException {
        this.jbsos.flush();
    }

    public void finish() throws IOException {
        this.jbsos.close();
    }

    public void start(ByteOutput byteOutput) throws IOException {
        super.start(byteOutput);
        this.bos = Marshalling.createOutputStream((ByteOutput)byteOutput);
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws IOException {
                    JBossSerializationMarshaller.this.jbsos = new JBossSerializationOutputStream(false, new StringUtilBuffer(10024, 10024), JBossSerializationMarshaller.this, JBossSerializationMarshaller.this.streamHeader, JBossSerializationMarshaller.this.classResolver, JBossSerializationMarshaller.this.classTable, JBossSerializationMarshaller.this.objectResolver, JBossSerializationMarshaller.this.objectTable, JBossSerializationMarshaller.this.classExternalizerFactory, JBossSerializationMarshaller.this.nativeImmutableHandling, JBossSerializationMarshaller.this.jbossSerializationCompatible);
                    JBossSerializationMarshaller.this.jbsos.completeConstruction();
                    return null;
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (IOException)e.getCause();
        }
    }

    public boolean isJbossSerializationCompatible() {
        return this.jbossSerializationCompatible;
    }

    public void setJbossSerializationCompatible(boolean jbossSerializationCompatible) {
        this.jbossSerializationCompatible = jbossSerializationCompatible;
    }

    public boolean isNativeImmutableHandling() {
        return this.nativeImmutableHandling;
    }

    public void setNativeImmutableHandling(boolean nativeImmutableHandling) {
        this.nativeImmutableHandling = nativeImmutableHandling;
    }

    protected void doWriteObject(Object obj, boolean unshared) throws IOException {
        if (unshared) {
            this.jbsos.writeUnshared(obj);
        } else {
            this.jbsos.writeObject(obj);
        }
    }

    public void write(int b) throws IOException {
        this.jbsos.write(b);
    }

    public void write(byte[] b) throws IOException {
        this.jbsos.write(b);
    }

    public void write(byte[] b, int off, int len) throws IOException {
        this.jbsos.write(b, off, len);
    }

    public void writeBoolean(boolean v) throws IOException {
        this.jbsos.writeBoolean(v);
    }

    public void writeByte(int v) throws IOException {
        this.jbsos.writeByte(v);
    }

    public void writeShort(int v) throws IOException {
        this.jbsos.writeShort(v);
    }

    public void writeChar(int v) throws IOException {
        this.jbsos.writeChar(v);
    }

    public void writeInt(int v) throws IOException {
        this.jbsos.writeInt(v);
    }

    public void writeLong(long v) throws IOException {
        this.jbsos.writeLong(v);
    }

    public void writeFloat(float v) throws IOException {
        this.jbsos.writeFloat(v);
    }

    public void writeDouble(double v) throws IOException {
        this.jbsos.writeDouble(v);
    }

    public void writeBytes(String s) throws IOException {
        this.jbsos.writeBytes(s);
    }

    public void writeChars(String s) throws IOException {
        this.jbsos.writeChars(s);
    }

    public void writeUTF(String s) throws IOException {
        this.jbsos.writeUTF(s);
    }

    protected void doStart() throws IOException {
    }
}

