/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.marshalling.serialization.jboss;

import java.io.IOException;
import java.io.InvalidClassException;
import java.io.ObjectOutput;
import java.lang.reflect.Proxy;
import java.security.AccessController;
import java.security.PrivilegedAction;
import org.jboss.marshalling.ByteOutput;
import org.jboss.marshalling.ClassExternalizerFactory;
import org.jboss.marshalling.ClassResolver;
import org.jboss.marshalling.ClassTable;
import org.jboss.marshalling.Externalize;
import org.jboss.marshalling.Externalizer;
import org.jboss.marshalling.Marshaller;
import org.jboss.marshalling.ObjectResolver;
import org.jboss.marshalling.ObjectTable;
import org.jboss.marshalling.StreamHeader;
import org.jboss.marshalling.serialization.jboss.JBossSerializationMarshaller;
import org.jboss.serial.classmetamodel.ClassDescriptorStrategy;
import org.jboss.serial.classmetamodel.ClassMetaData;
import org.jboss.serial.classmetamodel.DefaultClassDescriptorStrategy;
import org.jboss.serial.io.JBossObjectOutputStreamSharedTree;
import org.jboss.serial.objectmetamodel.DefaultObjectDescriptorStrategy;
import org.jboss.serial.objectmetamodel.ObjectDescriptorStrategy;
import org.jboss.serial.objectmetamodel.ObjectsCache;
import org.jboss.serial.util.StringUtilBuffer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JBossSerializationOutputStream
extends JBossObjectOutputStreamSharedTree {
    private static final boolean DONT_WRITE_CLASS_NAME = false;
    private static final boolean WRITE_CLASS_NAME = true;
    private JBossSerializationMarshaller marshaller;
    private StreamHeader streamHeader;
    private ClassResolver classResolver;
    private ObjectResolver objectResolver;
    private ClassExternalizerFactory classExternalizerFactory;
    private ClassTable classTable;
    private ObjectTable objectTable;
    private boolean nativeImmutableHandling = true;
    private boolean readyForStreamHeader;

    public JBossSerializationOutputStream(boolean checkSerializableClass, StringUtilBuffer buffer, JBossSerializationMarshaller marshaller, StreamHeader streamHeader, ClassResolver classResolver, ClassTable classTable, ObjectResolver objectResolver, ObjectTable objectTable, ClassExternalizerFactory classExternalizerFactory, boolean nativeImmutableHandling, boolean jbossSerializationCompatible) throws IOException {
        super(marshaller.getOutputStream(), checkSerializableClass, buffer);
        this.marshaller = marshaller;
        this.streamHeader = streamHeader;
        this.classResolver = classResolver;
        this.classTable = classTable;
        this.objectResolver = objectResolver;
        this.objectTable = objectTable;
        this.classExternalizerFactory = classExternalizerFactory;
        this.nativeImmutableHandling = nativeImmutableHandling;
        if (jbossSerializationCompatible) {
            this.setClassDescriptorStrategy((ClassDescriptorStrategy)new DefaultClassDescriptorStrategy());
            this.setObjectDescriptorStrategy((ObjectDescriptorStrategy)new DefaultObjectDescriptorStrategy());
            this.setStandardReplacement(false);
        } else {
            this.setClassDescriptorStrategy((ClassDescriptorStrategy)new JBMClassDescriptorStrategy(marshaller, this));
            this.setObjectDescriptorStrategy((ObjectDescriptorStrategy)new JBMObjectDescriptorStrategy(marshaller, this));
            this.setStandardReplacement(true);
        }
        if (objectResolver != null) {
            AccessController.doPrivileged(new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    JBossSerializationOutputStream.this.enableReplaceObject(true);
                    return null;
                }
            });
        }
        this.readyForStreamHeader = true;
    }

    protected void annotateClass(Class<?> cl) throws IOException {
        if (this.classResolver != null) {
            this.classResolver.annotateClass((Marshaller)this.marshaller, cl);
        }
    }

    protected void annotateProxyClass(Class<?> cl) throws IOException {
        if (this.classResolver != null) {
            this.classResolver.annotateProxyClass((Marshaller)this.marshaller, cl);
        }
    }

    public void clear() throws IOException {
        this.reset();
    }

    protected void completeConstruction() throws IOException {
        this.writeStreamHeader();
    }

    public boolean isNativeImmutableHandling() {
        return this.nativeImmutableHandling;
    }

    protected Object replaceObject(Object obj) throws IOException {
        if (this.objectResolver != null) {
            return this.objectResolver.writeReplace(obj);
        }
        return super.replaceObject(obj);
    }

    public void setNativeImmutableHandling(boolean nativeImmutableHandling) {
        this.nativeImmutableHandling = nativeImmutableHandling;
    }

    public void writeStreamHeader() throws IOException {
        if (this.readyForStreamHeader) {
            if (this.streamHeader != null) {
                this.streamHeader.writeHeader((ByteOutput)this.marshaller);
            } else {
                super.writeStreamHeader();
            }
        }
    }

    public void writeUnshared(Object obj) throws IOException {
        throw new UnsupportedOperationException();
    }

    static class JBMObjectDescriptorStrategy
    extends DefaultObjectDescriptorStrategy {
        private JBossSerializationMarshaller marshaller;
        private ClassResolver classResolver;
        private ObjectTable objectTable;
        private ClassExternalizerFactory classExternalizerFactory;
        private boolean nativeImmutableHandling;

        public JBMObjectDescriptorStrategy(JBossSerializationMarshaller marshaller, JBossSerializationOutputStream output) {
            this.marshaller = marshaller;
            this.classResolver = output.classResolver;
            this.objectTable = output.objectTable;
            this.classExternalizerFactory = output.classExternalizerFactory;
            this.nativeImmutableHandling = output.nativeImmutableHandling;
        }

        public boolean doneReplacing(ObjectsCache cache, Object newObject, Object oldObject, ClassMetaData oldMetaData) throws IOException {
            return true;
        }

        public void writeObject(ObjectsCache.JBossSeralizationOutputInterface output, ObjectsCache cache, ClassMetaData metadata, Object obj) throws IOException {
            if (this.classResolver != null && Proxy.isProxyClass(obj.getClass())) {
                output.write(112);
                output.writeObject((Object)Proxy.getInvocationHandler(obj));
                return;
            }
            Externalizer externalizer = null;
            Externalize annotation = null;
            if (this.classExternalizerFactory != null) {
                externalizer = this.classExternalizerFactory.getExternalizer(obj.getClass());
            }
            if (externalizer == null && obj != null) {
                annotation = obj.getClass().getAnnotation(Externalize.class);
            }
            if (externalizer == null && annotation != null) {
                Class clazz = annotation.value();
                try {
                    externalizer = (Externalizer)clazz.newInstance();
                }
                catch (InstantiationException e) {
                    InvalidClassException ice = new InvalidClassException(obj.getClass().getName(), "Error instantiating externalizer \"" + clazz.getName() + "\"");
                    ice.initCause(e);
                    throw ice;
                }
                catch (IllegalAccessException e) {
                    InvalidClassException ice = new InvalidClassException(obj.getClass().getName(), "Illegal access instantiating externalizer \"" + clazz.getName() + "\"");
                    ice.initCause(e);
                    throw ice;
                }
            }
            if (externalizer != null) {
                output.write(116);
                this.marshaller.writeObject(externalizer);
                externalizer.writeExternal(obj, (ObjectOutput)output);
                return;
            }
            output.write(111);
            super.writeObject(output, cache, metadata, obj);
        }

        public boolean writeObjectSpecialCase(ObjectsCache.JBossSeralizationOutputInterface output, ObjectsCache cache, Object obj) throws IOException {
            ObjectTable.Writer writer;
            if (this.objectTable != null && (writer = this.objectTable.getObjectWriter(obj)) != null) {
                output.write(110);
                writer.writeObject((Marshaller)this.marshaller, obj);
                return true;
            }
            if (this.nativeImmutableHandling) {
                return super.writeObjectSpecialCase(output, cache, obj);
            }
            return false;
        }
    }

    static class JBMClassDescriptorStrategy
    extends DefaultClassDescriptorStrategy {
        private JBossSerializationMarshaller marshaller;
        private JBossSerializationOutputStream output;
        private ClassTable classTable;
        private ClassResolver classResolver;
        private ObjectTable objectTable;

        public JBMClassDescriptorStrategy(JBossSerializationMarshaller marshaller, JBossSerializationOutputStream output) {
            this.marshaller = marshaller;
            this.output = output;
            this.classTable = output.classTable;
            this.classResolver = output.classResolver;
            this.objectTable = output.objectTable;
        }

        public void writeClassDescription(Object obj, ClassMetaData metaData, ObjectsCache cache, int description) throws IOException {
            if (this.objectTable != null && this.objectTable.getObjectWriter(obj) != null) {
                this.output.write(113);
                return;
            }
            Class<?> clazz = obj.getClass();
            ClassTable.Writer writer = null;
            if (this.classTable != null && (writer = this.classTable.getClassWriter(clazz)) != null) {
                this.output.write(117);
                writer.writeClass((Marshaller)this.marshaller, clazz);
            } else if (this.classResolver != null) {
                if (metaData.isProxy()) {
                    this.output.write(115);
                    String[] names = this.classResolver.getProxyInterfaces(clazz);
                    this.output.writeInt(names.length);
                    for (String name : names) {
                        this.output.writeUTF(name);
                    }
                    this.classResolver.annotateProxyClass((Marshaller)this.marshaller, clazz);
                } else {
                    this.output.write(114);
                    String className = metaData.getClassName();
                    String replacementClassName = this.classResolver.getClassName(clazz);
                    if (className.equals(replacementClassName)) {
                        this.output.writeUTF(className);
                        this.classResolver.annotateClass((Marshaller)this.marshaller, clazz);
                        super.writeClassDescription(null, metaData, cache, description, false);
                    } else {
                        this.output.writeUTF(replacementClassName);
                        this.classResolver.annotateClass((Marshaller)this.marshaller, clazz);
                        try {
                            ClassMetaData replacementMetaData = new ClassMetaData(Class.forName(replacementClassName));
                            super.writeClassDescription(null, replacementMetaData, cache, description, false);
                        }
                        catch (ClassNotFoundException e) {
                            throw new IOException(e.getMessage());
                        }
                    }
                }
            } else {
                this.output.write(114);
                super.writeClassDescription(clazz, metaData, cache, description, true);
            }
        }
    }
}

