/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.marshalling.serialization.jboss;

import java.io.IOException;
import java.io.InputStream;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import org.jboss.marshalling.AbstractMarshallerFactory;
import org.jboss.marshalling.AbstractUnmarshaller;
import org.jboss.marshalling.ByteInput;
import org.jboss.marshalling.Marshalling;
import org.jboss.marshalling.MarshallingConfiguration;
import org.jboss.marshalling.serialization.jboss.JBossSerializationInputStream;

public class JBossSerializationUnmarshaller
extends AbstractUnmarshaller {
    private InputStream bis;
    private JBossSerializationInputStream jbsis;
    private boolean jbossSerializationCompatible = false;

    public boolean isJbossSerializationCompatible() {
        return this.jbossSerializationCompatible;
    }

    public void setJbossSerializationCompatible(boolean jbossSerializationCompatible) {
        this.jbossSerializationCompatible = jbossSerializationCompatible;
    }

    protected JBossSerializationUnmarshaller(AbstractMarshallerFactory marshallerFactory, MarshallingConfiguration configuration) throws IOException {
        super(marshallerFactory, configuration);
    }

    public InputStream getInputStream() {
        return this.bis;
    }

    public void clearClassCache() throws IOException {
        this.jbsis.clear();
    }

    public void clearInstanceCache() throws IOException {
        this.jbsis.clear();
    }

    public void close() throws IOException {
        this.jbsis.close();
        super.finish();
    }

    public void finish() throws IOException {
        this.jbsis.close();
    }

    public void start(ByteInput byteInput) throws IOException {
        super.start(byteInput);
        this.bis = Marshalling.createInputStream((ByteInput)byteInput);
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws IOException {
                    JBossSerializationUnmarshaller.this.jbsis = new JBossSerializationInputStream(JBossSerializationUnmarshaller.this, JBossSerializationUnmarshaller.this.streamHeader, JBossSerializationUnmarshaller.this.classResolver, JBossSerializationUnmarshaller.this.classTable, JBossSerializationUnmarshaller.this.objectResolver, JBossSerializationUnmarshaller.this.objectTable, JBossSerializationUnmarshaller.this.creator, JBossSerializationUnmarshaller.this.jbossSerializationCompatible);
                    JBossSerializationUnmarshaller.this.jbsis.completeConstruction();
                    return null;
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (IOException)e.getCause();
        }
    }

    public int read() throws IOException {
        return this.jbsis.read();
    }

    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    public int read(byte[] b, int off, int len) throws IOException {
        return this.jbsis.read(b, off, len);
    }

    public long skip(long n) throws IOException {
        return this.jbsis.skip(n);
    }

    public int available() throws IOException {
        return this.jbsis.available();
    }

    public void readFully(byte[] b) throws IOException {
        this.jbsis.readFully(b);
    }

    public void readFully(byte[] b, int off, int len) throws IOException {
        this.jbsis.readFully(b, off, len);
    }

    public int skipBytes(int n) throws IOException {
        return this.jbsis.skipBytes(n);
    }

    public boolean readBoolean() throws IOException {
        return this.jbsis.readBoolean();
    }

    public byte readByte() throws IOException {
        return this.jbsis.readByte();
    }

    public int readUnsignedByte() throws IOException {
        return this.jbsis.readUnsignedByte();
    }

    public short readShort() throws IOException {
        return this.jbsis.readShort();
    }

    public int readUnsignedShort() throws IOException {
        return this.jbsis.readUnsignedShort();
    }

    public char readChar() throws IOException {
        return this.jbsis.readChar();
    }

    public int readInt() throws IOException {
        return this.jbsis.readInt();
    }

    public long readLong() throws IOException {
        return this.jbsis.readLong();
    }

    public float readFloat() throws IOException {
        return this.jbsis.readFloat();
    }

    public double readDouble() throws IOException {
        return this.jbsis.readDouble();
    }

    @Deprecated
    public String readLine() throws IOException {
        return this.jbsis.readLine();
    }

    public String readUTF() throws IOException {
        return this.jbsis.readUTF();
    }

    protected Object doReadObject(boolean unshared) throws ClassNotFoundException, IOException {
        if (unshared) {
            return this.jbsis.readUnshared();
        }
        return this.jbsis.readObject();
    }

    protected void doStart() throws IOException {
    }
}

