/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.maven.plugins.bombuilder;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.DependencyManagement;
import org.apache.maven.model.Exclusion;
import org.apache.maven.model.Model;
import org.apache.maven.model.building.ModelBuilder;
import org.apache.maven.model.io.xpp3.MavenXpp3Writer;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuilder;
import org.codehaus.plexus.util.StringUtils;
import org.jboss.maven.plugins.bombuilder.BomExclusion;
import org.jboss.maven.plugins.bombuilder.DependencyExclusion;

@Mojo(name="build-bom", defaultPhase=LifecyclePhase.GENERATE_RESOURCES, requiresDependencyResolution=ResolutionScope.COMPILE)
public class BuildBomMojo
extends AbstractMojo {
    private static final String VERSION_PROPERTY_PREFIX = "version.";
    @Parameter(required=true)
    private String bomGroupId;
    @Parameter(required=true)
    private String bomArtifactId;
    @Parameter(required=true)
    private String bomVersion;
    @Parameter(defaultValue="")
    private String bomName;
    @Parameter
    private boolean addVersionProperties;
    @Parameter(defaultValue="")
    private String bomDescription;
    @Parameter(defaultValue="bom-pom.xml")
    private String outputFilename;
    @Parameter
    private List<BomExclusion> exclusions;
    @Parameter
    private List<DependencyExclusion> dependencyExclusions;
    @Component
    private MavenProject mavenProject;
    @Component
    private ModelBuilder modelBuilder;
    @Component
    private ProjectBuilder projectBuilder;

    public void execute() throws MojoExecutionException {
        this.getLog().debug((CharSequence)"Generating BOM");
        Model model = this.initializeModel();
        this.addDependencyManagement(model);
        try {
            this.writeModel(model);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new MojoExecutionException("Unable to write pom file.", (Exception)e);
        }
    }

    private Model initializeModel() {
        Model pomModel = new Model();
        pomModel.setModelVersion("4.0.0");
        pomModel.setGroupId(this.bomGroupId);
        pomModel.setArtifactId(this.bomArtifactId);
        pomModel.setVersion(this.bomVersion);
        pomModel.setPackaging("pom");
        pomModel.setName(this.bomName);
        pomModel.setDescription(this.bomDescription);
        pomModel.getProperties().setProperty("project.build.sourceEncoding", "UTF-8");
        return pomModel;
    }

    private void addDependencyManagement(Model pomModel) {
        ArrayList projectArtifacts = new ArrayList(this.mavenProject.getArtifacts());
        Collections.sort(projectArtifacts);
        Properties versionProperties = new Properties();
        DependencyManagement depMgmt = new DependencyManagement();
        for (Artifact artifact : projectArtifacts) {
            if (this.isExcludedDependency(artifact)) continue;
            String versionPropertyName = VERSION_PROPERTY_PREFIX + artifact.getGroupId();
            if (versionProperties.getProperty(versionPropertyName) != null && !versionProperties.getProperty(versionPropertyName).equals(artifact.getVersion())) {
                versionPropertyName = VERSION_PROPERTY_PREFIX + artifact.getGroupId() + "." + artifact.getArtifactId();
            }
            versionProperties.setProperty(versionPropertyName, artifact.getVersion());
            Dependency dep = new Dependency();
            dep.setGroupId(artifact.getGroupId());
            dep.setArtifactId(artifact.getArtifactId());
            dep.setVersion(artifact.getVersion());
            if (!StringUtils.isEmpty((String)artifact.getClassifier())) {
                dep.setClassifier(artifact.getClassifier());
            }
            if (!StringUtils.isEmpty((String)artifact.getType())) {
                dep.setType(artifact.getType());
            }
            if (this.exclusions != null) {
                this.applyExclusions(artifact, dep);
            }
            depMgmt.addDependency(dep);
        }
        pomModel.setDependencyManagement(depMgmt);
        if (this.addVersionProperties) {
            pomModel.getProperties().putAll((Map<?, ?>)versionProperties);
        }
        this.getLog().debug((CharSequence)("Added " + projectArtifacts.size() + " dependencies."));
    }

    boolean isExcludedDependency(Artifact artifact) {
        if (this.dependencyExclusions == null || this.dependencyExclusions.size() == 0) {
            return false;
        }
        for (DependencyExclusion exclusion : this.dependencyExclusions) {
            if (!this.matchesExcludedDependency(artifact, exclusion)) continue;
            this.getLog().debug((CharSequence)("Artifact " + artifact.getGroupId() + ":" + artifact.getArtifactId() + " matches excluded dependency " + exclusion.getGroupId() + ":" + exclusion.getArtifactId()));
            return true;
        }
        return false;
    }

    boolean matchesExcludedDependency(Artifact artifact, DependencyExclusion exclusion) {
        String groupId = this.defaultAndTrim(artifact.getGroupId());
        String artifactId = this.defaultAndTrim(artifact.getArtifactId());
        String exclusionGroupId = this.defaultAndTrim(exclusion.getGroupId());
        String exclusionArtifactId = this.defaultAndTrim(exclusion.getArtifactId());
        boolean groupIdMatched = "*".equals(exclusionGroupId) || groupId.equals(exclusionGroupId);
        boolean artifactIdMatched = "*".equals(exclusionArtifactId) || artifactId.equals(exclusionArtifactId);
        return groupIdMatched && artifactIdMatched;
    }

    private String defaultAndTrim(String string) {
        return StringUtils.defaultString((Object)StringUtils.trim((String)string), (String)"");
    }

    private void applyExclusions(Artifact artifact, Dependency dep) {
        for (BomExclusion exclusion : this.exclusions) {
            if (!exclusion.getDependencyGroupId().equals(artifact.getGroupId()) || !exclusion.getDependencyArtifactId().equals(artifact.getArtifactId())) continue;
            Exclusion ex = new Exclusion();
            ex.setGroupId(exclusion.getExclusionGroupId());
            ex.setArtifactId(exclusion.getExclusionArtifactId());
            dep.addExclusion(ex);
        }
    }

    private void writeModel(Model pomModel) throws IOException {
        MavenXpp3Writer mavenWriter = new MavenXpp3Writer();
        File outputFile = new File(this.mavenProject.getBuild().getDirectory(), this.outputFilename);
        if (!outputFile.getParentFile().exists()) {
            outputFile.getParentFile().mkdirs();
        }
        FileWriter writer = new FileWriter(outputFile);
        mavenWriter.write((Writer)writer, pomModel);
    }
}

