package org.jboss.maven.plugins.deploy;

import java.io.FileNotFoundException;

import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.xml.sax.SAXException;

/**
 * Maven plugin for verifying a component-info.xml file.
 * By default it will search the current directory for
 * a file called component-info.xml.
 * Note: this goal in still in development.
 * 
 * @goal comp-info-verify
 * 
 */
public class CompInfoVerifyMojo extends AbstractMojo
{

   /**
    * The Maven Project Object
    *
    * @parameter expression="${project}"
    * @required
    * @readonly
    */
   protected MavenProject project;

   /**
    * Main execution path of the plugin.  Generates component-info.xml, and copies jar files to repository location.
    * TODO: Should be able to call this mojo from command line to verify any component-info.xml.
    */
   public void execute() throws MojoExecutionException
   {
      this.getLog().debug("Executing JBoss deploy plugin");
      String pathToCompInfo = System.getProperty("comp-info");
      if (pathToCompInfo == null)
      {
         pathToCompInfo = "component-info.xml";
      }
      CompInfoVerifier verifier = new CompInfoVerifier();
      try {
         verifier.verifyCompInfo("component-info.xml");
      } catch (FileNotFoundException fnfe) {
         fnfe.printStackTrace();
      } catch (SAXException saxe) {
         saxe.printStackTrace();
      }
   }
}
