/*
 * JBoss, the OpenSource J2EE webOS
 * 
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.maven.plugins.deploy;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

import javax.xml.XMLConstants;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;

import org.w3c.dom.Document;
import org.xml.sax.SAXException;

/**
 * 
 * Class to verify that a component-info.xml class is valid.
 * 
 * @author <a href="pgier@redhat.com">Paul Gier</a>
 * 
 */
public class CompInfoVerifier
{

   /**
    * Verify a component-info.xml file using the xsd.
    * 
    * @param compInfoFilePath Path to the component-info.xml to be verified.
    */
   public void verifyCompInfo(String compInfoFilePath) throws SAXException, java.io.FileNotFoundException
   {
      verifyCompInfo(new FileInputStream(compInfoFilePath));
   }

   /**
    * Verify a component-info.xml file using the xsd.
    * 
    * @param compInfoFilePath Path to the component-info.xml to be verified.
    */
   public void verifyCompInfo(InputStream compInfo) throws SAXException
   {
      try
      {
         // Parse an XML document into a DOM tree.
         DocumentBuilder parser = DocumentBuilderFactory.newInstance().newDocumentBuilder();
         Document document = parser.parse(compInfo);

         // Create a SchemaFactory capable of understanding WXS schemas.
         SchemaFactory factory = SchemaFactory.newInstance(XMLConstants.W3C_XML_SCHEMA_NS_URI);

         // Load a WXS schema, represented by a Schema instance.
         Source schemaFile = new StreamSource(this.getClass().getResourceAsStream("component-info.xsd"));
         Schema schema = factory.newSchema(schemaFile);

         // Create a Validator object, which can be used to validate
         // an instance document.
         Validator validator = schema.newValidator();

         // Validate the DOM tree.
         validator.validate(new DOMSource(document));
      }
      catch (ParserConfigurationException e)
      {
         e.printStackTrace();
      }
      catch (IOException e)
      {
         e.printStackTrace();
      }

   }

}
