/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.maven.plugins.qstools;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import org.apache.maven.doxia.sink.Sink;
import org.apache.maven.doxia.siterenderer.Renderer;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.BuildPluginManager;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.apache.maven.reporting.AbstractMavenReport;
import org.apache.maven.reporting.MavenReportException;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.jboss.jdf.stacks.client.StacksClient;
import org.jboss.jdf.stacks.model.Stacks;
import org.jboss.maven.plugins.qstools.QSChecker;
import org.jboss.maven.plugins.qstools.Violation;
import org.twdata.maven.mojoexecutor.MojoExecutor;

@Mojo(name="check", defaultPhase=LifecyclePhase.VERIFY, requiresDependencyResolution=ResolutionScope.COMPILE, requiresProject=true, threadSafe=true, aggregator=true)
public class QSCheckerReporter
extends AbstractMavenReport {
    @Component
    private PlexusContainer container;
    @Component
    private Renderer siteRenderer;
    @Component
    private MavenProject mavenProject;
    @Component
    private BuildPluginManager pluginManager;
    @Component
    private MavenSession mavenSession;
    @Parameter(property="reactorProjects", readonly=true, required=true)
    private List<MavenProject> reactorProjects;
    @Parameter(property="qstools.configFileURL", defaultValue="https://raw.github.com/jboss-jdf/qstools/master/config/qstools_config.yaml")
    private URL configFileURL;
    @Parameter(property="qstools.stacks.url")
    private URL stacksUrl;

    public String getDescription(Locale locale) {
        return "Quickstarts violations";
    }

    public String getName(Locale locale) {
        return "Quickstarts Checker Report";
    }

    public String getOutputName() {
        return "qschecker";
    }

    protected Renderer getSiteRenderer() {
        return this.siteRenderer;
    }

    protected String getOutputDirectory() {
        return this.mavenProject.getModel().getReporting().getOutputDirectory();
    }

    protected MavenProject getProject() {
        return this.mavenProject;
    }

    protected void executeReport(Locale locale) throws MavenReportException {
        try {
            this.configurePlugin();
            this.executeJXRAndSitePlugins();
            List checkersFound = this.container.lookupList(QSChecker.class);
            ArrayList<QSChecker> checkers = new ArrayList<QSChecker>(checkersFound);
            Collections.sort(checkers, new Comparator<QSChecker>(){

                @Override
                public int compare(QSChecker o1, QSChecker o2) {
                    return o1.getClass().getSimpleName().compareTo(o2.getClass().getSimpleName());
                }
            });
            TreeMap<String, List<Violation>> globalFilesViolations = new TreeMap<String, List<Violation>>();
            this.getLog().info((CharSequence)"Running Checkers: Somes checkers could be ignored for some projects.");
            for (QSChecker checker : checkers) {
                this.getLog().info((CharSequence)("Running Checker: " + checker.getClass().getSimpleName()));
                checker.resetViolationsQtd();
                Map<String, List<Violation>> checkerViolations = checker.check(this.mavenProject, this.mavenSession, this.reactorProjects, this.getLog());
                this.addCheckerViolationsToGlobalFilesViolations(globalFilesViolations, checkerViolations);
            }
            this.startReport(checkers, locale);
            this.doFileSummary(globalFilesViolations);
            this.doFileReports(globalFilesViolations);
            String reportName = this.mavenProject.getModel().getReporting().getOutputDirectory() + File.separator + this.getOutputName() + ".html";
            String msg = "Your report is ready at %1$s \n       You can access the report using Chrome or Firefox at the following URL: \n            file://%1$s";
            this.getLog().info((CharSequence)String.format(msg, reportName));
        }
        catch (Exception e) {
            throw new MavenReportException(e.getMessage(), e);
        }
        this.endReport();
    }

    private void configurePlugin() {
        this.getLog().info((CharSequence)("Using the following QSTools config file: " + this.configFileURL));
        this.container.getContext().put((Object)"qstools.configFileURL", (Object)this.configFileURL);
        StacksClient stacksClient = new StacksClient();
        if (this.stacksUrl != null) {
            stacksClient.getActualConfiguration().setUrl(this.stacksUrl);
        }
        this.getLog().info((CharSequence)("Using the following Stacks YML file: " + stacksClient.getActualConfiguration().getUrl()));
        Stacks stacks = stacksClient.getStacks();
        this.container.getContext().put((Object)"qstools.stacks", (Object)stacks);
        this.container.getContext().put((Object)"qstools.log", (Object)this.getLog());
        this.container.getContext().put((Object)"qstools.mavenSession", (Object)this.mavenSession);
        this.container.getContext().put((Object)"qstools.ignored.quickstarts", this.readIgnoredFile());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> readIgnoredFile() {
        ArrayList<String> result = new ArrayList<String>();
        BufferedReader br = null;
        try {
            br = new BufferedReader(new FileReader(".quickstarts_ignore"));
            while (br.ready()) {
                String line = br.readLine();
                result.add(line);
            }
        }
        catch (IOException e) {
            this.getLog().warn((CharSequence)"No .quickstarts_ignore file found. Proceeding without one.");
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException e) {
                    this.getLog().error((CharSequence)"Exception when closing BufferedReader", (Throwable)e);
                }
            }
        }
        return result;
    }

    private void addCheckerViolationsToGlobalFilesViolations(Map<String, List<Violation>> filesViolations, Map<String, List<Violation>> checkerViolations) {
        for (String file : checkerViolations.keySet()) {
            List<Violation> ckviolations = checkerViolations.get(file);
            if (filesViolations.get(file) == null) {
                this.getLog().debug((CharSequence)("New violations for file: " + file));
                filesViolations.put(file, new ArrayList());
            }
            filesViolations.get(file).addAll(ckviolations);
        }
    }

    private void executeJXRAndSitePlugins() throws MojoExecutionException {
        MojoExecutor.executeMojo((Plugin)MojoExecutor.plugin((String)MojoExecutor.groupId((String)"org.apache.maven.plugins"), (String)MojoExecutor.artifactId((String)"maven-jxr-plugin"), (String)MojoExecutor.version((String)"2.3")), (String)MojoExecutor.goal((String)"aggregate"), (Xpp3Dom)MojoExecutor.configuration((MojoExecutor.Element[])new MojoExecutor.Element[0]), (MojoExecutor.ExecutionEnvironment)MojoExecutor.executionEnvironment((MavenProject)this.mavenProject, (MavenSession)this.mavenSession, (BuildPluginManager)this.pluginManager));
        MojoExecutor.executeMojo((Plugin)MojoExecutor.plugin((String)MojoExecutor.groupId((String)"org.apache.maven.plugins"), (String)MojoExecutor.artifactId((String)"maven-jxr-plugin"), (String)MojoExecutor.version((String)"2.3")), (String)MojoExecutor.goal((String)"test-aggregate"), (Xpp3Dom)MojoExecutor.configuration((MojoExecutor.Element[])new MojoExecutor.Element[0]), (MojoExecutor.ExecutionEnvironment)MojoExecutor.executionEnvironment((MavenProject)this.mavenProject, (MavenSession)this.mavenSession, (BuildPluginManager)this.pluginManager));
        MojoExecutor.executeMojo((Plugin)MojoExecutor.plugin((String)MojoExecutor.groupId((String)"org.apache.maven.plugins"), (String)MojoExecutor.artifactId((String)"maven-site-plugin"), (String)MojoExecutor.version((String)"2.2")), (String)MojoExecutor.goal((String)"site"), (Xpp3Dom)MojoExecutor.configuration((MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)MojoExecutor.name((String)"generateReports"), (String)"false"), MojoExecutor.element((String)MojoExecutor.name((String)"generateSitemap"), (String)"false")}), (MojoExecutor.ExecutionEnvironment)MojoExecutor.executionEnvironment((MavenProject)this.mavenProject, (MavenSession)this.mavenSession, (BuildPluginManager)this.pluginManager));
    }

    private void doFileReports(Map<String, List<Violation>> fileViolations) {
        Sink sink = this.getSink();
        sink.section1();
        sink.sectionTitle1();
        sink.text("Files Violations");
        sink.sectionTitle1_();
        for (String file : fileViolations.keySet()) {
            sink.anchor(file.replace('/', '.'));
            sink.anchor_();
            sink.section2();
            sink.sectionTitle2();
            sink.text(file);
            sink.sectionTitle2_();
            sink.table();
            sink.tableRow();
            sink.tableHeaderCell();
            sink.text("Checker");
            sink.tableHeaderCell_();
            sink.tableHeaderCell();
            sink.text("Message");
            sink.tableHeaderCell_();
            sink.tableHeaderCell();
            sink.text("Line num.");
            sink.tableHeaderCell_();
            sink.tableRow_();
            List<Violation> violations = fileViolations.get(file);
            for (Violation violation : violations) {
                String linelink;
                String path;
                sink.tableRow();
                sink.tableCell();
                sink.text(violation.getSourceChecker().getSimpleName());
                sink.tableCell_();
                sink.tableCell();
                sink.text(violation.getViolationMessage());
                sink.tableCell_();
                sink.tableCell();
                String expression = "src/main/java";
                int pathIndex = file.lastIndexOf(expression);
                if (pathIndex > 0) {
                    path = file.substring(pathIndex + expression.length()).replaceAll("\\.java$", ".html");
                    File xrefSource = new File(this.mavenProject.getModel().getReporting().getOutputDirectory() + "/xref/" + path);
                    if (xrefSource.exists()) {
                        linelink = xrefSource.getAbsolutePath() + "#" + violation.getLineNumber();
                        sink.link(linelink);
                    }
                }
                if ((pathIndex = file.lastIndexOf(expression = "src/test/java")) > 0) {
                    path = file.substring(pathIndex + expression.length()).replaceAll("\\.java$", ".html");
                    File xrefTestSource = new File(this.mavenProject.getModel().getReporting().getOutputDirectory() + "/xref-test/" + path);
                    if (xrefTestSource.exists()) {
                        linelink = xrefTestSource.getAbsolutePath() + "#" + violation.getLineNumber();
                        sink.link(linelink);
                    }
                }
                sink.text(String.valueOf(violation.getLineNumber()));
                sink.link_();
                sink.tableCell_();
                sink.tableRow_();
            }
            sink.table_();
            sink.section2_();
        }
        sink.section1_();
    }

    private void doFileSummary(Map<String, List<Violation>> filesViolations) {
        Sink sink = this.getSink();
        sink.section1();
        sink.sectionTitle1();
        sink.text("Files");
        sink.sectionTitle2_();
        sink.table();
        sink.tableRow();
        sink.tableHeaderCell();
        sink.text("File");
        sink.tableHeaderCell_();
        sink.tableHeaderCell();
        sink.text("Violations qtd.");
        sink.tableHeaderCell_();
        sink.tableRow();
        for (String file : filesViolations.keySet()) {
            sink.tableRow();
            sink.tableCell();
            sink.link("#" + file.replace('/', '.'));
            sink.text(file);
            sink.link_();
            sink.tableCell_();
            sink.tableCell();
            sink.text(String.valueOf(filesViolations.get(file).size()));
            sink.tableCell_();
            sink.tableRow();
        }
        sink.table_();
        sink.section1_();
    }

    private void startReport(List<QSChecker> checkers, Locale locale) {
        Sink sink = this.getSink();
        sink.head();
        sink.title();
        sink.text(this.getName(locale));
        sink.title_();
        sink.head_();
        sink.body();
        sink.section1();
        sink.sectionTitle1();
        sink.text("Quickstart Check Results");
        sink.sectionTitle1_();
        sink.text("The following checkers were used: ");
        sink.table();
        sink.tableRow();
        sink.tableHeaderCell();
        sink.text("Checker");
        sink.tableHeaderCell_();
        sink.tableHeaderCell();
        sink.text("Description");
        sink.tableHeaderCell_();
        sink.tableHeaderCell();
        sink.text("Violations qtd.");
        sink.tableHeaderCell_();
        sink.tableRow();
        for (QSChecker checker : checkers) {
            sink.tableRow();
            sink.tableCell();
            sink.bold();
            sink.text(checker.getClass().getSimpleName());
            sink.bold_();
            sink.link_();
            sink.tableCell_();
            sink.tableCell();
            sink.text(checker.getCheckerDescription());
            sink.tableCell_();
            sink.tableCell();
            sink.text(String.valueOf(checker.getViolatonsQtd()));
            sink.tableCell_();
            sink.tableRow();
        }
        sink.table_();
        sink.section1_();
    }

    private void endReport() {
        Sink sink = this.getSink();
        sink.body_();
        sink.flush();
        sink.close();
    }
}

