/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.maven.plugins.qstools.checkers;

import com.puppycrawl.tools.checkstyle.api.AuditEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.checkstyle.CheckstyleExecutor;
import org.apache.maven.plugin.checkstyle.CheckstyleExecutorRequest;
import org.apache.maven.plugin.checkstyle.CheckstyleResults;
import org.apache.maven.plugin.checkstyle.DefaultCheckstyleExecutor;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.component.annotations.Requirement;
import org.jboss.maven.plugins.qstools.QSChecker;
import org.jboss.maven.plugins.qstools.QSCheckerException;
import org.jboss.maven.plugins.qstools.Violation;
import org.jboss.maven.plugins.qstools.config.ConfigurationProvider;
import org.jboss.maven.plugins.qstools.config.Rules;

public abstract class AbstractCheckstyleChecker
implements QSChecker {
    @Requirement
    private ConfigurationProvider configurationProvider;
    private int violationsQtd;
    @Requirement(role=CheckstyleExecutor.class)
    private DefaultCheckstyleExecutor checkstyleExecutor;

    @Override
    public int getViolatonsQtd() {
        return this.violationsQtd;
    }

    @Override
    public void resetViolationsQtd() {
        this.violationsQtd = 0;
    }

    @Override
    public Map<String, List<Violation>> check(MavenProject project, MavenSession mavenSession, List<MavenProject> reactorProjects, Log log) throws QSCheckerException {
        TreeMap<String, List<Violation>> results = new TreeMap<String, List<Violation>>();
        if (this.configurationProvider.getQuickstartsRules(project.getGroupId()).isCheckerIgnored(this)) {
            String msg = "Skiping %s for %s:%s";
            log.warn((CharSequence)String.format(msg, this.getClass().getSimpleName(), project.getGroupId(), project.getArtifactId()));
        } else {
            CheckstyleExecutorRequest executorRequest = new CheckstyleExecutorRequest();
            Rules rules = this.configurationProvider.getQuickstartsRules(project.getGroupId());
            try {
                executorRequest.setReactorProjects(reactorProjects).setSourceDirectory(project.getBasedir()).setTestSourceDirectory(project.getBasedir()).setFailsOnError(false).setProject(project).setConfigLocation(this.getCheckstyleConfig()).setLog(log).setEncoding("UTF-8").setHeaderLocation(rules.getHeaderLocation()).setIncludes(this.getIncludes()).setExcludes(rules.getExcludes());
                CheckstyleResults checkstyleResults = this.checkstyleExecutor.executeCheckstyle(executorRequest);
                Map files = checkstyleResults.getFiles();
                for (String file : files.keySet()) {
                    List events = (List)files.get(file);
                    if (events.size() <= 0) continue;
                    ArrayList<Violation> violations = new ArrayList<Violation>();
                    for (AuditEvent event : events) {
                        violations.add(new Violation(this.getClass(), event.getLine(), event.getMessage()));
                        ++this.violationsQtd;
                    }
                    results.put(file, violations);
                }
            }
            catch (Exception e) {
                throw new QSCheckerException(e);
            }
        }
        return results;
    }

    abstract String getIncludes();

    abstract String getCheckstyleConfig();
}

