/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.maven.plugins.qstools.checkers;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.xml.xpath.XPathConstants;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.component.annotations.Component;
import org.jboss.maven.plugins.qstools.QSChecker;
import org.jboss.maven.plugins.qstools.Violation;
import org.jboss.maven.plugins.qstools.checkers.AbstractProjectChecker;
import org.jboss.maven.plugins.qstools.config.Rules;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

@Component(role=QSChecker.class, hint="pomDescriptionChecker")
public class PomNameChecker
extends AbstractProjectChecker {
    private static final String TARGET_PRODUCT_TAG = "Target Product:";

    @Override
    public String getCheckerDescription() {
        return "Check if the POM.xml <name> uses the defined pattern";
    }

    @Override
    public void processProject(MavenProject project, Document doc, Map<String, List<Violation>> results) throws Exception {
        String pattern;
        String targetProject;
        Rules rules = this.getConfigurationProvider().getQuickstartsRules(project.getGroupId());
        String pomNamePattern = rules.getPomNamePattern();
        String pomNamePatternSubmodule = rules.getPomNamePatternForSubmodule();
        String folderName = project.getBasedir().getName();
        String parentFolder = project.getBasedir().getParentFile().getName();
        if (this.isSubProjec(project)) {
            File parentReadme = new File(project.getBasedir().getParent(), "README.md");
            targetProject = this.getTargetProduct(parentReadme);
            pattern = pomNamePatternSubmodule.replace("<target-product>", targetProject).replace("<project-folder>", parentFolder).replace("<submodule-folder>", folderName);
        } else {
            File readme = new File(folderName, "README.md");
            if (readme.exists()) {
                targetProject = this.getTargetProduct(readme);
                pattern = pomNamePattern.replace("<target-product>", targetProject).replace("<project-folder>", folderName);
            } else {
                pattern = project.getName();
            }
        }
        if (!pattern.equals(project.getName())) {
            Node nameNode = (Node)this.getxPath().evaluate("/project/name", doc, XPathConstants.NODE);
            int lineNumber = this.getLineNumberFromNode(nameNode);
            String msg = "Project uses name [%s] but should use the define name: %s";
            this.addViolation(project.getFile(), results, lineNumber, String.format(msg, project.getName(), pattern));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getTargetProduct(File readme) throws IOException {
        BufferedReader br = new BufferedReader(new FileReader(readme));
        try {
            while (br.ready()) {
                String line = br.readLine();
                if (!line.startsWith(TARGET_PRODUCT_TAG)) continue;
                String string = line.substring(TARGET_PRODUCT_TAG.length(), line.length()).trim();
                return string;
            }
            String string = "";
            return string;
        }
        finally {
            if (br != null) {
                br.close();
            }
        }
    }

    private boolean isSubProjec(MavenProject project) {
        return !new File(project.getBasedir(), "README.md").exists() && new File(project.getBasedir().getParent(), "README.md").exists();
    }
}

