/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.maven.plugins.qstools.config;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.settings.Proxy;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.context.Context;
import org.codehaus.plexus.context.ContextException;
import org.jboss.maven.plugins.qstools.config.Rules;
import org.yaml.snakeyaml.Yaml;

@Component(role=ConfigurationProvider.class)
public class ConfigurationProvider {
    @Requirement
    private Context context;
    private URL configFileURL;
    private Log log;
    private MavenSession mavenSession;
    private Map<String, Rules> configRules = new HashMap<String, Rules>();

    private void configure() throws ContextException {
        this.configFileURL = (URL)this.context.get((Object)"qstools.configFileURL");
        this.log = (Log)this.context.get((Object)"qstools.log");
        this.mavenSession = (MavenSession)this.context.get((Object)"qstools.mavenSession");
    }

    public Rules getQuickstartsRules(String groupId) {
        Rules rules;
        if (this.configFileURL == null) {
            try {
                this.configure();
            }
            catch (ContextException e) {
                e.printStackTrace();
                return null;
            }
        }
        if ((rules = this.configRules.get(groupId)) == null) {
            rules = this.initializeConfig(groupId);
        }
        return rules;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Rules initializeConfig(String groupId) {
        InputStream inputStream = null;
        try {
            inputStream = this.getConfigFileInputStream();
            Yaml yaml = new Yaml();
            Map configFile = (Map)yaml.load(inputStream);
            Map quickstartsGroupIds = (Map)configFile.get("quickstarts");
            LinkedList<Map> configs = (LinkedList<Map>)quickstartsGroupIds.get(groupId);
            if (configs == null) {
                Map defaultRulesSection = (Map)((List)configFile.get("rules")).get(0);
                LinkedList<Map> defaultRules = new LinkedList<Map>();
                defaultRules.add(defaultRulesSection);
                configs = defaultRules;
            }
            Rules rules = new Rules((List<Object>)configs);
            this.configRules.put(groupId, rules);
            Rules rules2 = this.configRules.get(groupId);
            return rules2;
        }
        catch (FileNotFoundException e) {
            this.log.error((CharSequence)"FileNotFoundException", (Throwable)e);
            Rules rules = null;
            return rules;
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    this.log.error((CharSequence)"Something bad happened when closing the inputstream", (Throwable)e);
                }
            }
        }
    }

    private InputStream getConfigFileInputStream() throws FileNotFoundException {
        InputStream repoStream = this.getCachedRepoStream(false);
        if (repoStream == null) {
            this.log.debug((CharSequence)("Local cache file " + this.getLocalCacheFile() + " doesn't exist or cache has been expired"));
            try {
                this.log.debug((CharSequence)("Retrieving Configuration from Remote repository " + this.configFileURL));
                repoStream = this.retrieveConfigurationFileFromRemoteRepository();
                this.setCachedRepoStream(repoStream);
                this.log.debug((CharSequence)("Forcing the use of local cache after download file without error from " + this.configFileURL));
                repoStream = this.getCachedRepoStream(true);
            }
            catch (Exception e) {
                this.log.warn((CharSequence)("It was not possible to contact the repository at " + this.configFileURL + " . Cause " + e.getMessage()));
                this.log.warn((CharSequence)"Falling back to cache!");
                repoStream = this.getCachedRepoStream(true);
            }
        }
        return repoStream;
    }

    private InputStream getCachedRepoStream(boolean force) throws FileNotFoundException {
        String logmessage = "Local file %1s %2s used! Reason: Force:[%3b] - LastModification: %4d/%5d";
        File localCacheFile = this.getLocalCacheFile();
        if (localCacheFile.exists()) {
            long cachedvalidity = 60000L;
            long lastModified = localCacheFile.lastModified();
            long timeSinceLastModification = System.currentTimeMillis() - lastModified;
            if (force || timeSinceLastModification <= cachedvalidity) {
                this.log.debug((CharSequence)String.format("Local file %1s %2s used! Reason: Force:[%3b] - LastModification: %4d/%5d", localCacheFile, "was", force, timeSinceLastModification, cachedvalidity));
                return new FileInputStream(localCacheFile);
            }
            this.log.debug((CharSequence)String.format("Local file %1s %2s used! Reason: Force:[%3b] - LastModification: %4d/%5d", localCacheFile, "was not", force, timeSinceLastModification, cachedvalidity));
        }
        return null;
    }

    private void setCachedRepoStream(InputStream stream) throws IOException {
        File localCacheFile = this.getLocalCacheFile();
        this.log.debug((CharSequence)("Content stored at " + localCacheFile));
        if (!localCacheFile.exists()) {
            localCacheFile.createNewFile();
        }
        FileOutputStream fos = new FileOutputStream(localCacheFile);
        int i = 0;
        while ((i = stream.read()) != -1) {
            fos.write(i);
        }
        fos.close();
    }

    private File getLocalCacheFile() {
        String repo = this.configFileURL.toString().replaceAll("[^a-zA-Z_0-9]", "");
        return new File(System.getProperty("java.io.tmpdir"), repo + "qstools_config.yaml");
    }

    private InputStream retrieveConfigurationFileFromRemoteRepository() throws Exception {
        if (this.configFileURL.getProtocol().startsWith("http")) {
            HttpGet httpGet = new HttpGet(this.configFileURL.toURI());
            DefaultHttpClient client = new DefaultHttpClient();
            this.configureProxy(client);
            HttpResponse httpResponse = client.execute((HttpUriRequest)httpGet);
            switch (httpResponse.getStatusLine().getStatusCode()) {
                case 200: {
                    this.log.debug((CharSequence)"Connected to repository! Getting available Stacks");
                    break;
                }
                case 404: {
                    this.log.error((CharSequence)("Failed! (Config file not found: " + this.configFileURL + ")"));
                    return null;
                }
                default: {
                    this.log.error((CharSequence)("Failed! (server returned status code: " + httpResponse.getStatusLine().getStatusCode()));
                    return null;
                }
            }
            return httpResponse.getEntity().getContent();
        }
        if (this.configFileURL.getProtocol().startsWith("file")) {
            return new FileInputStream(new File(this.configFileURL.toURI()));
        }
        return null;
    }

    private void configureProxy(DefaultHttpClient client) {
        Proxy proxyConfig = null;
        if (this.mavenSession.getSettings().getProxies().size() > 0) {
            proxyConfig = (Proxy)this.mavenSession.getSettings().getProxies().get(0);
        }
        if (proxyConfig != null) {
            HttpHost proxy = new HttpHost(proxyConfig.getHost(), proxyConfig.getPort());
            client.getParams().setParameter("http.route.default-proxy", (Object)proxy);
            String proxyUsername = proxyConfig.getUsername();
            if (proxyUsername != null && !proxyUsername.isEmpty()) {
                String proxyPassword = proxyConfig.getPassword();
                AuthScope authScope = new AuthScope(proxyConfig.getHost(), proxyConfig.getPort());
                UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(proxyUsername, proxyPassword);
                client.getCredentialsProvider().setCredentials(authScope, (Credentials)credentials);
            }
        }
    }
}

