/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.maven.plugins.qstools.config;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.jboss.maven.plugins.qstools.QSChecker;

public class Rules {
    private List<Object> configurations;

    public Rules(List<Object> configurations) {
        this.configurations = configurations;
    }

    public boolean isCheckerIgnored(QSChecker checker) {
        List ignoredCheckers = (List)this.getConfig("ignored-checkers");
        return ignoredCheckers.contains(checker.getClass().getSimpleName());
    }

    public String getExcludes() {
        Object excludes = this.getConfig("excludes");
        return excludes.toString().replace('[', ' ').replace(']', ' ');
    }

    public String getHeaderLocation() {
        return (String)this.getConfig("header-file");
    }

    public String getGroupId() {
        return (String)this.getConfig("groupid");
    }

    public String getArtifactIdPrefix() {
        return (String)this.getConfig("artifactid-prefix");
    }

    public String getPomNamePattern() {
        return (String)this.getConfig("pom-name-pattern");
    }

    public String getPomNamePatternForSubmodule() {
        return (String)this.getConfig("pom-name-pattern-submodule");
    }

    public Properties getExpectedBomVersion() {
        List propertiesAsList = (List)this.getConfig("expected-bom-versions");
        Properties p = new Properties();
        for (Object o : propertiesAsList) {
            p.putAll((Map<?, ?>)((Map)o));
        }
        return p;
    }

    public Properties getPropertiesNames() {
        List propertiesAsList = (List)this.getConfig("property-names");
        Properties p = new Properties();
        for (Object o : propertiesAsList) {
            p.putAll((Map<?, ?>)((Map)o));
        }
        return p;
    }

    public List<String> getPomOrder() {
        List pomOrder = (List)this.getConfig("pom-order");
        ArrayList<String> list = new ArrayList<String>();
        for (String o : pomOrder) {
            list.add(o);
        }
        return list;
    }

    public List<String> getIgnoredModules() {
        List modules = (List)this.getConfig("ignored-modules");
        ArrayList<String> list = new ArrayList<String>();
        for (String o : modules) {
            list.add(o);
        }
        return list;
    }

    public Map<String, String> getReadmeMetadatas() {
        List metadatas = (List)this.getConfig("readme-metadatas");
        HashMap<String, String> map = new HashMap<String, String>();
        for (Object o : metadatas) {
            map.putAll((Map)o);
        }
        return map;
    }

    public Object getConfig(String configValue) {
        Object value = null;
        for (Object config : this.configurations) {
            Object foundValue = ((Map)config).get(configValue);
            if (foundValue == null) continue;
            value = foundValue;
        }
        return value;
    }
}

