/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.maven.plugins.qstools.checkers;

import java.io.File;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathFactory;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.context.Context;
import org.jboss.maven.plugins.qstools.DependencyProvider;
import org.jboss.maven.plugins.qstools.QSChecker;
import org.jboss.maven.plugins.qstools.QSCheckerException;
import org.jboss.maven.plugins.qstools.Violation;
import org.jboss.maven.plugins.qstools.config.ConfigurationProvider;
import org.jboss.maven.plugins.qstools.xml.PositionalXMLReader;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public abstract class AbstractProjectChecker
implements QSChecker {
    @Requirement
    private Context context;
    @Requirement
    private DependencyProvider dependencyProvider;
    @Requirement
    private ConfigurationProvider configurationProvider;
    private XPath xPath = XPathFactory.newInstance().newXPath();
    private Log log;
    private MavenSession mavenSession;
    private int violationsQtd;

    @Override
    public int getViolatonsQtd() {
        return this.violationsQtd;
    }

    @Override
    public void resetViolationsQtd() {
        this.violationsQtd = 0;
    }

    @Override
    public Map<String, List<Violation>> check(MavenProject project, MavenSession mavenSession, List<MavenProject> reactorProjects, Log log) throws QSCheckerException {
        this.mavenSession = mavenSession;
        this.log = log;
        TreeMap<String, List<Violation>> results = new TreeMap<String, List<Violation>>();
        try {
            List ignoredQuickstarts = (List)this.context.get((Object)"qstools.ignored.quickstarts");
            for (MavenProject mavenProject : reactorProjects) {
                if (!ignoredQuickstarts.contains(mavenProject.getBasedir().getName())) {
                    Document doc = PositionalXMLReader.readXML(new FileInputStream(mavenProject.getFile()));
                    if (this.configurationProvider.getQuickstartsRules(project.getGroupId()).isCheckerIgnored(this)) {
                        String msg = "Skiping %s for %s:%s";
                        log.warn((CharSequence)String.format(msg, this.getClass().getSimpleName(), project.getGroupId(), project.getArtifactId()));
                        continue;
                    }
                    this.processProject(mavenProject, doc, results);
                    continue;
                }
                log.debug((CharSequence)("Ignoring " + mavenProject.getBasedir().getName() + ". It is listed on .quickstarts_ignore file"));
            }
            if (this.violationsQtd > 0) {
                log.info((CharSequence)("There are " + this.violationsQtd + " checkers errors"));
            }
        }
        catch (Exception e) {
            throw new QSCheckerException(e);
        }
        return results;
    }

    protected int getLineNumberFromNode(Node node) {
        if (node == null) {
            return 0;
        }
        return (Integer)node.getUserData("beginLineNumber");
    }

    protected void addViolation(File file, Map<String, List<Violation>> results, int lineNumber, String violationMessage) {
        String rootDirectory = (this.mavenSession.getExecutionRootDirectory() + File.separator).replace("\\", "\\\\");
        String fileAsString = file.getAbsolutePath().replace(rootDirectory, "");
        if (results.get(fileAsString) == null) {
            results.put(fileAsString, new ArrayList());
        }
        results.get(fileAsString).add(new Violation(this.getClass(), lineNumber, violationMessage));
        ++this.violationsQtd;
    }

    public abstract void processProject(MavenProject var1, Document var2, Map<String, List<Violation>> var3) throws Exception;

    protected DependencyProvider getDependencyProvider() {
        return this.dependencyProvider;
    }

    protected XPath getxPath() {
        return this.xPath;
    }

    protected Log getLog() {
        return this.log;
    }

    protected MavenSession getMavenSession() {
        return this.mavenSession;
    }

    public Context getContext() {
        return this.context;
    }

    public ConfigurationProvider getConfigurationProvider() {
        return this.configurationProvider;
    }
}

