/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.maven.plugins.qstools.checkers;

import java.util.List;
import java.util.Map;
import javax.xml.xpath.XPathConstants;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.component.annotations.Component;
import org.jboss.maven.plugins.qstools.QSChecker;
import org.jboss.maven.plugins.qstools.Violation;
import org.jboss.maven.plugins.qstools.checkers.AbstractProjectChecker;
import org.jboss.maven.plugins.qstools.config.Rules;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

@Component(role=QSChecker.class, hint="artifactIdPrefixChecker")
public class ArtifactIdPrefixChecker
extends AbstractProjectChecker {
    @Override
    public String getCheckerDescription() {
        return "Check if the Maven ArtifactId uses a valid prefix";
    }

    @Override
    public void processProject(MavenProject project, Document doc, Map<String, List<Violation>> results) throws Exception {
        Rules rules = this.getConfigurationProvider().getQuickstartsRules(project.getGroupId());
        String artifarIdPrefix = rules.getArtifactIdPrefix();
        if (!project.getArtifactId().startsWith(artifarIdPrefix)) {
            Node artifacId = (Node)this.getxPath().evaluate("/project/artifactId", doc, XPathConstants.NODE);
            int lineNumber = artifacId == null ? 0 : this.getLineNumberFromNode(artifacId);
            String msg = "Project with the following artifactId [%s] isn't doesn't start with [%s]";
            this.addViolation(project.getFile(), results, lineNumber, String.format(msg, project.getArtifactId(), artifarIdPrefix));
        }
    }
}

