/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.maven.plugins.qstools.checkers;

import java.io.FileReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.xpath.XPathConstants;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.resolver.ArtifactResolutionRequest;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Model;
import org.apache.maven.model.Parent;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.apache.maven.project.MavenProject;
import org.apache.maven.repository.RepositorySystem;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.jboss.jdf.stacks.client.StacksClient;
import org.jboss.jdf.stacks.model.Bom;
import org.jboss.maven.plugins.qstools.QSChecker;
import org.jboss.maven.plugins.qstools.Violation;
import org.jboss.maven.plugins.qstools.checkers.AbstractProjectChecker;
import org.jboss.maven.plugins.qstools.maven.MavenDependency;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Component(role=QSChecker.class, hint="dependencyChecker")
public class DependencyChecker
extends AbstractProjectChecker {
    private static Map<MavenGA, Set<Bom>> managedDependencies;
    @Requirement
    private RepositorySystem repositorySystem;

    private void setupManagedDependencies(MavenProject project) throws Exception {
        managedDependencies = new HashMap<MavenGA, Set<Bom>>();
        StacksClient sc = new StacksClient();
        List boms = sc.getStacks().getAvailableBoms();
        for (Bom bom : boms) {
            this.readBOMArtifact(project, bom, bom.getGroupId(), bom.getArtifactId(), bom.getRecommendedVersion());
        }
    }

    private void readBOMArtifact(MavenProject mavenProject, Bom bom, String groupId, String artifactId, String version) throws Exception {
        Artifact pomArtifact = this.repositorySystem.createArtifact(groupId, artifactId, version, "", "pom");
        ArtifactResolutionRequest arr = new ArtifactResolutionRequest();
        arr.setArtifact(pomArtifact).setRemoteRepositories(mavenProject.getRemoteArtifactRepositories()).setLocalRepository(this.getMavenSession().getLocalRepository());
        this.repositorySystem.resolve(arr);
        this.readBOM(mavenProject, bom, pomArtifact);
    }

    private void readBOM(MavenProject mavenProject, Bom bom, Artifact pomArtifact) throws Exception {
        if (pomArtifact.getFile().exists()) {
            MavenXpp3Reader reader = new MavenXpp3Reader();
            Model model = reader.read((Reader)new FileReader(pomArtifact.getFile()));
            if (model.getParent() != null) {
                Parent p = model.getParent();
                this.readBOMArtifact(mavenProject, bom, p.getGroupId(), p.getArtifactId(), p.getVersion());
            }
            if (model.getDependencyManagement() != null) {
                for (Dependency dep : model.getDependencyManagement().getDependencies()) {
                    MavenGA mvnDependency = new MavenGA(dep.getGroupId(), dep.getArtifactId());
                    if (managedDependencies.get(mvnDependency) == null) {
                        managedDependencies.put(mvnDependency, new HashSet());
                    }
                    managedDependencies.get(mvnDependency).add(bom);
                }
            }
        } else {
            String msg = String.format("BOM %s (from jdf-stacks) was not found. You may need to configure an EAP/WFK repository in your settings.xml.", pomArtifact);
            this.getLog().debug((CharSequence)msg);
        }
    }

    @Override
    public String getCheckerDescription() {
        return "Checks if all dependencies are using a BOM (not declare a version) and suggest what BOMs to use";
    }

    @Override
    public void processProject(MavenProject project, Document doc, Map<String, List<Violation>> results) throws Exception {
        if (managedDependencies == null) {
            this.setupManagedDependencies(project);
        }
        NodeList dependencies = (NodeList)this.getxPath().evaluate("/project/dependencies/dependency", doc, XPathConstants.NODESET);
        for (int x = 0; x < dependencies.getLength(); ++x) {
            Node dependency = dependencies.item(x);
            MavenDependency mavenDependency = this.getDependencyProvider().getDependencyFromNode(project, dependency);
            int lineNumber = this.getLineNumberFromNode(dependency);
            MavenGA ga = new MavenGA(mavenDependency.getGroupId(), mavenDependency.getArtifactId());
            if (mavenDependency.getDeclaredVersion() == null || mavenDependency.getDeclaredVersion().equals("${project.version}")) continue;
            StringBuilder sb = new StringBuilder(String.format("You should NOT declare a version for %s:%s:%s. Consider using <dependencyManagement/>", mavenDependency.getGroupId(), mavenDependency.getArtifactId(), mavenDependency.getDeclaredVersion()));
            if (managedDependencies.get(ga) != null) {
                sb.append("Recommended BOMs with this dependency: ");
                for (Bom bom : managedDependencies.get(ga)) {
                    sb.append(String.format("%s:%s:%s / ", bom.getGroupId(), bom.getArtifactId(), bom.getRecommendedVersion()));
                }
            }
            this.addViolation(project.getFile(), results, lineNumber, sb.toString());
        }
    }

    private class MavenGA {
        private String groupId;
        private String artifactId;

        public MavenGA(String groupId, String artifactId) {
            this.groupId = groupId;
            this.artifactId = artifactId;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.getOuterType().hashCode();
            result = 31 * result + (this.artifactId == null ? 0 : this.artifactId.hashCode());
            result = 31 * result + (this.groupId == null ? 0 : this.groupId.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            MavenGA other = (MavenGA)obj;
            if (!this.getOuterType().equals(other.getOuterType())) {
                return false;
            }
            if (this.artifactId == null ? other.artifactId != null : !this.artifactId.equals(other.artifactId)) {
                return false;
            }
            return !(this.groupId == null ? other.groupId != null : !this.groupId.equals(other.groupId));
        }

        private DependencyChecker getOuterType() {
            return DependencyChecker.this;
        }
    }
}

