/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.maven.plugins.qstools.checkers;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.xml.xpath.XPathConstants;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.component.annotations.Component;
import org.jboss.maven.plugins.qstools.QSChecker;
import org.jboss.maven.plugins.qstools.Violation;
import org.jboss.maven.plugins.qstools.checkers.AbstractProjectChecker;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

@Component(role=QSChecker.class, hint="pomElementOrderChecker")
public class PomElementOrderChecker
extends AbstractProjectChecker {
    @Override
    public String getCheckerDescription() {
        return "Checks if POM xml elements are in specific order";
    }

    @Override
    public void processProject(MavenProject project, Document doc, Map<String, List<Violation>> results) throws Exception {
        int lineNumber;
        List<String> pomElements = this.getConfigurationProvider().getQuickstartsRules(project.getGroupId()).getPomOrder();
        LinkedHashMap<String, Integer> elementsFound = new LinkedHashMap<String, Integer>();
        for (String element : pomElements) {
            Node elementNode = (Node)this.getxPath().evaluate("/project/" + element, doc, XPathConstants.NODE);
            if (elementNode == null) continue;
            lineNumber = this.getLineNumberFromNode(elementNode);
            elementsFound.put(element, lineNumber);
        }
        String previousElement = null;
        for (String element : elementsFound.keySet()) {
            int previousElementLineNumber;
            lineNumber = (Integer)elementsFound.get(element);
            if (previousElement != null && lineNumber < (previousElementLineNumber = ((Integer)elementsFound.get(previousElement)).intValue())) {
                String msg = "Element [%s] is not in the correct order: " + pomElements + ". It shoud come after [%s] on line %s";
                this.addViolation(project.getFile(), results, lineNumber, String.format(msg, element, previousElement, previousElementLineNumber));
            }
            previousElement = element;
        }
    }
}

