/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.maven.plugins.qstools.checkers;

import java.io.File;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.component.annotations.Component;
import org.jboss.maven.plugins.qstools.QSChecker;
import org.jboss.maven.plugins.qstools.QSCheckerException;
import org.jboss.maven.plugins.qstools.Violation;
import org.jboss.maven.plugins.qstools.xml.PositionalXMLReader;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Component(role=QSChecker.class, hint="samePropertyValueChecker")
public class SamePropertyValueChecker
implements QSChecker {
    private int violationsQtd;
    protected XPath xPath = XPathFactory.newInstance().newXPath();
    private Properties projectProperties = new Properties();

    @Override
    public Map<String, List<Violation>> check(MavenProject project, MavenSession mavenSession, List<MavenProject> reactorProjects, Log log) throws QSCheckerException {
        TreeMap<String, List<Violation>> results = new TreeMap<String, List<Violation>>();
        try {
            for (MavenProject mavenProject : reactorProjects) {
                Document doc = PositionalXMLReader.readXML(new FileInputStream(mavenProject.getFile()));
                NodeList propertiesNodes = (NodeList)this.xPath.evaluate("/project/properties/*", doc, XPathConstants.NODESET);
                for (int x = 0; x < propertiesNodes.getLength(); ++x) {
                    Node property = propertiesNodes.item(x);
                    String propertyName = property.getNodeName();
                    String propertyValue = property.getTextContent();
                    if (this.projectProperties.get(propertyName) == null) {
                        this.projectProperties.put(propertyName, propertyValue);
                        continue;
                    }
                    if (this.projectProperties.get(propertyName) == null || this.projectProperties.get(propertyName).equals(propertyValue)) continue;
                    int lineNumber = (Integer)property.getUserData("beginLineNumber");
                    String rootDirectory = (mavenSession.getExecutionRootDirectory() + File.separator).replace("\\", "\\\\");
                    String fileAsString = mavenProject.getFile().getAbsolutePath().replace(rootDirectory, "");
                    if (results.get(fileAsString) == null) {
                        results.put(fileAsString, new ArrayList());
                    }
                    String msg = "Property [%s] was declared with a value [%s] that differ from previous value [%s]";
                    ((List)results.get(fileAsString)).add(new Violation(this.getClass(), lineNumber, String.format(msg, propertyName, propertyValue, this.projectProperties.get(propertyName))));
                    ++this.violationsQtd;
                }
            }
            if (this.violationsQtd > 0) {
                log.info((CharSequence)("There are " + this.violationsQtd + " checkers errors"));
            }
        }
        catch (Exception e) {
            throw new QSCheckerException(e);
        }
        return results;
    }

    @Override
    public String getCheckerDescription() {
        return "Check if all declared properties uses the same version value across the projects/modules";
    }

    @Override
    public int getViolatonsQtd() {
        return this.violationsQtd;
    }

    @Override
    public void resetViolationsQtd() {
        this.violationsQtd = 0;
    }
}

