/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.maven.plugins.qstools.checkers;

import java.io.File;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Pattern;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.jboss.maven.plugins.qstools.QSChecker;
import org.jboss.maven.plugins.qstools.QSCheckerException;
import org.jboss.maven.plugins.qstools.Violation;
import org.jboss.maven.plugins.qstools.config.ConfigurationProvider;
import org.jboss.maven.plugins.qstools.config.Rules;
import org.jboss.maven.plugins.qstools.xml.PositionalXMLReader;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Component(role=QSChecker.class, hint="unusedPropertiesChecker")
public class UnusedPropertiesChecker
implements QSChecker {
    private Map<String, List<PomInformation>> declaredProperties = new HashMap<String, List<PomInformation>>();
    private Set<String> usedProperties = new HashSet<String>();
    protected XPath xPath = XPathFactory.newInstance().newXPath();
    private int violationsQtd;
    @Requirement
    private ConfigurationProvider configurationProvider;

    @Override
    public int getViolatonsQtd() {
        return this.violationsQtd;
    }

    @Override
    public void resetViolationsQtd() {
        this.violationsQtd = 0;
    }

    @Override
    public String getCheckerDescription() {
        return "Checks if a project and its modules has a declared and unused propery";
    }

    @Override
    public Map<String, List<Violation>> check(MavenProject project, MavenSession mavenSession, List<MavenProject> reactorProjects, Log log) throws QSCheckerException {
        TreeMap<String, List<Violation>> results = new TreeMap<String, List<Violation>>();
        Rules rules = this.configurationProvider.getQuickstartsRules(project.getGroupId());
        if (rules.isCheckerIgnored(this)) {
            String msg = "Skiping %s for %s:%s";
            log.warn((CharSequence)String.format(msg, this.getClass().getSimpleName(), project.getGroupId(), project.getArtifactId()));
        } else {
            try {
                for (MavenProject mavenProject : reactorProjects) {
                    Document doc = PositionalXMLReader.readXML(new FileInputStream(mavenProject.getFile()));
                    NodeList propertiesNodes = (NodeList)this.xPath.evaluate("/project/properties/*", doc, XPathConstants.NODESET);
                    NodeList allNodes = (NodeList)this.xPath.evaluate("//*", doc, XPathConstants.NODESET);
                    for (int x = 0; x < propertiesNodes.getLength(); ++x) {
                        Node property = propertiesNodes.item(x);
                        String propertyName = property.getNodeName();
                        int lineNumber = (Integer)property.getUserData("beginLineNumber");
                        PomInformation pi = new PomInformation(mavenProject, lineNumber);
                        if (this.declaredProperties.get(propertyName) == null) {
                            this.declaredProperties.put(propertyName, new ArrayList());
                        }
                        this.declaredProperties.get(propertyName).add(pi);
                    }
                    Pattern p = Pattern.compile("\\$\\{\\w+(.\\w+)*(-\\w+)*\\}");
                    for (int x = 0; x < allNodes.getLength(); ++x) {
                        Node node = allNodes.item(x);
                        String nodeContent = node.getTextContent();
                        if (!p.matcher(nodeContent).matches()) continue;
                        String usedProperty = node.getTextContent().replaceAll("[${}]", "");
                        this.usedProperties.add(usedProperty);
                    }
                }
                for (String declared : this.declaredProperties.keySet()) {
                    if (declared.startsWith("project") || rules.getIgnoredUnusedProperties().contains(declared) || this.usedProperties.contains(declared)) continue;
                    List<PomInformation> pomInformations = this.declaredProperties.get(declared);
                    for (PomInformation pi : pomInformations) {
                        String rootDirectory = (mavenSession.getExecutionRootDirectory() + File.separator).replace("\\", "\\\\");
                        String fileAsString = pi.getProject().getFile().getAbsolutePath().replace(rootDirectory, "");
                        if (results.get(fileAsString) == null) {
                            results.put(fileAsString, new ArrayList());
                        }
                        String msg = "Property [%s] was declared but was never used";
                        ((List)results.get(fileAsString)).add(new Violation(this.getClass(), pi.getLine(), String.format(msg, declared)));
                        ++this.violationsQtd;
                    }
                }
                if (this.violationsQtd > 0) {
                    log.info((CharSequence)("There are " + this.violationsQtd + " checkers errors"));
                }
            }
            catch (Exception e) {
                throw new QSCheckerException(e);
            }
        }
        return results;
    }

    private class PomInformation {
        private MavenProject project;
        private int line;

        public PomInformation(MavenProject project, int line) {
            this.project = project;
            this.line = line;
        }

        public MavenProject getProject() {
            return this.project;
        }

        public int getLine() {
            return this.line;
        }
    }
}

