/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.maven.plugins.qstools;

import java.io.File;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathFactory;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.context.Context;
import org.jboss.maven.plugins.qstools.DependencyProvider;
import org.jboss.maven.plugins.qstools.QSChecker;
import org.jboss.maven.plugins.qstools.QSCheckerException;
import org.jboss.maven.plugins.qstools.QSFixer;
import org.jboss.maven.plugins.qstools.Violation;
import org.jboss.maven.plugins.qstools.config.ConfigurationProvider;
import org.jboss.maven.plugins.qstools.xml.PositionalXMLReader;
import org.w3c.dom.Document;

public abstract class AbstractProjectWalker
implements QSChecker,
QSFixer {
    @Requirement
    private Context context;
    @Requirement
    private DependencyProvider dependencyProvider;
    @Requirement
    private ConfigurationProvider configurationProvider;
    private XPath xPath = XPathFactory.newInstance().newXPath();
    private Log log;
    private MavenSession mavenSession;
    private int violationsQtd;

    @Override
    public int getViolatonsQtd() {
        return this.violationsQtd;
    }

    @Override
    public void resetViolationsQtd() {
        this.violationsQtd = 0;
    }

    @Override
    public Map<String, List<Violation>> check(MavenProject project, MavenSession mavenSession, List<MavenProject> reactorProjects, Log log) throws QSCheckerException {
        TreeMap<String, List<Violation>> results = new TreeMap<String, List<Violation>>();
        this.walk(WalkType.CHECK, project, mavenSession, reactorProjects, log, results);
        if (this.violationsQtd > 0) {
            log.info((CharSequence)("There are " + this.violationsQtd + " checkers errors"));
        }
        return results;
    }

    @Override
    public void fix(MavenProject project, MavenSession mavenSession, List<MavenProject> reactorProjects, Log log) throws QSCheckerException {
        this.walk(WalkType.FIX, project, mavenSession, reactorProjects, log, null);
    }

    public void walk(WalkType walkType, MavenProject project, MavenSession mavenSession, List<MavenProject> reactorProjects, Log log, Map<String, List<Violation>> results) throws QSCheckerException {
        this.mavenSession = mavenSession;
        this.log = log;
        try {
            List ignoredQuickstarts = (List)this.context.get((Object)"qstools.ignored.quickstarts");
            for (MavenProject mavenProject : reactorProjects) {
                if (!ignoredQuickstarts.contains(mavenProject.getBasedir().getName())) {
                    Document doc = PositionalXMLReader.readXML(new FileInputStream(mavenProject.getFile()));
                    if (this.configurationProvider.getQuickstartsRules(project.getGroupId()).isCheckerIgnored(this)) {
                        String msg = "Skiping %s for %s:%s";
                        log.warn((CharSequence)String.format(msg, this.getClass().getSimpleName(), project.getGroupId(), project.getArtifactId()));
                        continue;
                    }
                    switch (walkType) {
                        case CHECK: {
                            this.checkProject(mavenProject, doc, results);
                            break;
                        }
                        case FIX: {
                            this.fixProject(mavenProject, doc);
                            break;
                        }
                    }
                    continue;
                }
                log.debug((CharSequence)("Ignoring " + mavenProject.getBasedir().getName() + ". It is listed on .quickstarts_ignore file"));
            }
        }
        catch (Exception e) {
            throw new QSCheckerException(e);
        }
    }

    protected void addViolation(File file, Map<String, List<Violation>> results, int lineNumber, String violationMessage) {
        String rootDirectory = (this.mavenSession.getExecutionRootDirectory() + File.separator).replace("\\", "\\\\");
        String fileAsString = file.getAbsolutePath().replace(rootDirectory, "");
        if (results.get(fileAsString) == null) {
            results.put(fileAsString, new ArrayList());
        }
        results.get(fileAsString).add(new Violation(this.getClass(), lineNumber, violationMessage));
        ++this.violationsQtd;
    }

    public abstract void checkProject(MavenProject var1, Document var2, Map<String, List<Violation>> var3) throws Exception;

    public abstract void fixProject(MavenProject var1, Document var2) throws Exception;

    protected DependencyProvider getDependencyProvider() {
        return this.dependencyProvider;
    }

    protected XPath getxPath() {
        return this.xPath;
    }

    protected Log getLog() {
        return this.log;
    }

    protected MavenSession getMavenSession() {
        return this.mavenSession;
    }

    protected Context getContext() {
        return this.context;
    }

    protected ConfigurationProvider getConfigurationProvider() {
        return this.configurationProvider;
    }

    private static enum WalkType {
        FIX,
        CHECK;

    }
}

