/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.maven.plugins.qstools;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.DependencyManagement;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.jboss.shrinkwrap.resolver.api.NoResolvedResultException;
import org.jboss.shrinkwrap.resolver.api.maven.Maven;
import org.jboss.shrinkwrap.resolver.api.maven.MavenFormatStage;
import org.jboss.shrinkwrap.resolver.api.maven.MavenStrategyStage;
import org.jboss.shrinkwrap.resolver.api.maven.PomEquippedResolveStage;

@Mojo(name="bom-check", defaultPhase=LifecyclePhase.VERIFY, requiresDependencyResolution=ResolutionScope.COMPILE, requiresProject=true, threadSafe=true, aggregator=false)
public class BomCheckerMojo
extends AbstractMojo {
    @Component
    private MavenProject project;
    @Parameter(property="qstools.bom-check.failbuild", defaultValue="true")
    private boolean failbuild;
    @Parameter(property="qstools.bom-check.ignoredDependencies")
    private List<String> ignoredDependencies = new ArrayList<String>();

    public void execute() throws MojoExecutionException, MojoFailureException {
        Logger.getLogger("org.jboss.shrinkwrap.resolver.impl").setLevel(Level.SEVERE);
        ArrayList<NoResolvedResultException> exceptions = new ArrayList<NoResolvedResultException>();
        this.getLog().info((CharSequence)"Verifying if the dependencies on project's Dependency Management section are resolvable");
        DependencyManagement depmgmt = this.project.getDependencyManagement();
        if (depmgmt != null) {
            List dependencies = depmgmt.getDependencies();
            for (Dependency dep : dependencies) {
                if (dep.getScope() != null && (dep.getScope().equals("runtime") || dep.getScope().equals("system"))) {
                    this.getLog().debug((CharSequence)("Ignoring runtime/system dependency " + dep));
                    continue;
                }
                try {
                    String pkg = dep.getType() == null ? "jar" : dep.getType();
                    String gav = dep.getGroupId() + ":" + dep.getArtifactId() + ":" + pkg + ":" + dep.getVersion();
                    if (this.ignoredDependencies.contains(gav)) {
                        this.getLog().warn((CharSequence)(gav + " ignored. It won't be resolved"));
                        continue;
                    }
                    this.getLog().debug((CharSequence)("Trying to resolve " + gav));
                    ((MavenFormatStage)((MavenStrategyStage)((MavenStrategyStage)((MavenStrategyStage)((PomEquippedResolveStage)Maven.resolver().loadPomFromFile(this.project.getFile())).resolve(gav)).withMavenCentralRepo(true)).withClassPathResolution(false)).withTransitivity()).asFile();
                }
                catch (NoResolvedResultException e) {
                    exceptions.add(e);
                }
            }
        }
        if (exceptions.isEmpty()) {
            this.getLog().info((CharSequence)"All Dependencies were resolved");
        } else {
            this.getLog().error((CharSequence)"The following dependencies where NOT resolved:");
            for (NoResolvedResultException e : exceptions) {
                this.getLog().error((CharSequence)e.getMessage());
            }
            if (this.failbuild) {
                throw new MojoFailureException("Unresolved dependencies on project");
            }
        }
    }
}

