/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.maven.plugins.qstools;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.eclipse.jgit.api.ApplyCommand;
import org.eclipse.jgit.api.CloneCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.api.errors.InvalidRemoteException;
import org.eclipse.jgit.api.errors.PatchApplyException;
import org.eclipse.jgit.api.errors.TransportException;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.storage.file.FileRepositoryBuilder;
import org.jboss.maven.plugins.qstools.xml.PositionalXMLReader;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

@Mojo(name="archetypeSync", defaultPhase=LifecyclePhase.GENERATE_SOURCES, requiresDependencyResolution=ResolutionScope.COMPILE, requiresProject=true, threadSafe=true, aggregator=false)
public class ArchetypeSyncMojo
extends AbstractMojo {
    private XPath xPath = XPathFactory.newInstance().newXPath();
    private static final String[] TEXT_EXTENSIONS = new String[]{"java", "css", "html", "xhtml", "md", "xml", "properties", "sql"};
    @Parameter(required=true, readonly=true)
    private String projectGitRepo;
    @Parameter(defaultValue="master")
    private String branch;
    @Parameter(required=true, readonly=true)
    private String projectPath;
    @Parameter(required=true, readonly=true)
    private String rootPackage;
    @Parameter(defaultValue="false", readonly=true)
    private boolean multiModuleProject;
    @Parameter(readonly=true)
    private String[] archetypeExpressionReplaceValues;
    @Parameter(readonly=true)
    private String[] ignoredArchetypeExpressionReplaceValues;
    @Parameter(readonly=true)
    private Map<String, String> replaceValueWithExpression = new HashMap<String, String>();
    @Parameter(readonly=true)
    private File applyPatch;
    @Parameter(property="project.build.directory", required=true)
    private String outputPath;
    @Parameter(property="basedir", required=true, readonly=true)
    private String baseDir;
    private File exampleProjectPath;
    private String originalGroupId = null;
    private String originalArtifactId = null;
    private String originalVersion = null;
    private String artifactExpression;

    public void execute() throws MojoExecutionException, MojoFailureException {
        try {
            this.exampleProjectPath = new File(this.outputPath + File.separator + "git", this.projectPath);
            this.artifactExpression = this.multiModuleProject ? "rootArtifactId" : "artifactId";
            this.cloneOriginProject();
            this.generateArchetype();
            this.applyPatch();
            this.getLog().info((CharSequence)("Archetype synched with " + this.projectPath + " from " + this.branch + " branch. You can check what changed running git diff."));
        }
        catch (Exception e) {
            throw new MojoFailureException(e.getMessage(), (Throwable)e);
        }
    }

    private void applyPatch() throws IOException, PatchApplyException {
        if (this.applyPatch != null) {
            FileRepositoryBuilder builder = new FileRepositoryBuilder();
            Repository repository = ((FileRepositoryBuilder)builder.findGitDir(new File(this.baseDir))).build();
            Git git = new Git(repository);
            ApplyCommand applyCommand = git.apply();
            applyCommand.setPatch((InputStream)new FileInputStream(this.applyPatch));
            try {
                applyCommand.call();
            }
            catch (GitAPIException e) {
                throw new PatchApplyException("Can't apply " + this.applyPatch, (Throwable)e);
            }
            this.getLog().info((CharSequence)("Patch " + this.applyPatch + " applied"));
        }
    }

    private void generateArchetype() throws IOException, SAXException, XPathExpressionException {
        this.getLog().info((CharSequence)("Generating archetype from " + this.exampleProjectPath));
        File archetypeOutputDir = new File(this.baseDir, "src/main/resources/archetype-resources");
        this.getLog().info((CharSequence)("Removing old files from " + archetypeOutputDir));
        this.cleanOldArchetype(archetypeOutputDir);
        this.getLog().info((CharSequence)("Copying new files to " + archetypeOutputDir));
        this.copyFiles(this.exampleProjectPath, archetypeOutputDir);
    }

    private void cleanOldArchetype(File archetypeOutputDir) {
        for (File file : archetypeOutputDir.listFiles()) {
            if (file.isFile()) {
                file.delete();
                continue;
            }
            this.cleanOldArchetype(file);
        }
    }

    private void copyFiles(File sourceDir, File archetypeOutputDir) throws IOException, SAXException, XPathExpressionException {
        for (File file : sourceDir.listFiles()) {
            if (file.isFile()) {
                String relativePathWithoutPackage;
                if (file.getName().equals("pom.xml")) {
                    this.findPomMetadata(file);
                }
                String rootPath = this.exampleProjectPath.getPath();
                String relativePath = file.getPath().replace(rootPath, "");
                String pathInterpolated = relativePathWithoutPackage = relativePath.replace(this.rootPackage.replace(".", File.separator), "");
                for (String value : this.archetypeExpressionReplaceValues) {
                    pathInterpolated = pathInterpolated.replace(value, "__" + this.artifactExpression + "__");
                }
                pathInterpolated = pathInterpolated.replace(this.projectPath, "__" + this.artifactExpression + "__");
                File dest = new File(archetypeOutputDir, pathInterpolated);
                dest.getParentFile().mkdirs();
                dest.createNewFile();
                if (this.isTextFile(file)) {
                    BufferedReader br = new BufferedReader(new FileReader(file));
                    BufferedWriter bw = new BufferedWriter(new FileWriter(dest));
                    this.getLog().debug((CharSequence)("Copying from " + file + " to " + dest));
                    while (br.ready()) {
                        String line;
                        String content = line = br.readLine();
                        if (dest.getName().equals("pom.xml")) {
                            content = this.getPomLine(line);
                        }
                        boolean ignored = false;
                        for (String ignoredString : this.ignoredArchetypeExpressionReplaceValues) {
                            if (content.contains(ignoredString)) {
                                ignored = true;
                            }
                            if (ignored) continue;
                            for (String key : this.archetypeExpressionReplaceValues) {
                                content = content.replaceAll(key, "\\${" + this.artifactExpression + "}");
                            }
                            for (String key : this.replaceValueWithExpression.keySet()) {
                                String value = "\\${" + this.replaceValueWithExpression.get(key) + "}";
                                content = content.replaceAll(key, value);
                            }
                            content = content.replaceAll(this.rootPackage, "\\${package}").replaceAll(this.projectPath, "\\${" + this.artifactExpression + "}");
                        }
                        bw.write(content + "\n");
                    }
                    this.closeStreams(br, bw);
                    continue;
                }
                BufferedInputStream bis = new BufferedInputStream(new FileInputStream(file));
                BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(dest));
                int buffer = 0;
                while ((buffer = bis.read()) != -1) {
                    bos.write(buffer);
                }
                this.closeStreams(bis, bos);
                continue;
            }
            if (!file.isDirectory()) continue;
            this.copyFiles(file, archetypeOutputDir);
        }
    }

    private boolean isTextFile(File file) {
        int i = file.getName().lastIndexOf(46);
        String fileExtension = file.getName().substring(i + 1);
        for (String ext : TEXT_EXTENSIONS) {
            if (!ext.equals(fileExtension)) continue;
            return true;
        }
        return false;
    }

    private void findPomMetadata(File file) throws XPathExpressionException, FileNotFoundException, IOException, SAXException {
        this.getLog().info((CharSequence)("Finding metadata for " + file));
        Document doc = PositionalXMLReader.readXML(new FileInputStream(file));
        Node node = (Node)this.xPath.evaluate("//groupId", doc, XPathConstants.NODE);
        this.originalGroupId = node.getTextContent();
        node = (Node)this.xPath.evaluate("//artifactId", doc, XPathConstants.NODE);
        this.originalArtifactId = node.getTextContent();
        node = (Node)this.xPath.evaluate("//version", doc, XPathConstants.NODE);
        this.originalVersion = node.getTextContent();
    }

    private String getPomLine(String line) {
        if (line.trim().startsWith("<groupId>" + this.originalGroupId + "</groupId>")) {
            return line.replaceAll(this.originalGroupId, "\\${groupId}");
        }
        if (line.trim().startsWith("<artifactId>" + this.originalArtifactId + "</artifactId>")) {
            return line.replaceAll(this.originalArtifactId, "\\${" + this.artifactExpression + "}");
        }
        if (line.trim().startsWith("<version>" + this.originalVersion + "</version>")) {
            return line.replaceAll(this.originalVersion, "\\${version}");
        }
        return line;
    }

    private void closeStreams(Closeable ... closeables) throws IOException {
        for (Closeable closeable : closeables) {
            if (closeable == null) continue;
            closeable.close();
        }
    }

    private void cloneOriginProject() throws IOException, InvalidRemoteException, TransportException, GitAPIException {
        File gitLocalRepo = new File(this.outputPath + File.separator + "git");
        if (!gitLocalRepo.exists()) {
            this.getLog().info((CharSequence)("Cloning " + this.projectGitRepo + " to " + gitLocalRepo));
            CloneCommand clone = Git.cloneRepository();
            clone.setBare(false);
            clone.setCloneAllBranches(true);
            clone.setDirectory(gitLocalRepo).setURI(this.projectGitRepo);
            clone.call();
        }
        this.getLog().info((CharSequence)("Checking out " + this.branch + " branch"));
        Git.open((File)gitLocalRepo).checkout().setName(this.branch).call();
    }
}

