/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.maven.plugins.qstools;

import java.io.FileInputStream;
import java.net.URL;
import java.util.List;
import java.util.Properties;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.interpolation.InterpolationException;
import org.jboss.maven.plugins.qstools.DependencyProvider;
import org.jboss.maven.plugins.qstools.config.ConfigurationProvider;
import org.jboss.maven.plugins.qstools.config.Rules;
import org.jboss.maven.plugins.qstools.maven.MavenDependency;
import org.jboss.maven.plugins.qstools.xml.PositionalXMLReader;
import org.jboss.maven.plugins.qstools.xml.XMLUtil;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Mojo(name="updateBoms", defaultPhase=LifecyclePhase.PACKAGE, requiresDependencyResolution=ResolutionScope.COMPILE, requiresProject=true, threadSafe=true, aggregator=true)
public class BomUpdaterMojo
extends AbstractMojo {
    @Parameter(property="reactorProjects", readonly=true, required=true)
    private List<MavenProject> reactorProjects;
    @Component
    private DependencyProvider dependencyProvider;
    @Component
    private ConfigurationProvider configurationProvider;
    @Parameter(defaultValue="${session}", readonly=true)
    private MavenSession mavenSession;
    @Component
    private PlexusContainer container;
    private boolean pomModified = false;
    private int updatedProjects = 0;
    @Parameter(property="qstools.configFileURL", defaultValue="https://raw.github.com/jboss-developer/maven-qstools-plugin/master/config/qstools_config.yaml")
    private URL configFileURL;
    private XPath xPath = XPathFactory.newInstance().newXPath();

    public void execute() throws MojoExecutionException, MojoFailureException {
        try {
            this.configure();
            this.getLog().warn((CharSequence)"Running this plugin CAN MODIFY your pom.xml files. Make sure to have your changes commited before running this plugin");
            this.getLog().warn((CharSequence)"Do you want to continue[yes/no]");
            String answer = System.console().readLine();
            if (answer.equalsIgnoreCase("yes")) {
                for (MavenProject project : this.reactorProjects) {
                    this.processProject(project);
                }
                this.getLog().info((CharSequence)(" ***** All projects were processed! Total Processed: " + this.reactorProjects.size() + " - Total Updates: " + this.updatedProjects + "\nRun [mvn clean compile] to get sure that everything is working" + "\nRun [git diff] to see the changes made." + "\n"));
            } else {
                this.getLog().info((CharSequence)"Aborted");
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException(e.getMessage(), e);
        }
    }

    private void configure() {
        this.getLog().info((CharSequence)("Using the following QSTools config file: " + this.configFileURL));
        this.container.getContext().put((Object)"qstools.configFileURL", (Object)this.configFileURL);
        this.container.getContext().put((Object)"qstools.log", (Object)this.getLog());
        this.container.getContext().put((Object)"qstools.mavenSession", (Object)this.mavenSession);
    }

    private void processProject(MavenProject project) throws Exception {
        this.pomModified = false;
        Rules rules = this.configurationProvider.getQuickstartsRules(project.getGroupId());
        this.getLog().debug((CharSequence)("Processing " + project.getArtifactId()));
        Document doc = PositionalXMLReader.readXML(new FileInputStream(project.getFile()));
        NodeList dependencies = (NodeList)this.xPath.evaluate("/project/dependencyManagement/dependencies/dependency", doc, XPathConstants.NODESET);
        this.replaceBOMsIfNeeded(project, dependencies, rules);
        this.updateBomsVersionIfNeeded(project, dependencies, rules, doc);
        if (this.pomModified) {
            this.getLog().info((CharSequence)("*** Saving changes to " + project.getFile() + "\n"));
            ++this.updatedProjects;
            XMLUtil.writeXML(doc, project.getFile());
        }
    }

    private void updateBomsVersionIfNeeded(MavenProject project, NodeList dependencies, Rules rules, Document doc) throws InterpolationException, XPathExpressionException {
        for (int x = 0; x < dependencies.getLength(); ++x) {
            Node dependency = dependencies.item(x);
            MavenDependency mavenDependency = this.dependencyProvider.getDependencyFromNode(project, dependency);
            String version = mavenDependency.getInterpoledVersion();
            String expectedBomVersion = (String)rules.getExpectedBomVersion().get(mavenDependency.getGroupId());
            if (expectedBomVersion == null || expectedBomVersion.equals(version)) continue;
            String declaredVersion = mavenDependency.getDeclaredVersion().replace("${", "").replace("}", "");
            if (project.getProperties().get(declaredVersion) != null) {
                Node propertyNode = (Node)this.xPath.evaluate("/project/properties/" + declaredVersion, doc, XPathConstants.NODE);
                if (propertyNode == null) continue;
                this.getLog().info((CharSequence)("Updating property [" + declaredVersion + "] from " + version + " to " + expectedBomVersion));
                this.pomModified = true;
                propertyNode.setTextContent(expectedBomVersion);
                continue;
            }
            Node propertiesNode = (Node)this.xPath.evaluate("/project/properties", doc, XPathConstants.NODE);
            String comment = String.format("Automatically created property by QSTools for\n        %s:%s BOM", mavenDependency.getGroupId(), mavenDependency.getArtifactId());
            Comment commentNode = doc.createComment(comment);
            this.getLog().info((CharSequence)("* CREATING property [" + declaredVersion + "] with value " + expectedBomVersion));
            this.pomModified = true;
            Element propertyNode = doc.createElement(declaredVersion);
            propertyNode.setTextContent(expectedBomVersion);
            propertiesNode.appendChild(doc.createTextNode("\n        "));
            propertiesNode.appendChild(commentNode);
            propertiesNode.appendChild(doc.createTextNode("\n        "));
            propertiesNode.appendChild(propertyNode);
        }
    }

    private void replaceBOMsIfNeeded(MavenProject project, NodeList dependencies, Rules rules) throws InterpolationException {
        Properties bomsMigration = rules.getProjectBomsMigration();
        for (int x = 0; x < dependencies.getLength(); ++x) {
            Node dependency = dependencies.item(x);
            MavenDependency mavenDependency = this.dependencyProvider.getDependencyFromNode(project, dependency);
            String oldBomGA = mavenDependency.getGroupId() + "|" + mavenDependency.getArtifactId();
            String newBomGAV = bomsMigration.getProperty(oldBomGA);
            if ("REMOVE".equals(newBomGAV)) {
                this.removeDependency(dependency);
                continue;
            }
            if (newBomGAV == null) continue;
            this.getLog().info((CharSequence)("Replacing " + oldBomGA + " BOM by " + newBomGAV));
            this.pomModified = true;
            String[] newBomGavSplited = newBomGAV.split("[|]");
            this.updateBomNode(dependency, newBomGavSplited[0], newBomGavSplited[1], newBomGavSplited[2]);
        }
    }

    private void removeDependency(Node dependency) {
        Node commentNode = null;
        if (dependency.getPreviousSibling() != null && dependency.getPreviousSibling() != null && dependency.getPreviousSibling().getPreviousSibling().getNodeType() == 8) {
            commentNode = dependency.getPreviousSibling().getPreviousSibling();
        }
        if (commentNode != null) {
            XMLUtil.removePreviousWhiteSpace(commentNode);
            commentNode.getParentNode().removeChild(commentNode);
        }
        dependency.getParentNode().removeChild(dependency);
    }

    private void updateBomNode(Node dependencyNode, String groupId, String artifactId, String version) {
        NodeList childrenNodes = dependencyNode.getChildNodes();
        for (int i = 0; i < childrenNodes.getLength(); ++i) {
            Node node = childrenNodes.item(i);
            if (node.getNodeName().equals("groupId")) {
                node.setTextContent(groupId);
                continue;
            }
            if (node.getNodeName().equals("artifactId")) {
                node.setTextContent(artifactId);
                continue;
            }
            if (!node.getNodeName().equals("version")) continue;
            node.setTextContent("${" + version + "}");
        }
    }
}

