/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.maven.plugins.qstools;

import java.io.Console;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.StringReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.BuildPluginManager;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.utils.StringUtils;
import org.codehaus.plexus.PlexusContainer;
import org.jboss.maven.plugins.qstools.Utils;
import org.jboss.maven.plugins.qstools.common.ProjectUtil;
import org.jboss.maven.plugins.qstools.config.ConfigurationProvider;
import org.jboss.maven.plugins.qstools.config.Rules;
import org.jboss.maven.plugins.qstools.fixers.PomElementOrderFixer;
import org.jboss.maven.plugins.qstools.fixers.QSFixer;
import org.jboss.maven.plugins.qstools.xml.PositionalXMLReader;
import org.jboss.maven.plugins.qstools.xml.XMLUtil;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

@Mojo(name="repositories", defaultPhase=LifecyclePhase.VERIFY, requiresDependencyResolution=ResolutionScope.COMPILE, requiresProject=true, threadSafe=true, aggregator=true)
public class QSRepositoriesMojo
extends AbstractMojo {
    @Parameter(defaultValue="${session}", readonly=true)
    private MavenSession mavenSession;
    @Parameter(defaultValue="${project}", readonly=true)
    private MavenProject mavenProject;
    @Parameter(property="qstools.configFileURL", defaultValue="https://raw.github.com/jboss-developer/maven-qstools-plugin/master/config/qstools_config.yaml")
    private URL configFileURL;
    @Parameter(property="reactorProjects", readonly=true, required=true)
    private List<MavenProject> reactorProjects;
    @Component
    private ConfigurationProvider configurationProvider;
    @Component
    private PlexusContainer container;
    @Component
    private ProjectUtil projectUtil;
    @Component
    private BuildPluginManager pluginManager;
    private XPath xPath = XPathFactory.newInstance().newXPath();

    public void execute() throws MojoExecutionException, MojoFailureException {
        try {
            this.getLog().warn((CharSequence)"Running this plugin CAN MODIFY your files. Make sure to have your changes commited before running this plugin");
            this.getLog().warn((CharSequence)"Do you want to continue[yes/NO]");
            Console console = System.console();
            String answer = console.readLine();
            if (answer.equalsIgnoreCase("yes")) {
                this.configurePlugin();
                Rules rules = this.configurationProvider.getQuickstartsRules(this.mavenProject.getGroupId());
                Map<String, String> repositories = rules.getMavenApprovedRepositories();
                HashSet<String> repositoriesSelected = new HashSet<String>();
                ArrayList<String> repoIds = new ArrayList<String>(repositories.keySet());
                while (!answer.matches("(Q|q)|(R|r)")) {
                    this.getLog().warn((CharSequence)"Please select the Maven repositories that you want to define. Selected repositories are denoted by a leading '*'.");
                    int x = 0;
                    StringBuilder sb = new StringBuilder("\n");
                    for (String repository : repoIds) {
                        String part1 = "  " + (repositoriesSelected.contains(repository) ? "* " : "  ") + ++x + " - " + repository;
                        String part1padded = StringUtils.rightPad((String)part1, (int)45);
                        String part2 = " - " + repositories.get(repository) + "\n";
                        sb.append(part1padded + part2);
                    }
                    sb.append("    A - Select All                            - Add all repositories to the list to be run\n");
                    sb.append("    N - Select None                           - Remove all currently selected repositories from the list to be run\n");
                    sb.append("\n");
                    sb.append("    R - Run the plugin to add the selected repositories (denoted by an *)\n");
                    sb.append("    Q - Quit without running any fixers\n");
                    sb.append("\n");
                    sb.append("Enter the number of the repository to select/deselect it. Enter 'A' to select all. Enter 'N' to deselect all. ");
                    sb.append("\n\nWhen ready, enter 'R' to add the selected repositories or 'Q' to quit.");
                    this.getLog().info((CharSequence)sb);
                    answer = console.readLine();
                    if (answer.matches("[1-9][0-9]*")) {
                        String selectedRepository = (String)repoIds.get(Integer.parseInt(answer) - 1);
                        if (repositoriesSelected.contains(selectedRepository)) {
                            repositoriesSelected.remove(selectedRepository);
                            continue;
                        }
                        repositoriesSelected.add(selectedRepository);
                        continue;
                    }
                    if (answer.equalsIgnoreCase("A")) {
                        repositoriesSelected.addAll(repositories.keySet());
                        continue;
                    }
                    if (!answer.equalsIgnoreCase("N")) continue;
                    repositoriesSelected.clear();
                }
                if (answer.equalsIgnoreCase("R")) {
                    this.removePreviousRepositories();
                    this.setupRepositories(repositories, repositoriesSelected, rules);
                    this.getLog().info((CharSequence)(" ***** All projects were processed! Total Processed: " + this.reactorProjects.size() + "\nRun [mvn clean compile] to get sure that everything is working" + "\nRun [git diff] to see the changes made." + "\n"));
                }
            } else {
                this.getLog().info((CharSequence)"Aborted");
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException(e.getMessage(), e);
        }
    }

    private void configurePlugin() {
        this.getLog().info((CharSequence)("Using the following QSTools config file: " + this.configFileURL));
        this.container.getContext().put((Object)"qstools.configFileURL", (Object)this.configFileURL);
        this.container.getContext().put((Object)"qstools.log", (Object)this.getLog());
        this.container.getContext().put((Object)"qstools.mavenSession", (Object)this.mavenSession);
        this.container.getContext().put((Object)"qstools.ignored.quickstarts", Utils.readIgnoredFile());
        this.container.getContext().put((Object)"qstools.plugin_manager", (Object)this.pluginManager);
    }

    private void removePreviousRepositories() throws Exception {
        this.getLog().info((CharSequence)"Removing previous repositories definition...");
        for (MavenProject project : this.reactorProjects) {
            if (this.projectUtil.isSubProjec(project)) continue;
            Document doc = PositionalXMLReader.readXML(new FileInputStream(project.getFile()));
            this.removeRepositoryDefinition(project, doc, "repositories");
            this.removeRepositoryDefinition(project, doc, "pluginRepositories");
            XMLUtil.writeXML(doc, project.getFile());
        }
    }

    private void removeRepositoryDefinition(MavenProject project, Document doc, String repository) throws XPathExpressionException {
        Node repositoriesNode = (Node)this.xPath.evaluate("//project/" + repository, doc, XPathConstants.NODE);
        if (repositoriesNode != null) {
            Node commentNode = null;
            if (repositoriesNode.getPreviousSibling() != null && repositoriesNode.getPreviousSibling().getPreviousSibling() != null && repositoriesNode.getPreviousSibling().getPreviousSibling().getNodeType() == 8) {
                commentNode = repositoriesNode.getPreviousSibling().getPreviousSibling();
            }
            if (commentNode != null) {
                XMLUtil.removePreviousWhiteSpace(commentNode);
                commentNode.getParentNode().removeChild(commentNode);
            }
            XMLUtil.removePreviousWhiteSpace(repositoriesNode);
            repositoriesNode.getParentNode().removeChild(repositoriesNode);
        }
    }

    private void setupRepositories(Map<String, String> repositories, Set<String> repositoriesSelected, Rules rules) throws Exception {
        this.getLog().info((CharSequence)"Adding selected repositories");
        for (MavenProject project : this.reactorProjects) {
            if (this.projectUtil.isSubProjec(project)) continue;
            Document doc = PositionalXMLReader.readXML(new FileInputStream(project.getFile()));
            this.createRepositoryDefinition(project, doc, repositories, repositoriesSelected, rules, "repositories", "repository", true);
            this.createRepositoryDefinition(project, doc, repositories, repositoriesSelected, rules, "pluginRepositories", "pluginRepository", false);
            XMLUtil.writeXML(doc, project.getFile());
            this.getLog().debug((CharSequence)("Sorting " + project.getFile() + "elements order"));
            PomElementOrderFixer pomElementOrderFixer = (PomElementOrderFixer)this.container.lookup(PomElementOrderFixer.class, QSFixer.ROLE, "PomElementOrderFixer");
            pomElementOrderFixer.fixProject(project, doc);
        }
    }

    private void createRepositoryDefinition(MavenProject project, Document doc, Map<String, String> repositories, Set<String> repositoriesSelected, Rules rules, String repositoriesType, String repositoryType, boolean createComment) throws XPathExpressionException, SAXException, IOException, ParserConfigurationException {
        String complement = "<complement><releases>\n                <enabled>RELEASE</enabled>\n            </releases><snapshots>\n                <enabled>SNAPSHOT</enabled>\n            </snapshots></complement>";
        Node repositoriesElement = (Node)this.xPath.evaluate("//project/" + repositoriesType, doc, XPathConstants.NODE);
        if (repositoriesElement == null && repositoriesSelected.size() > 0) {
            Comment comment = doc.createComment(rules.getMavenRepositoryComment());
            repositoriesElement = doc.createElement(repositoriesType);
            Element projectElement = (Element)this.xPath.evaluate("/project", doc, XPathConstants.NODE);
            if (createComment) {
                projectElement.appendChild(comment);
                projectElement.appendChild(doc.createTextNode("\n    "));
            }
            projectElement.appendChild(repositoriesElement);
        }
        for (String repository : repositoriesSelected) {
            this.getLog().debug((CharSequence)("Adding " + repository + " to " + project.getFile()));
            Element repositoryElement = doc.createElement(repositoryType);
            Element idElement = doc.createElement("id");
            idElement.setTextContent(repository);
            repositoryElement.appendChild(idElement);
            Element urlElement = doc.createElement("url");
            String[] repo = repositories.get(repository).split("[|]");
            urlElement.setTextContent(repo[0]);
            repositoryElement.appendChild(urlElement);
            String parsedComplement = complement.replace("RELEASE", repo[1]).replace("SNAPSHOT", repo[2]);
            Document d = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new InputSource(new StringReader(parsedComplement)));
            repositoryElement.appendChild(doc.importNode(d.getFirstChild().getFirstChild(), true));
            repositoryElement.appendChild(doc.importNode(d.getFirstChild().getLastChild(), true));
            repositoriesElement.appendChild(repositoryElement);
        }
    }
}

